/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class LafPreference
implements SubPreferenceSetting {
    private JosmComboBox<UIManager.LookAndFeelInfo> lafCombo;
    VerticallyScrollablePanel panel;
    private final JCheckBox showSplashScreen = new JCheckBox(I18n.tr("Show splash screen at startup", new Object[0]));
    private final JCheckBox showID = new JCheckBox(I18n.tr("Show object ID in selection lists", new Object[0]));
    private final JCheckBox showLocalizedName = new JCheckBox(I18n.tr("Show localized name in selection lists", new Object[0]));
    private final JCheckBox modeless = new JCheckBox(I18n.tr("Modeless working (Potlatch style)", new Object[0]));
    private final JCheckBox dynamicButtons = new JCheckBox(I18n.tr("Dynamic buttons in side menus", new Object[0]));
    private final JCheckBox isoDates = new JCheckBox(I18n.tr("Display ISO dates", new Object[0]));
    private final JCheckBox nativeFileChoosers = new JCheckBox(I18n.tr("Use native file choosers (nicer, but do not support file filters)", new Object[0]));
    private final JCheckBox zoomReverseWheel = new JCheckBox(I18n.tr("Reverse zoom with mouse wheel", new Object[0]));
    private final JCheckBox zoomIntermediateSteps = new JCheckBox(I18n.tr("Intermediate steps between native resolutions", new Object[0]));
    private JSpinner spinZoomRatio;

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        Object object;
        this.lafCombo = new JosmComboBox<UIManager.LookAndFeelInfo>(UIManager.getInstalledLookAndFeels());
        if (Main.isPlatformOsx()) {
            try {
                object = Class.forName("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                Object obj = ((Class)object).getConstructor(null).newInstance(null);
                this.lafCombo.addItem(new UIManager.LookAndFeelInfo(((LookAndFeel)obj).getName(), "ch.randelshofer.quaqua.QuaquaLookAndFeel"));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Main.debug(reflectiveOperationException);
            }
        }
        object = Main.pref.get("laf", Main.platform.getDefaultStyle());
        for (int i = 0; i < this.lafCombo.getItemCount(); ++i) {
            if (!((UIManager.LookAndFeelInfo)this.lafCombo.getItemAt(i)).getClassName().equals(object)) continue;
            this.lafCombo.setSelectedIndex(i);
            break;
        }
        this.lafCombo.setRenderer(new ListCellRenderer<UIManager.LookAndFeelInfo>(){
            private final DefaultListCellRenderer def = new DefaultListCellRenderer();

            @Override
            public Component getListCellRendererComponent(JList<? extends UIManager.LookAndFeelInfo> jList, UIManager.LookAndFeelInfo lookAndFeelInfo, int n, boolean bl, boolean bl2) {
                return this.def.getListCellRendererComponent(jList, lookAndFeelInfo.getName(), n, bl, bl2);
            }
        });
        this.panel = new VerticallyScrollablePanel(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.showSplashScreen.setToolTipText(I18n.tr("Show splash screen at startup", new Object[0]));
        this.showSplashScreen.setSelected(Main.pref.getBoolean("draw.splashscreen", true));
        this.panel.add((Component)this.showSplashScreen, GBC.eop().insets(20, 0, 0, 0));
        this.showID.setToolTipText(I18n.tr("Show object ID in selection lists", new Object[0]));
        this.showID.setSelected(Main.pref.getBoolean("osm-primitives.showid", false));
        this.showLocalizedName.setToolTipText(I18n.tr("Show localized name in selection lists, if available", new Object[0]));
        this.showLocalizedName.setSelected(Main.pref.getBoolean("osm-primitives.localize-name", true));
        ExpertToggleAction.addVisibilitySwitcher(this.showLocalizedName);
        this.modeless.setToolTipText(I18n.tr("Do not require to switch modes (potlatch style workflow)", new Object[0]));
        this.modeless.setSelected(Main.pref.getBoolean("modeless", false));
        ExpertToggleAction.addVisibilitySwitcher(this.modeless);
        this.panel.add((Component)this.showID, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.showLocalizedName, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.modeless, GBC.eop().insets(20, 0, 0, 0));
        this.dynamicButtons.setToolTipText(I18n.tr("Display buttons in right side menus only when mouse is inside the element", new Object[0]));
        this.dynamicButtons.setSelected(ToggleDialog.PROP_DYNAMIC_BUTTONS.get());
        this.panel.add((Component)this.dynamicButtons, GBC.eop().insets(20, 0, 0, 0));
        Date date = new Date();
        this.isoDates.setToolTipText(I18n.tr("Format dates according to {0}. Today''s date will be displayed as {1} instead of {2}", I18n.tr("ISO 8601", new Object[0]), DateUtils.newIsoDateFormat().format(date), DateFormat.getDateInstance(3).format(date)));
        this.isoDates.setSelected(DateUtils.PROP_ISO_DATES.get());
        this.panel.add((Component)this.isoDates, GBC.eop().insets(20, 0, 0, 0));
        this.nativeFileChoosers.setToolTipText(I18n.tr("Use file choosers that behave more like native ones. They look nicer but do not support some features like file filters", new Object[0]));
        this.nativeFileChoosers.setSelected(FileChooserManager.PROP_USE_NATIVE_FILE_DIALOG.get());
        this.panel.add((Component)this.nativeFileChoosers, GBC.eop().insets(20, 0, 0, 0));
        this.zoomReverseWheel.setToolTipText(I18n.tr("Check if you feel opposite direction more convenient", new Object[0]));
        this.zoomReverseWheel.setSelected(MapMover.PROP_ZOOM_REVERSE_WHEEL.get());
        this.panel.add((Component)this.zoomReverseWheel, GBC.eop().insets(20, 0, 0, 0));
        this.zoomIntermediateSteps.setToolTipText(I18n.tr("Divide intervals between native resolution levels to smaller steps if they are much larger than zoom ratio", new Object[0]));
        this.zoomIntermediateSteps.setSelected(NavigatableComponent.PROP_ZOOM_INTERMEDIATE_STEPS.get());
        ExpertToggleAction.addVisibilitySwitcher(this.zoomIntermediateSteps);
        this.panel.add((Component)this.zoomIntermediateSteps, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add(Box.createVerticalGlue(), GBC.eol().insets(0, 10, 0, 0));
        double d = Math.log(2.0) / Math.log(NavigatableComponent.PROP_ZOOM_RATIO.get());
        d = Math.max(1.0, d);
        d = Math.min(5.0, d);
        JLabel jLabel = new JLabel(I18n.tr("Zoom steps to get double scale", new Object[0]));
        this.spinZoomRatio = new JSpinner(new SpinnerNumberModel(d, 1.0, 5.0, 1.0));
        JComponent jComponent = this.spinZoomRatio.getEditor();
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
        jFormattedTextField.setColumns(2);
        String string = I18n.tr("Higher value means more steps needed, therefore zoom steps will be smaller", new Object[0]);
        this.spinZoomRatio.setToolTipText(string);
        jLabel.setToolTipText(string);
        jLabel.setLabelFor(this.spinZoomRatio);
        this.panel.add((Component)jLabel, GBC.std().insets(20, 0, 0, 0));
        this.panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.panel.add((Component)this.spinZoomRatio, GBC.eol());
        this.panel.add((Component)new JLabel(I18n.tr("Look and Feel", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        this.panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.panel.add(this.lafCombo, GBC.eol().fill(2));
        JScrollPane jScrollPane = this.panel.getVerticalScrollPane();
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        preferenceTabbedPane.getDisplayPreference().addSubTab(this, I18n.tr("Look and Feel", new Object[0]), jScrollPane);
    }

    @Override
    public boolean ok() {
        boolean bl = false;
        Main.pref.put("draw.splashscreen", this.showSplashScreen.isSelected());
        Main.pref.put("osm-primitives.showid", this.showID.isSelected());
        Main.pref.put("osm-primitives.localize-name", this.showLocalizedName.isSelected());
        Main.pref.put("modeless", this.modeless.isSelected());
        Main.pref.put(ToggleDialog.PROP_DYNAMIC_BUTTONS.getKey(), this.dynamicButtons.isSelected());
        Main.pref.put(DateUtils.PROP_ISO_DATES.getKey(), this.isoDates.isSelected());
        Main.pref.put(FileChooserManager.PROP_USE_NATIVE_FILE_DIALOG.getKey(), this.nativeFileChoosers.isSelected());
        MapMover.PROP_ZOOM_REVERSE_WHEEL.put(this.zoomReverseWheel.isSelected());
        NavigatableComponent.PROP_ZOOM_INTERMEDIATE_STEPS.put(this.zoomIntermediateSteps.isSelected());
        NavigatableComponent.PROP_ZOOM_RATIO.put(Math.pow(2.0, 1.0 / (Double)this.spinZoomRatio.getModel().getValue()));
        return bl |= Main.pref.put("laf", ((UIManager.LookAndFeelInfo)this.lafCombo.getSelectedItem()).getClassName());
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getDisplayPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new LafPreference();
        }
    }
}

