/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.AbstractIdTextField;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetIdTextField
extends AbstractIdTextField<ChangesetIdValidator> {
    public ChangesetIdTextField() {
        super(ChangesetIdValidator.class, 10);
    }

    public final int getChangesetId() {
        return ((ChangesetIdValidator)this.validator).id;
    }

    @Override
    public boolean readIds() {
        return ((ChangesetIdValidator)this.validator).readChangesetId();
    }

    public static class ChangesetIdValidator
    extends AbstractTextComponentValidator {
        private int id;

        public ChangesetIdValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            return this.readChangesetId();
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid changeset ID. Please enter an integer value > 0", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter an integer value > 0", new Object[0]));
            }
        }

        public boolean readChangesetId() {
            String string = this.getComponent().getText();
            if (string != null && !string.trim().isEmpty()) {
                this.id = 0;
                try {
                    int n = Integer.parseInt(string.trim());
                    if (n > 0) {
                        this.id = n;
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Main.trace(numberFormatException);
                }
            }
            return false;
        }
    }
}

