/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.specific.sequence_aio.LifelineOccurrence;

public class TextOnLifeline
implements LifelineOccurrence {
    private static final double MIN_WIDTH = 50.0;
    private final String[] lines;

    public TextOnLifeline(String text) {
        this.lines = text.split("\n");
    }

    @Override
    public Line1D draw(DrawHandler drawHandler, PointDouble topLeft, PointDouble size) {
        double height = TextSplitter.getSplitStringHeight(this.lines, (double)size.x, drawHandler);
        double topY = topLeft.y + (size.y - height) / 2.0;
        Line1D interruptedLifeline = new Line1D(topY, topY + height);
        TextSplitter.drawText(drawHandler, this.lines, topLeft.x, topY, size.x, height, AlignHorizontal.CENTER, AlignVertical.CENTER);
        return interruptedLifeline;
    }

    @Override
    public double getMinWidth(DrawHandler drawHandler) {
        return Math.max(50.0, TextSplitter.getTextMinWidth(this.lines, drawHandler));
    }

    @Override
    public double getAdditionalYHeight(DrawHandler drawHandler, PointDouble size) {
        return TextSplitter.getSplitStringHeight(this.lines, (double)size.x, drawHandler) - size.y;
    }
}

