/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Arrays;
import org.openide.util.Lookup;
import org.openide.util.lookup.ExcludingLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.MetaInfServicesLookup;
import org.openide.util.lookup.SimpleLookup;
import org.openide.util.lookup.SimpleProxyLookup;
import org.openide.util.lookup.SingletonLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public class Lookups {
    private Lookups() {
    }

    public static Lookup singleton(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return new SingletonLookup(object);
    }

    public static Lookup fixed(Object ... objectArray) {
        if (objectArray == null) {
            throw new NullPointerException();
        }
        if (objectArray.length == 0) {
            return Lookup.EMPTY;
        }
        if (objectArray.length == 1) {
            return Lookups.singleton(objectArray[0]);
        }
        return new SimpleLookup(Arrays.asList(objectArray));
    }

    public static <T, R> Lookup fixed(T[] TArray, InstanceContent.Convertor<? super T, R> convertor) {
        if (TArray == null) {
            throw new NullPointerException();
        }
        if (convertor == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Arrays.asList(TArray), convertor);
    }

    public static Lookup proxy(Lookup.Provider provider) {
        return new SimpleProxyLookup(provider);
    }

    public static Lookup metaInfServices(ClassLoader classLoader) {
        return new MetaInfServicesLookup(classLoader, "META-INF/services/");
    }

    public static Lookup metaInfServices(ClassLoader classLoader, String string) {
        return new MetaInfServicesLookup(classLoader, string);
    }

    public static Lookup forPath(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return NamedServicesProvider.forPath(string);
    }

    public static Lookup exclude(Lookup lookup, Class ... classArray) {
        return new ExcludingLookup(lookup, classArray);
    }

    public static <T> Lookup.Item<T> lookupItem(T t, String string) {
        return new LookupItem<T>(t, string);
    }

    private static class LookupItem<T>
    extends Lookup.Item<T> {
        private String id;
        private T instance;

        public LookupItem(T t) {
            this(t, null);
        }

        public LookupItem(T t, String string) {
            this.id = string;
            this.instance = t;
        }

        @Override
        public String getDisplayName() {
            return this.getId();
        }

        @Override
        public String getId() {
            return this.id == null ? this.instance.toString() : this.id;
        }

        @Override
        public T getInstance() {
            return this.instance;
        }

        @Override
        public Class<? extends T> getType() {
            return this.instance.getClass();
        }

        public boolean equals(Object object) {
            if (object instanceof LookupItem) {
                return this.instance == ((LookupItem)object).getInstance();
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }
}

