/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectTaskLister;
import org.gradle.api.internal.tasks.PublicTaskSpecification;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.DefaultBuildInvocations;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTaskSelector;
import org.gradle.tooling.internal.consumer.converters.TaskNameComparator;
import org.gradle.tooling.provider.model.internal.ProjectSensitiveToolingModelBuilder;

public class BuildInvocationsBuilder
extends ProjectSensitiveToolingModelBuilder {
    private final ProjectTaskLister taskLister;
    private final TaskNameComparator taskNameComparator;

    public BuildInvocationsBuilder(ProjectTaskLister taskLister) {
        this.taskLister = taskLister;
        this.taskNameComparator = new TaskNameComparator();
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.BuildInvocations");
    }

    public DefaultBuildInvocations buildAll(String modelName, Project project, boolean implicitProject) {
        return this.buildAll(modelName, implicitProject ? project.getRootProject() : project);
    }

    public DefaultBuildInvocations buildAll(String modelName, Project project) {
        if (!this.canBuild(modelName)) {
            throw new GradleException("Unknown model name " + modelName);
        }
        ArrayList selectors = Lists.newArrayList();
        TreeMap selectorsByName = Maps.newTreeMap((Comparator)Ordering.natural());
        LinkedHashSet visibleTasks = Sets.newLinkedHashSet();
        this.findTasks(project, selectorsByName, visibleTasks);
        for (String selectorName : selectorsByName.keySet()) {
            LaunchableGradleTaskSelector selector = (LaunchableGradleTaskSelector)selectorsByName.get(selectorName);
            selectors.add(selector.setName(selectorName).setTaskName(selectorName).setProjectPath(project.getPath()).setDisplayName(selectorName + " in " + project + " and subprojects.").setPublic(visibleTasks.contains(selectorName)));
        }
        List<LaunchableGradleTask> projectTasks = this.tasks(project);
        return new DefaultBuildInvocations().setSelectors(selectors).setTasks(projectTasks);
    }

    private List<LaunchableGradleTask> tasks(Project project) {
        ArrayList tasks = Lists.newArrayList();
        for (Task task : this.taskLister.listProjectTasks(project)) {
            tasks.add(ToolingModelBuilderSupport.buildFromTask(new LaunchableGradleTask(), task));
        }
        return tasks;
    }

    private void findTasks(Project project, Map<String, LaunchableGradleTaskSelector> taskSelectors, Collection<String> visibleTasks) {
        for (Project child : project.getChildProjects().values()) {
            this.findTasks(child, taskSelectors, visibleTasks);
        }
        for (Task task : this.taskLister.listProjectTasks(project)) {
            LaunchableGradleTaskSelector taskSelector;
            if (!taskSelectors.containsKey(task.getName())) {
                taskSelector = new LaunchableGradleTaskSelector().setDescription(task.getDescription()).setProjectPath(task.getPath());
                taskSelectors.put(task.getName(), taskSelector);
            } else {
                taskSelector = taskSelectors.get(task.getName());
                if (this.hasPathWithLowerOrdering(task, taskSelector)) {
                    taskSelector.setDescription(task.getDescription()).setProjectPath(task.getPath());
                }
            }
            if (!PublicTaskSpecification.INSTANCE.isSatisfiedBy((Object)task)) continue;
            visibleTasks.add(task.getName());
        }
    }

    private boolean hasPathWithLowerOrdering(Task task, LaunchableGradleTaskSelector referenceTaskSelector) {
        return this.taskNameComparator.compare(task.getPath(), referenceTaskSelector.getProjectPath()) < 0;
    }
}

