/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskTypeTaskStateChanges
extends SimpleTaskStateChanges {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTypeTaskStateChanges.class);
    private static final HashCode NO_ACTION_LOADERS = Hashing.md5().hashString((CharSequence)"no-action-loaders", Charsets.UTF_8);
    private final String taskPath;
    private final String taskClass;
    private final HashCode taskClassLoaderHash;
    private final HashCode taskActionsClassLoaderHash;
    private final TaskExecution previousExecution;

    public TaskTypeTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, String taskPath, Class<? extends TaskInternal> taskClass, Collection<ClassLoader> taskActionClassLoaders, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        String taskClassName = taskClass.getName();
        currentExecution.setTaskClass(taskClassName);
        HashCode taskClassLoaderHash = classLoaderHierarchyHasher.getStrictHash(taskClass.getClassLoader());
        currentExecution.setTaskClassLoaderHash(taskClassLoaderHash);
        HashCode taskActionsClassLoaderHash = TaskTypeTaskStateChanges.calculateActionClassLoaderHash(taskActionClassLoaders, classLoaderHierarchyHasher);
        currentExecution.setTaskActionsClassLoaderHash(taskActionsClassLoaderHash);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Task {} class loader hash: {}", (Object)taskPath, (Object)taskClassLoaderHash);
            LOGGER.info("Task {} actions class loader hash: {}", (Object)taskPath, (Object)taskActionsClassLoaderHash);
        }
        this.taskPath = taskPath;
        this.taskClass = taskClassName;
        this.taskClassLoaderHash = taskClassLoaderHash;
        this.taskActionsClassLoaderHash = taskActionsClassLoaderHash;
        this.previousExecution = previousExecution;
    }

    private static HashCode calculateActionClassLoaderHash(Collection<ClassLoader> taskActionClassLoaders, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActionClassLoaders.isEmpty()) {
            return NO_ACTION_LOADERS;
        }
        Hasher hasher = Hashing.md5().newHasher();
        for (ClassLoader taskActionClassLoader : taskActionClassLoaders) {
            HashCode actionLoaderHash = classLoaderHierarchyHasher.getStrictHash(taskActionClassLoader);
            if (actionLoaderHash == null) {
                return null;
            }
            hasher.putBytes(actionLoaderHash.asBytes());
        }
        return hasher.hash();
    }

    @Override
    protected void addAllChanges(List<TaskStateChange> changes) {
        if (!this.taskClass.equals(this.previousExecution.getTaskClass())) {
            changes.add(new DescriptiveChange("Task '%s' has changed type from '%s' to '%s'.", this.taskPath, this.previousExecution.getTaskClass(), this.taskClass));
            return;
        }
        if (!Objects.equal((Object)this.taskClassLoaderHash, (Object)this.previousExecution.getTaskClassLoaderHash())) {
            changes.add(new DescriptiveChange("Task '%s' class path has changed from %s to %s.", this.taskPath, this.previousExecution.getTaskClassLoaderHash(), this.taskClassLoaderHash));
            return;
        }
        if (!Objects.equal((Object)this.taskActionsClassLoaderHash, (Object)this.previousExecution.getTaskActionsClassLoaderHash())) {
            changes.add(new DescriptiveChange("Task '%s' additional action class path has changed from %s to %s.", this.taskPath, this.previousExecution.getTaskActionsClassLoaderHash(), this.taskActionsClassLoaderHash));
        }
    }
}

