/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.hash.Hasher;

public class DefaultHasher
implements Hasher {
    private static final byte[] SIGNATURE = Hashing.md5().hashString((CharSequence)DefaultHasher.class.getName(), Charsets.UTF_8).asBytes();

    public HashCode hash(File file) {
        try {
            com.google.common.hash.Hasher hasher = Hashing.md5().newHasher();
            hasher.putBytes(SIGNATURE);
            Files.copy((File)file, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
            return hasher.hash();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create MD5 hash for file '%s'.", file), (Throwable)e);
        }
    }
}

