/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleDescriptorConverter;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.IvyDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

class IvyModuleResolveMetaDataBuilder {
    private final List<Artifact> artifacts = Lists.newArrayList();
    private final DefaultModuleDescriptor ivyDescriptor;

    public IvyModuleResolveMetaDataBuilder(DefaultModuleDescriptor module) {
        this.ivyDescriptor = module;
    }

    public void addArtifact(IvyArtifactName newArtifact, Set<String> configurations) {
        this.artifacts.add(new Artifact(newArtifact, configurations));
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public DefaultMutableIvyModuleResolveMetadata build() {
        ModuleDescriptorState descriptorState = IvyModuleDescriptorConverter.forIvyModuleDescriptor((ModuleDescriptor)this.ivyDescriptor);
        for (Artifact artifact : this.artifacts) {
            descriptorState.addArtifact(artifact.getArtifactName(), artifact.getConfigurations());
        }
        List<Configuration> configurations = IvyModuleDescriptorConverter.extractConfigurations((ModuleDescriptor)this.ivyDescriptor);
        List<IvyDependencyMetadata> dependencies = IvyModuleDescriptorConverter.extractDependencies((ModuleDescriptor)this.ivyDescriptor);
        return new DefaultMutableIvyModuleResolveMetadata(descriptorState.getComponentIdentifier(), descriptorState, configurations, dependencies);
    }
}

