/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetadataSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.util.BuildCommencedTimeProvider;

public class DefaultModuleArtifactsCache
implements ModuleArtifactsCache {
    private final BuildCommencedTimeProvider timeProvider;
    private final CacheLockingManager cacheLockingManager;
    private PersistentIndexedCache<ModuleArtifactsKey, ModuleArtifactsCacheEntry> cache;

    public DefaultModuleArtifactsCache(BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        this.timeProvider = timeProvider;
        this.cacheLockingManager = cacheLockingManager;
    }

    private PersistentIndexedCache<ModuleArtifactsKey, ModuleArtifactsCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private PersistentIndexedCache<ModuleArtifactsKey, ModuleArtifactsCacheEntry> initCache() {
        return this.cacheLockingManager.createCache("module-artifacts", new ModuleArtifactsKeySerializer(), new ModuleArtifactsCacheEntrySerializer());
    }

    @Override
    public ModuleArtifactsCache.CachedArtifacts cacheArtifacts(ModuleComponentRepository repository, ComponentIdentifier componentId, String context, BigInteger descriptorHash, Set<? extends ComponentArtifactMetadata> artifacts) {
        ModuleArtifactsKey key = new ModuleArtifactsKey(repository.getId(), componentId, context);
        ModuleArtifactsCacheEntry entry = new ModuleArtifactsCacheEntry(artifacts, this.timeProvider.getCurrentTime(), descriptorHash);
        this.getCache().put((Object)key, (Object)entry);
        return this.createCacheArtifacts(entry);
    }

    @Override
    public ModuleArtifactsCache.CachedArtifacts getCachedArtifacts(ModuleComponentRepository repository, ComponentIdentifier componentId, String context) {
        ModuleArtifactsKey key = new ModuleArtifactsKey(repository.getId(), componentId, context);
        ModuleArtifactsCacheEntry entry = (ModuleArtifactsCacheEntry)this.getCache().get((Object)key);
        if (entry == null) {
            return null;
        }
        return this.createCacheArtifacts(entry);
    }

    private ModuleArtifactsCache.CachedArtifacts createCacheArtifacts(ModuleArtifactsCacheEntry entry) {
        long entryAge = this.timeProvider.getCurrentTime() - entry.createTimestamp;
        return new DefaultCachedArtifacts(entry.artifacts, entry.moduleDescriptorHash, entryAge);
    }

    private static class DefaultCachedArtifacts
    implements ModuleArtifactsCache.CachedArtifacts {
        private final Set<ComponentArtifactMetadata> artifacts;
        private final BigInteger descriptorHash;
        private final long ageMillis;

        private DefaultCachedArtifacts(Set<ComponentArtifactMetadata> artifacts, BigInteger descriptorHash, long ageMillis) {
            this.ageMillis = ageMillis;
            this.artifacts = artifacts;
            this.descriptorHash = descriptorHash;
        }

        @Override
        public Set<ComponentArtifactMetadata> getArtifacts() {
            return this.artifacts;
        }

        @Override
        public BigInteger getDescriptorHash() {
            return this.descriptorHash;
        }

        @Override
        public long getAgeMillis() {
            return this.ageMillis;
        }
    }

    private static class ModuleArtifactsCacheEntrySerializer
    implements Serializer<ModuleArtifactsCacheEntry> {
        private final Serializer<Set<ComponentArtifactMetadata>> artifactsSerializer = new SetSerializer((Serializer)new ComponentArtifactMetadataSerializer());

        private ModuleArtifactsCacheEntrySerializer() {
        }

        public void write(Encoder encoder, ModuleArtifactsCacheEntry value) throws Exception {
            encoder.writeLong(value.createTimestamp);
            byte[] hash = value.moduleDescriptorHash.toByteArray();
            encoder.writeBinary(hash);
            this.artifactsSerializer.write(encoder, (Object)value.artifacts);
        }

        public ModuleArtifactsCacheEntry read(Decoder decoder) throws Exception {
            long createTimestamp = decoder.readLong();
            byte[] encodedHash = decoder.readBinary();
            BigInteger hash = new BigInteger(encodedHash);
            Set artifacts = (Set)this.artifactsSerializer.read(decoder);
            return new ModuleArtifactsCacheEntry(artifacts, createTimestamp, hash);
        }
    }

    private static class ModuleArtifactsCacheEntry {
        private final Set<ComponentArtifactMetadata> artifacts;
        private final BigInteger moduleDescriptorHash;
        private final long createTimestamp;

        ModuleArtifactsCacheEntry(Set<? extends ComponentArtifactMetadata> artifacts, long createTimestamp, BigInteger moduleDescriptorHash) {
            this.artifacts = new LinkedHashSet<ComponentArtifactMetadata>(artifacts);
            this.createTimestamp = createTimestamp;
            this.moduleDescriptorHash = moduleDescriptorHash;
        }
    }

    private static class ModuleArtifactsKeySerializer
    implements Serializer<ModuleArtifactsKey> {
        private final ComponentIdentifierSerializer identifierSerializer = new ComponentIdentifierSerializer();

        private ModuleArtifactsKeySerializer() {
        }

        public void write(Encoder encoder, ModuleArtifactsKey value) throws Exception {
            encoder.writeString((CharSequence)value.repositoryId);
            this.identifierSerializer.write(encoder, value.componentId);
            encoder.writeString((CharSequence)value.context);
        }

        public ModuleArtifactsKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            ComponentIdentifier componentId = this.identifierSerializer.read(decoder);
            String context = decoder.readString();
            return new ModuleArtifactsKey(resolverId, componentId, context);
        }
    }

    private static class ModuleArtifactsKey {
        private final String repositoryId;
        private final ComponentIdentifier componentId;
        private final String context;

        private ModuleArtifactsKey(String repositoryId, ComponentIdentifier componentId, String context) {
            this.repositoryId = repositoryId;
            this.componentId = componentId;
            this.context = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleArtifactsKey)) {
                return false;
            }
            ModuleArtifactsKey that = (ModuleArtifactsKey)o;
            return this.repositoryId.equals(that.repositoryId) && this.componentId.equals(that.componentId) && this.context.equals(that.context);
        }

        public int hashCode() {
            int result = this.repositoryId.hashCode();
            result = 31 * result + this.componentId.hashCode();
            result = 31 * result + this.context.hashCode();
            return result;
        }
    }
}

