/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation;

import java.io.Serializable;
import org.gradle.foundation.ProjectView;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskView
implements Comparable<TaskView>,
Serializable {
    private ProjectView project;
    private String name;
    private String description;
    private boolean isDefault;

    TaskView(ProjectView project, String name, String description, boolean isDefault) {
        this.project = project;
        this.name = name;
        this.isDefault = isDefault;
        this.description = (String)GUtil.elvis((Object)description, (Object)"");
    }

    public ProjectView getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return !this.description.equals("");
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public int compareTo(TaskView otherTask) {
        int projectComparison = this.project.compareTo(otherTask.getProject());
        if (projectComparison != 0) {
            return projectComparison;
        }
        return this.name.compareTo(otherTask.name);
    }

    public String toString() {
        return this.name;
    }

    public String getFullTaskName() {
        return this.project.getFullProjectName() + ':' + this.name;
    }
}

