/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.plaf.metal.MetalButtonUI;
import org.gradle.gradleplugin.userinterface.swing.common.BorderlessUtility;

public class BorderlessImageButton
extends JButton {
    private Color oldBackgroundColor;

    public BorderlessImageButton(Action action, Icon icon) {
        super(action);
        this.setUI();
        if (action.getValue("SmallIcon") != null) {
            this.setText(null);
        }
        String name = (String)action.getValue("Name");
        InputMap inputMap = this.getInputMap(2);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        inputMap.put(keyStroke, name);
        this.init(icon);
    }

    private void setUI() {
        this.setUI(MetalButtonUI.createUI(this));
    }

    private void init(Icon icon) {
        this.setBorder(BorderlessUtility.DEFAULT_BORDER);
        this.addMouseListener(new HighlightMouseListener());
        this.setText(null);
        if (icon != null) {
            this.setIcon(icon);
            int height = icon.getIconHeight();
            int width = icon.getIconWidth();
            Dimension preferredSize = new Dimension(width + 2, height + 2);
            this.setMinimumSize(preferredSize);
            this.setMaximumSize(preferredSize);
            this.setPreferredSize(preferredSize);
            this.setFocusPainted(false);
        }
    }

    private class HighlightMouseListener
    extends MouseAdapter {
        private HighlightMouseListener() {
        }

        public void mouseEntered(MouseEvent event) {
            if (BorderlessImageButton.this.getAction() != null ? BorderlessImageButton.this.getAction().isEnabled() : BorderlessImageButton.this.isEnabled()) {
                BorderlessImageButton.this.oldBackgroundColor = BorderlessImageButton.this.getBackground();
                BorderlessImageButton.this.setBackground(BorderlessUtility.ON_MOUSE_OVER_BACKGROUND);
                BorderlessImageButton.this.setBorder(BorderlessUtility.ON_MOUSEOVER_BORDER);
            }
        }

        public void mousePressed(MouseEvent event) {
            if (BorderlessImageButton.this.getAction() != null ? BorderlessImageButton.this.getAction().isEnabled() : BorderlessImageButton.this.isEnabled()) {
                BorderlessImageButton.this.setBackground(BorderlessUtility.ON_BUTTON_PRESSED_BACKGROUND);
            }
        }

        public void mouseReleased(MouseEvent event) {
            Rectangle buttonRect;
            if ((BorderlessImageButton.this.getAction() != null ? BorderlessImageButton.this.getAction().isEnabled() : BorderlessImageButton.this.isEnabled()) && (buttonRect = BorderlessImageButton.this.getBounds()).contains((Point2D)event.getPoint())) {
                BorderlessImageButton.this.setBackground(BorderlessUtility.ON_MOUSE_OVER_BACKGROUND);
            }
        }

        public void mouseExited(MouseEvent event) {
            BorderlessImageButton.this.setBackground(BorderlessImageButton.this.oldBackgroundColor);
            BorderlessImageButton.this.setBorder(BorderlessUtility.DEFAULT_BORDER);
        }
    }
}

