/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.script.lang.kotlin.codegen;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.ConstantsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.script.lang.kotlin.codegen.ASMExtensionsKt;
import org.gradle.script.lang.kotlin.codegen.ActionExtensionWriter;
import org.gradle.script.lang.kotlin.codegen.KDoc;
import org.gradle.script.lang.kotlin.codegen.KotlinFileCompiler;
import org.gradle.script.lang.kotlin.codegen.MarkdownKDocProvider;
import org.gradle.script.lang.kotlin.codegen.PredicatesKt;
import org.gradle.script.lang.kotlin.codegen.StandardKotlinFileCompiler;
import org.gradle.script.lang.kotlin.codegen.ZipInputStreamEntry;
import org.gradle.script.lang.kotlin.codegen.ZipInputStreamEntryKt;
import org.gradle.script.lang.kotlin.support.ZipToKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001a\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011j\u0002`\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/gradle/script/lang/kotlin/codegen/ApiExtensionsJarGenerator;", "", "compiler", "Lorg/gradle/script/lang/kotlin/codegen/KotlinFileCompiler;", "onProgress", "Lkotlin/Function0;", "", "(Lorg/gradle/script/lang/kotlin/codegen/KotlinFileCompiler;Lkotlin/jvm/functions/Function0;)V", "getCompiler", "()Lorg/gradle/script/lang/kotlin/codegen/KotlinFileCompiler;", "getOnProgress", "()Lkotlin/jvm/functions/Function0;", "compileExtensionsTo", "outputDir", "Ljava/io/File;", "inputApiJar", "docProvider", "Lkotlin/Function1;", "", "Lorg/gradle/script/lang/kotlin/codegen/KDoc;", "Lorg/gradle/script/lang/kotlin/codegen/KDocProvider;", "extensionsSourceFileName", "generate", "outputFile", "tempDirFor", "writeActionExtensionsTo", "kotlinFile", "gradle-script-kotlin-compileKotlin"})
public final class ApiExtensionsJarGenerator {
    @NotNull
    private final KotlinFileCompiler compiler;
    @NotNull
    private final Function0<Unit> onProgress;

    public final void generate(@NotNull File outputFile, @NotNull File inputApiJar) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull((Object)inputApiJar, (String)"inputApiJar");
        File tempDir = this.tempDirFor(outputFile);
        this.compileExtensionsTo(tempDir, inputApiJar);
        ZipToKt.zipTo(outputFile, tempDir);
    }

    private final File tempDirFor(File outputFile) {
        File file = FilesKt.createTempDir$default((String)FilesKt.getNameWithoutExtension((File)outputFile), (String)FilesKt.getExtension((File)outputFile), null, (int)4, null);
        File $receiver = file;
        $receiver.deleteOnExit();
        return file;
    }

    private final void compileExtensionsTo(File outputDir, File inputApiJar) {
        File sourceFile = new File(outputDir, this.extensionsSourceFileName());
        this.writeActionExtensionsTo(sourceFile, inputApiJar);
        this.compiler.compileToDirectory(outputDir, sourceFile, CollectionsKt.listOf((Object)inputApiJar));
    }

    private final String extensionsSourceFileName() {
        return StringsKt.replace$default((String)ActionExtensionWriter.Companion.getPackageName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + "/ActionExtensions.kt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeActionExtensionsTo(File kotlinFile, File inputApiJar) {
        Object object = kotlinFile;
        File $receiver = object;
        $receiver.getParentFile().mkdirs();
        Charset charset = null;
        int $i$a$1$apply = 0;
        int n = 3;
        Object object2 = null;
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedWriter");
        }
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            $i$a$1$apply = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        object2 = object;
        Object object3 = object2;
        object3 = new FileOutputStream((File)object3);
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, $i$a$1$apply);
        boolean bl = false;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            ActionExtensionWriter extensionWriter = new ActionExtensionWriter(writer, this.docProvider());
            ZipInputStreamEntryKt.forEachZipEntryIn(inputApiJar, (Function1<? super ZipInputStreamEntry, Unit>)((Function1)new Function1<ZipInputStreamEntry, Unit>(extensionWriter, this, inputApiJar){
                final /* synthetic */ ActionExtensionWriter $extensionWriter;
                final /* synthetic */ ApiExtensionsJarGenerator this$0;
                final /* synthetic */ File $inputApiJar$inlined;
                {
                    this.$extensionWriter = actionExtensionWriter;
                    this.this$0 = apiExtensionsJarGenerator;
                    this.$inputApiJar$inlined = file;
                    super(1);
                }

                public final void invoke(ZipInputStreamEntry $receiver) {
                    if (PredicatesKt.isApiClassEntry($receiver)) {
                        ClassNode classNode = ASMExtensionsKt.classNodeFor($receiver.getZipInputStream());
                        this.$extensionWriter.writeExtensionsFor(classNode);
                    }
                    this.this$0.getOnProgress().invoke();
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            bl = true;
            PlatformImplementationsKt.platformCloseSuppressed((Closeable)object, (Throwable)throwable);
            throw throwable;
        }
        finally {
            if (!bl) {
                object.close();
            }
        }
    }

    private final Function1<String, KDoc> docProvider() {
        return MarkdownKDocProvider.INSTANCE.fromResource("/doc/ActionExtensions.md");
    }

    @NotNull
    public final KotlinFileCompiler getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final Function0<Unit> getOnProgress() {
        return this.onProgress;
    }

    public ApiExtensionsJarGenerator(@NotNull KotlinFileCompiler compiler, @NotNull Function0<Unit> onProgress) {
        Intrinsics.checkParameterIsNotNull((Object)compiler, (String)"compiler");
        Intrinsics.checkParameterIsNotNull(onProgress, (String)"onProgress");
        this.compiler = compiler;
        this.onProgress = onProgress;
    }

    public /* synthetic */ ApiExtensionsJarGenerator(KotlinFileCompiler kotlinFileCompiler, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kotlinFileCompiler = StandardKotlinFileCompiler.INSTANCE;
        }
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(kotlinFileCompiler, (Function0<Unit>)function0);
    }

    public ApiExtensionsJarGenerator() {
        this(null, null, 3, null);
    }
}

