/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.plugins;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJarBinarySpec;
import org.gradle.jvm.internal.DefaultJvmBinarySpec;
import org.gradle.jvm.internal.DefaultJvmLibrarySpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JarFile;
import org.gradle.jvm.internal.JavaPlatformResolver;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.JvmBinarySpecInternal;
import org.gradle.jvm.internal.JvmLibrarySpecInternal;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.tasks.api.ApiJar;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.jvm.toolchain.LocalJava;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolChainRegistry;
import org.gradle.jvm.toolchain.internal.InstalledJdk;
import org.gradle.jvm.toolchain.internal.InstalledJdkInternal;
import org.gradle.jvm.toolchain.internal.InstalledJre;
import org.gradle.jvm.toolchain.internal.JavaInstallationProbe;
import org.gradle.jvm.toolchain.internal.LocalJavaInstallation;
import org.gradle.language.base.internal.ProjectLayout;
import org.gradle.model.Defaults;
import org.gradle.model.Each;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.Hidden;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.util.CollectionUtils;

@Incubating
public class JvmComponentPlugin
implements Plugin<Project> {
    public void apply(Project project) {
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        public void register(TypeBuilder<JvmLibrarySpec> builder) {
            builder.defaultImplementation(DefaultJvmLibrarySpec.class);
            builder.internalView(JvmLibrarySpecInternal.class);
        }

        @ComponentType
        public void registerJvmBinarySpec(TypeBuilder<JvmBinarySpec> builder) {
            builder.defaultImplementation(DefaultJvmBinarySpec.class);
            builder.internalView(JvmBinarySpecInternal.class);
        }

        @ComponentType
        public void registerJarBinarySpec(TypeBuilder<JarBinarySpec> builder) {
            builder.defaultImplementation(DefaultJarBinarySpec.class);
            builder.internalView(JarBinarySpecInternal.class);
        }

        @Model
        @Hidden
        public JavaToolChainRegistry javaToolChain(ServiceRegistry serviceRegistry) {
            JavaToolChainInternal toolChain = (JavaToolChainInternal)serviceRegistry.get(JavaToolChainInternal.class);
            return new DefaultJavaToolChainRegistry(toolChain);
        }

        @Model
        public void javaInstallations(ModelMap<LocalJava> jdks) {
        }

        @Model
        @Hidden
        public void javaToolChains(ModelMap<LocalJavaInstallation> javaInstallations, final JavaInstallationProbe probe) {
            javaInstallations.create("currentGradleJDK", InstalledJdk.class, (Action)new Action<InstalledJdk>(){

                public void execute(InstalledJdk installedJdk) {
                    installedJdk.setJavaHome(Jvm.current().getJavaHome());
                    probe.current(installedJdk);
                }
            });
        }

        private static void validateNoDuplicate(ModelMap<LocalJava> jdks) {
            ListMultimap<String, LocalJava> jdksByPath = Rules.indexByPath(jdks);
            ArrayList errors = Lists.newArrayList();
            for (String path : jdksByPath.keySet()) {
                Rules.checkDuplicateForPath(jdksByPath, path, errors);
            }
            if (!errors.isEmpty()) {
                throw new InvalidModelException(String.format("Duplicate Java installation found:\n%s", Joiner.on((String)"\n").join((Iterable)errors)));
            }
        }

        @Mutate
        public void registerPlatformResolver(PlatformResolvers platformResolvers) {
            platformResolvers.register((PlatformResolver)new JavaPlatformResolver());
        }

        @Model
        @Hidden
        JavaInstallationProbe javaInstallationProbe(ServiceRegistry serviceRegistry) {
            return (JavaInstallationProbe)serviceRegistry.get(JavaInstallationProbe.class);
        }

        @Defaults
        public void resolveJavaToolChains(ModelMap<LocalJavaInstallation> installedJdks, ModelMap<LocalJava> localJavaInstalls, JavaInstallationProbe probe) {
            File currentJavaHome = Rules.canonicalFile(Jvm.current().getJavaHome());
            Rules.validateNoDuplicate(localJavaInstalls);
            for (LocalJava candidate : localJavaInstalls) {
                Class clazz;
                final File javaHome = Rules.canonicalFile(candidate.getPath());
                final JavaInstallationProbe.ProbeResult probeResult = probe.checkJdk(javaHome);
                switch (probeResult.getInstallType()) {
                    case IS_JDK: {
                        clazz = InstalledJdkInternal.class;
                        break;
                    }
                    case IS_JRE: {
                        clazz = InstalledJre.class;
                        break;
                    }
                    case NO_SUCH_DIRECTORY: {
                        throw new InvalidModelException(String.format("Path to JDK '%s' doesn't exist: %s", candidate.getName(), javaHome));
                    }
                    default: {
                        throw new InvalidModelException(String.format("JDK '%s' is not a valid JDK installation: %s\n%s", candidate.getName(), javaHome, probeResult.getError()));
                    }
                }
                if (javaHome.equals(currentJavaHome)) continue;
                installedJdks.create(candidate.getName(), clazz, (Action)new Action<LocalJavaInstallation>(){

                    public void execute(LocalJavaInstallation installedJdk) {
                        installedJdk.setJavaHome(javaHome);
                        probeResult.configure(installedJdk);
                    }
                });
            }
        }

        @ComponentBinaries
        public void createBinaries(ModelMap<JarBinarySpec> binaries, PlatformResolvers platforms, JvmLibrarySpecInternal jvmLibrary) {
            List<JavaPlatform> selectedPlatforms = this.resolvePlatforms(platforms, jvmLibrary);
            final Set<String> exportedPackages = Rules.exportedPackagesOf(jvmLibrary);
            final Collection<DependencySpec> apiDependencies = Rules.apiDependenciesOf(jvmLibrary);
            final Collection<DependencySpec> dependencies = Rules.componentDependenciesOf(jvmLibrary);
            for (final JavaPlatform platform : selectedPlatforms) {
                final BinaryNamingScheme namingScheme = this.namingSchemeFor(jvmLibrary, selectedPlatforms, platform);
                binaries.create(namingScheme.getBinaryName(), (Action)new Action<JarBinarySpec>(){

                    public void execute(JarBinarySpec jarBinarySpec) {
                        JarBinarySpecInternal jarBinary = (JarBinarySpecInternal)jarBinarySpec;
                        jarBinary.setNamingScheme(namingScheme);
                        jarBinary.setTargetPlatform(platform);
                        jarBinary.setExportedPackages(exportedPackages);
                        jarBinary.setApiDependencies(apiDependencies);
                        jarBinary.setDependencies(dependencies);
                    }
                });
            }
        }

        private static File canonicalFile(File f) {
            try {
                return f.getCanonicalFile();
            }
            catch (IOException e) {
                return f;
            }
        }

        private List<JavaPlatform> resolvePlatforms(final PlatformResolvers platformResolver, JvmLibrarySpecInternal jvmLibrarySpec) {
            List<PlatformRequirement> targetPlatforms = jvmLibrarySpec.getTargetPlatforms();
            if (targetPlatforms.isEmpty()) {
                targetPlatforms = Collections.singletonList(DefaultPlatformRequirement.create((String)DefaultJavaPlatform.current().getName()));
            }
            return CollectionUtils.collect(targetPlatforms, (Transformer)new Transformer<JavaPlatform, PlatformRequirement>(){

                public JavaPlatform transform(PlatformRequirement platformRequirement) {
                    return (JavaPlatform)platformResolver.resolve(JavaPlatform.class, platformRequirement);
                }
            });
        }

        private static Set<String> exportedPackagesOf(JvmLibrarySpecInternal jvmLibrary) {
            return jvmLibrary.getApi().getExports();
        }

        private static Collection<DependencySpec> apiDependenciesOf(JvmLibrarySpecInternal jvmLibrary) {
            return jvmLibrary.getApi().getDependencies().getDependencies();
        }

        private static Collection<DependencySpec> componentDependenciesOf(JvmLibrarySpecInternal jvmLibrary) {
            return jvmLibrary.getDependencies().getDependencies();
        }

        private BinaryNamingScheme namingSchemeFor(JvmLibrarySpec jvmLibrary, List<JavaPlatform> selectedPlatforms, JavaPlatform platform) {
            return DefaultBinaryNamingScheme.component((String)jvmLibrary.getName()).withBinaryType("Jar").withRole("jar", true).withVariantDimension((Named)platform, selectedPlatforms);
        }

        @BinaryTasks
        public void createTasks(ModelMap<Task> tasks, final JarBinarySpecInternal binary, @Path(value="buildDir") File buildDir) {
            final File runtimeJarDestDir = binary.getJarFile().getParentFile();
            final String runtimeJarArchiveName = binary.getJarFile().getName();
            String createRuntimeJar = "create" + StringUtils.capitalize((String)binary.getProjectScopedName());
            final JvmAssembly assembly = binary.getAssembly();
            final JarFile runtimeJarFile = binary.getRuntimeJar();
            tasks.create(createRuntimeJar, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Creates the binary file for " + binary + ".");
                    jar.from(new Object[]{assembly.getClassDirectories()});
                    jar.from(new Object[]{assembly.getResourceDirectories()});
                    jar.setDestinationDir(runtimeJarDestDir);
                    jar.setArchiveName(runtimeJarArchiveName);
                    jar.dependsOn(new Object[]{assembly});
                    runtimeJarFile.setBuildTask((Task)jar);
                }
            });
            final JarFile apiJarFile = binary.getApiJar();
            final Set<String> exportedPackages = binary.getExportedPackages();
            String apiJarTaskName = this.apiJarTaskName(binary);
            tasks.create(apiJarTaskName, ApiJar.class, (Action)new Action<ApiJar>(){

                public void execute(ApiJar apiJarTask) {
                    apiJarTask.setDescription("Creates the API binary file for " + binary + ".");
                    apiJarTask.setOutputFile(apiJarFile.getFile());
                    apiJarTask.setExportedPackages(exportedPackages);
                    Rules.this.configureApiJarInputs(apiJarTask, assembly);
                    apiJarTask.dependsOn(new Object[]{assembly});
                    apiJarFile.setBuildTask((Task)apiJarTask);
                }
            });
        }

        private void configureApiJarInputs(ApiJar apiJarTask, JvmAssembly assembly) {
            int counter = 0;
            for (File classDir : assembly.getClassDirectories()) {
                apiJarTask.getInputs().dir((Object)classDir).withPropertyName("classes$" + ++counter).skipWhenEmpty();
            }
        }

        private String apiJarTaskName(JarBinarySpecInternal binary) {
            String binaryName = binary.getProjectScopedName();
            String libName = binaryName.endsWith("Jar") ? binaryName.substring(0, binaryName.length() - 3) : binaryName;
            return libName + "ApiJar";
        }

        private static void checkDuplicateForPath(ListMultimap<String, LocalJava> index, String path, List<String> errors) {
            List localJavas = index.get((Object)path);
            if (localJavas.size() > 1) {
                errors.add(String.format("   - %s are both pointing to the same JDK installation path: %s", Joiner.on((String)", ").join(Iterables.transform((Iterable)localJavas, (Function)new Function<LocalJava, String>(){

                    public String apply(LocalJava input) {
                        return "'" + input.getName() + "'";
                    }
                })), path));
            }
        }

        private static ListMultimap<String, LocalJava> indexByPath(ModelMap<LocalJava> localJavaInstalls) {
            ArrayListMultimap index = ArrayListMultimap.create();
            for (LocalJava localJava : localJavaInstalls) {
                try {
                    index.put((Object)localJava.getPath().getCanonicalPath(), (Object)localJava);
                }
                catch (IOException e) {}
            }
            return index;
        }

        private static List<LocalJava> toImmutableJdkList(ModelMap<LocalJava> jdks) {
            final ArrayList asImmutable = Lists.newArrayList();
            jdks.afterEach((Action)new Action<LocalJava>(){

                public void execute(LocalJava localJava) {
                    asImmutable.add(localJava);
                }
            });
            return asImmutable;
        }

        @Defaults
        void configureJvmBinaries(@Each JvmBinarySpecInternal jvmBinary, ProjectLayout projectLayout) {
            File buildDir = projectLayout.getBuildDir();
            BinaryNamingScheme namingScheme = jvmBinary.getNamingScheme();
            jvmBinary.setClassesDir(namingScheme.getOutputDirectory(buildDir, "classes"));
            jvmBinary.setResourcesDir(namingScheme.getOutputDirectory(buildDir, "resources"));
        }

        @Defaults
        void configureJarBinaries(@Each JarBinarySpecInternal jarBinary, ProjectLayout projectLayout, JavaToolChainRegistry toolChains) {
            String libraryName = jarBinary.getId().getLibraryName();
            File jarsDir = jarBinary.getNamingScheme().getOutputDirectory(projectLayout.getBuildDir(), "jars");
            jarBinary.setJarFile(new File(jarsDir, libraryName + ".jar"));
            jarBinary.setApiJarFile(new File(jarsDir, "api/" + libraryName + ".jar"));
            jarBinary.setToolChain((JavaToolChain)toolChains.getForPlatform(jarBinary.getTargetPlatform()));
        }
    }
}

