/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class ClientProvidedBuildActionRunner
implements BuildActionRunner {
    public void run(BuildAction action, final BuildController buildController) {
        if (!(action instanceof ClientProvidedBuildAction)) {
            return;
        }
        final GradleInternal gradle = buildController.getGradle();
        ClientProvidedBuildAction clientProvidedBuildAction = (ClientProvidedBuildAction)action;
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        final InternalBuildAction clientAction = (InternalBuildAction)payloadSerializer.deserialize(clientProvidedBuildAction.getAction());
        gradle.addBuildListener((BuildListener)new BuildAdapter(){

            public void buildFinished(BuildResult result) {
                if (result.getFailure() == null) {
                    buildController.setResult((Object)ClientProvidedBuildActionRunner.this.buildResult(clientAction, gradle));
                }
            }
        });
        buildController.configure();
    }

    private BuildActionResult buildResult(InternalBuildAction<?> clientAction, GradleInternal gradle) {
        this.forceFullConfiguration(gradle);
        DefaultBuildController internalBuildController = new DefaultBuildController(gradle);
        Object model = null;
        InternalBuildCancelledException failure = null;
        try {
            model = clientAction.execute((InternalBuildController)internalBuildController);
        }
        catch (BuildCancelledException e) {
            failure = new InternalBuildCancelledException((Throwable)e);
        }
        catch (RuntimeException e) {
            failure = new InternalBuildActionFailureException((Throwable)e);
        }
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        if (failure != null) {
            return new BuildActionResult(null, payloadSerializer.serialize((Object)failure));
        }
        return new BuildActionResult(payloadSerializer.serialize(model), null);
    }

    private void forceFullConfiguration(GradleInternal gradle) {
        try {
            ((ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class)).configureHierarchy(gradle.getRootProject());
            for (Project project : gradle.getRootProject().getAllprojects()) {
                ProjectInternal projectInternal = (ProjectInternal)project;
                projectInternal.getTasks().discoverTasks();
                projectInternal.bindAllModelRules();
            }
        }
        catch (BuildCancelledException e) {
            throw new InternalBuildCancelledException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new BuildExceptionVersion1((Throwable)e);
        }
    }

    private PayloadSerializer getPayloadSerializer(GradleInternal gradle) {
        return (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
    }
}

