/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public abstract class TransformationMethodVisitor
extends MethodVisitor {
    private final MethodNode methodNode;
    private final MethodVisitor delegate;

    public TransformationMethodVisitor(@NotNull MethodVisitor delegate2, int access, @NotNull String name, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/codegen/TransformationMethodVisitor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/TransformationMethodVisitor", "<init>"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/TransformationMethodVisitor", "<init>"));
        }
        super(327680);
        this.delegate = delegate2;
        this.methodNode = new MethodNode(access, name, desc, signature2, exceptions);
        this.methodNode.localVariables = new ArrayList<LocalVariableNode>(5);
        this.mv = InlineCodegenUtil.wrapWithMaxLocalCalc(this.methodNode);
    }

    @Override
    public void visitEnd() {
        if (this.methodNode.maxLocals <= 0 || this.methodNode.maxStack <= 0) {
            this.mv.visitMaxs(-1, -1);
        }
        super.visitEnd();
        try {
            if (TransformationMethodVisitor.shouldBeTransformed(this.methodNode)) {
                this.performTransformations(this.methodNode);
            }
            this.methodNode.accept(new EndIgnoringMethodVisitorDecorator(327680, this.delegate));
            if (this.methodNode.instructions.size() == 0) {
                List<LocalVariableNode> localVariables = this.methodNode.localVariables;
                int n = localVariables == null ? 0 : localVariables.size();
                for (int i = 0; i < n; ++i) {
                    localVariables.get(i).accept(this.delegate);
                }
            }
            this.delegate.visitEnd();
        }
        catch (Throwable t) {
            throw new CompilationException("Couldn't transform method node: " + InlineCodegenUtil.getNodeText(this.methodNode), t, null);
        }
    }

    protected abstract void performTransformations(@NotNull MethodNode var1);

    @Nullable
    public TraceMethodVisitor getTraceMethodVisitorIfPossible() {
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(new Textifier());
        try {
            this.methodNode.accept(traceMethodVisitor);
        }
        catch (Throwable e) {
            return null;
        }
        return traceMethodVisitor;
    }

    private static boolean shouldBeTransformed(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/TransformationMethodVisitor", "shouldBeTransformed"));
        }
        return node.instructions.size() > 0;
    }

    private static class EndIgnoringMethodVisitorDecorator
    extends MethodVisitor {
        public EndIgnoringMethodVisitorDecorator(int api, @NotNull MethodVisitor mv) {
            if (mv == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/TransformationMethodVisitor$EndIgnoringMethodVisitorDecorator", "<init>"));
            }
            super(api, mv);
        }

        @Override
        public void visitEnd() {
        }
    }
}

