/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class ModalityStateEx
extends ModalityState {
    private static final WeakReference[] EMPTY_REFS_ARRAY = new WeakReference[0];
    private final WeakReference[] myModalEntities;

    public ModalityStateEx() {
        this(EMPTY_REFS_ARRAY);
    }

    public ModalityStateEx(@NotNull Object[] modalEntities) {
        if (modalEntities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntities", "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ModalityStateEx", "<init>"));
        }
        if (modalEntities.length > 0) {
            this.myModalEntities = new WeakReference[modalEntities.length];
            for (int i = 0; i < modalEntities.length; ++i) {
                Object entity = modalEntities[i];
                this.myModalEntities[i] = new WeakReference<Object>(entity);
            }
        } else {
            this.myModalEntities = EMPTY_REFS_ARRAY;
        }
    }

    private List<Object> getModalEntities() {
        return ContainerUtil.mapNotNull(this.myModalEntities, new Function<WeakReference, Object>(){

            @Override
            public Object fun(WeakReference reference) {
                return reference.get();
            }
        });
    }

    @Override
    @NonNls
    public String toString() {
        if (this.myModalEntities.length == 0) {
            return "ModalityState.NON_MODAL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("ModalityState:");
        for (int i = 0; i < this.myModalEntities.length; ++i) {
            Object entity = this.myModalEntities[i].get();
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(entity);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModalityStateEx)) {
            return false;
        }
        List<Object> entities = this.getModalEntities();
        if (entities.isEmpty()) {
            return false;
        }
        return entities.equals(((ModalityStateEx)o).getModalEntities());
    }

    public int hashCode() {
        return this.getModalEntities().hashCode();
    }
}

