/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.components;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.com.intellij.util.NotNullFunction;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "getService"));
        }
        return ServiceManager.doGetService(ApplicationManager.getApplication(), serviceClass);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "getService"));
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "getService"));
        }
        return ServiceManager.doGetService(project, serviceClass);
    }

    @Nullable
    private static <T> T doGetService(@NotNull ComponentManager componentManager, @NotNull Class<T> serviceClass) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "doGetService"));
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "doGetService"));
        }
        Object instance = componentManager.getPicoContainer().getComponentInstance(serviceClass.getName());
        if (instance == null && (instance = componentManager.getComponent(serviceClass)) != null) {
            Application app = ApplicationManager.getApplication();
            String message = serviceClass.getName() + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
            if (app.isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
        return (T)instance;
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(final @NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "createLazyKey"));
        }
        return NotNullLazyKey.create("Service: " + serviceClass.getName(), new NotNullFunction<Project, T>(){

            @Override
            @NotNull
            public T fun(Project project) {
                Object t = ServiceManager.getService(project, serviceClass);
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager$1", "fun"));
                }
                return t;
            }
        });
    }
}

