/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowPolicy;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class LocalsControlFlowPolicy
implements ControlFlowPolicy {
    private final PsiElement myCodeFragment;

    public LocalsControlFlowPolicy(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "<init>"));
        }
        this.myCodeFragment = codeFragment;
    }

    @Override
    public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "getUsedVariable"));
        }
        if (refExpr.isQualified()) {
            return null;
        }
        PsiElement refElement = refExpr.resolve();
        return refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter ? this.checkCodeFragment(refElement) : null;
    }

    @Nullable
    private PsiVariable checkCodeFragment(@NotNull PsiElement refElement) {
        PsiElement declarationScope;
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "checkCodeFragment"));
        }
        PsiElement codeFragment = refElement instanceof PsiParameter ? ((declarationScope = ((PsiParameter)refElement).getDeclarationScope()) instanceof PsiMethod ? ((PsiMethod)declarationScope).getBody() : (declarationScope instanceof PsiLambdaExpression ? ((PsiLambdaExpression)declarationScope).getBody() : ControlFlowUtil.findCodeFragment(refElement))) : ControlFlowUtil.findCodeFragment(refElement);
        if (codeFragment == null) {
            return null;
        }
        if (!(this.myCodeFragment.getContainingFile() != codeFragment.getContainingFile() || this.myCodeFragment.equals(codeFragment) || this.myCodeFragment.getParent() instanceof PsiLambdaExpression && PsiTreeUtil.isAncestor(PsiTreeUtil.getParentOfType(this.myCodeFragment, PsiClass.class), codeFragment, false))) {
            return null;
        }
        return (PsiVariable)refElement;
    }

    @Override
    public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
        if (psiParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "isParameterAccepted"));
        }
        return this.checkCodeFragment(psiParameter) != null;
    }

    @Override
    public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/LocalsControlFlowPolicy", "isLocalVariableAccepted"));
        }
        return this.checkCodeFragment(psiVariable) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalsControlFlowPolicy policy2 = (LocalsControlFlowPolicy)o;
        return this.myCodeFragment.equals(policy2.myCodeFragment);
    }

    public int hashCode() {
        return this.myCodeFragment.hashCode();
    }
}

