/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.hierarchy;

import java.util.Arrays;

public class IndexTree {
    public static final int PACKAGE = 1;
    public static final int CLASS = 2;
    public static final int STATIC = 8;
    public static final int INTERFACE = 16;
    public static final int ANNOTATION = 32;
    public static final int ENUM = 64;
    public static final int COMPILED = 128;
    public static final int MEMBER = 256;
    public static byte BYTECODE = 0;
    public static byte JAVA = 1;
    public static byte GROOVY = (byte)2;

    public static class MemberDecl
    extends Decl {
        public MemberDecl(Decl[] decls) {
            super(decls);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberDecl that = (MemberDecl)o;
            return Arrays.equals(this.myDecls, that.myDecls);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myDecls);
        }
    }

    public static class ClassDecl
    extends Decl {
        public static final ClassDecl[] EMPTY_ARRAY = new ClassDecl[0];
        public final int myStubId;
        public final int myMods;
        public final String myName;
        public final String[] mySupers;

        public ClassDecl(int stubId, int mods, String name, String[] supers, Decl[] decls) {
            super(decls);
            this.myStubId = stubId;
            this.myMods = mods;
            this.myName = name;
            this.mySupers = supers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassDecl classDecl = (ClassDecl)o;
            if (this.myStubId != classDecl.myStubId) {
                return false;
            }
            if (this.myMods != classDecl.myMods) {
                return false;
            }
            if (this.myName != null ? !this.myName.equals(classDecl.myName) : classDecl.myName != null) {
                return false;
            }
            if (!Arrays.equals(this.mySupers, classDecl.mySupers)) {
                return false;
            }
            return Arrays.equals(this.myDecls, classDecl.myDecls);
        }

        public int hashCode() {
            int result2 = this.myStubId;
            result2 = 31 * result2 + this.myMods;
            result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
            result2 = 31 * result2 + Arrays.hashCode(this.mySupers);
            result2 = 31 * result2 + Arrays.hashCode(this.myDecls);
            return result2;
        }
    }

    public static abstract class Decl {
        public static final Decl[] EMPTY_ARRAY = new Decl[0];
        public final Decl[] myDecls;

        protected Decl(Decl[] decls) {
            this.myDecls = decls;
        }
    }

    public static class Import {
        public static final Import[] EMPTY_ARRAY = new Import[0];
        public final String myFullname;
        public final boolean myStaticImport;
        public final boolean myOnDemand;
        public final String myAlias;

        public Import(String fullname, boolean staticImport, boolean onDemand, String alias) {
            this.myFullname = fullname;
            this.myStaticImport = staticImport;
            this.myOnDemand = onDemand;
            this.myAlias = alias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Import anImport = (Import)o;
            if (this.myStaticImport != anImport.myStaticImport) {
                return false;
            }
            if (this.myOnDemand != anImport.myOnDemand) {
                return false;
            }
            if (!this.myFullname.equals(anImport.myFullname)) {
                return false;
            }
            return !(this.myAlias != null ? !this.myAlias.equals(anImport.myAlias) : anImport.myAlias != null);
        }

        public int hashCode() {
            int result2 = this.myFullname.hashCode();
            result2 = 31 * result2 + (this.myStaticImport ? 1 : 0);
            result2 = 31 * result2 + (this.myOnDemand ? 1 : 0);
            result2 = 31 * result2 + (this.myAlias != null ? this.myAlias.hashCode() : 0);
            return result2;
        }
    }

    public static class Unit {
        public final int myFileId;
        public final String myPackageId;
        public final byte myUnitType;
        public final Import[] imports;
        public final ClassDecl[] myDecls;

        public Unit(int fileId, String packageId, byte unitType, Import[] imports, ClassDecl[] decls) {
            this.myFileId = fileId;
            this.myPackageId = packageId;
            this.myUnitType = unitType;
            this.imports = imports;
            this.myDecls = decls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unit unit = (Unit)o;
            if (this.myFileId != unit.myFileId) {
                return false;
            }
            if (this.myPackageId != null ? !this.myPackageId.equals(unit.myPackageId) : unit.myPackageId != null) {
                return false;
            }
            if (!Arrays.equals(this.imports, unit.imports)) {
                return false;
            }
            return Arrays.equals(this.myDecls, unit.myDecls);
        }

        public int hashCode() {
            int result2 = this.myFileId;
            result2 = 31 * result2 + (this.myPackageId != null ? this.myPackageId.hashCode() : 0);
            result2 = 31 * result2 + Arrays.hashCode(this.imports);
            result2 = 31 * result2 + Arrays.hashCode(this.myDecls);
            return result2;
        }
    }
}

