/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LighterASTNodeVisitor;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.WalkingState;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public abstract class RecursiveLighterASTNodeWalkingVisitor
extends LighterASTNodeVisitor {
    @NotNull
    private final LighterAST ast;
    private final Stack<IndexedLighterASTNode[]> childrenStack;
    private final Stack<IndexedLighterASTNode> parentStack;
    private final WalkingState<IndexedLighterASTNode> myWalkingState;

    protected RecursiveLighterASTNodeWalkingVisitor(final @NotNull LighterAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "<init>"));
        }
        this.childrenStack = new Stack();
        this.parentStack = new Stack();
        this.ast = ast;
        this.myWalkingState = new WalkingState<IndexedLighterASTNode>((WalkingState.TreeGuide)new LighterASTGuide()){

            @Override
            public void elementFinished(@NotNull IndexedLighterASTNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$1", "elementFinished"));
                }
                RecursiveLighterASTNodeWalkingVisitor.this.elementFinished(element.node);
                if (RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek() == element) {
                    IndexedLighterASTNode[] children = (IndexedLighterASTNode[])RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.pop();
                    List<LighterASTNode> list2 = children.length == 0 ? Collections.emptyList() : ContainerUtil.map(children, new Function<IndexedLighterASTNode, LighterASTNode>(){

                        @Override
                        public LighterASTNode fun(IndexedLighterASTNode node) {
                            return node.node;
                        }
                    });
                    ast.disposeChildren(list2);
                    RecursiveLighterASTNodeWalkingVisitor.this.parentStack.pop();
                }
            }

            @Override
            public void visit(@NotNull IndexedLighterASTNode iNode) {
                if (iNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$1", "visit"));
                }
                LighterASTNode element = iNode.node;
                RecursiveLighterASTNodeWalkingVisitor visitor2 = RecursiveLighterASTNodeWalkingVisitor.this;
                if (element instanceof LighterLazyParseableNode) {
                    visitor2.visitLazyParseableNode((LighterLazyParseableNode)element);
                } else if (element instanceof LighterASTTokenNode) {
                    visitor2.visitTokenNode((LighterASTTokenNode)element);
                } else {
                    visitor2.visitNode(element);
                }
            }
        };
    }

    protected void elementFinished(@NotNull LighterASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "elementFinished"));
        }
    }

    @Override
    public void visitNode(@NotNull LighterASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "visitNode"));
        }
        this.myWalkingState.elementStarted(new IndexedLighterASTNode(element, null));
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }

    private class LighterASTGuide
    implements WalkingState.TreeGuide<IndexedLighterASTNode> {
        private LighterASTGuide() {
        }

        @Override
        public IndexedLighterASTNode getNextSibling(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getNextSibling"));
            }
            return element.next;
        }

        @Override
        public IndexedLighterASTNode getPrevSibling(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getPrevSibling"));
            }
            return element.prev;
        }

        @Override
        public IndexedLighterASTNode getFirstChild(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getFirstChild"));
            }
            List<LighterASTNode> children = RecursiveLighterASTNodeWalkingVisitor.this.ast.getChildren(element.node);
            IndexedLighterASTNode[] indexedChildren = children.isEmpty() ? IndexedLighterASTNode.EMPTY_ARRAY : new IndexedLighterASTNode[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                IndexedLighterASTNode indexedNode;
                LighterASTNode child = children.get(i);
                indexedChildren[i] = indexedNode = new IndexedLighterASTNode(child, i == 0 ? null : indexedChildren[i - 1]);
                if (i == 0) continue;
                indexedChildren[i - 1].next = indexedNode;
            }
            RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.push(indexedChildren);
            RecursiveLighterASTNodeWalkingVisitor.this.parentStack.push(element);
            return children.isEmpty() ? null : indexedChildren[0];
        }

        @Override
        public IndexedLighterASTNode getParent(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getParent"));
            }
            return (IndexedLighterASTNode)RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek();
        }
    }

    private static class IndexedLighterASTNode {
        private static final IndexedLighterASTNode[] EMPTY_ARRAY = new IndexedLighterASTNode[0];
        private final LighterASTNode node;
        private final IndexedLighterASTNode prev;
        private IndexedLighterASTNode next;

        IndexedLighterASTNode(@NotNull LighterASTNode node, IndexedLighterASTNode prev) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$IndexedLighterASTNode", "<init>"));
            }
            this.node = node;
            this.prev = prev;
        }
    }
}

