/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;

public class FList<E>
extends AbstractList<E> {
    private static final FList<?> EMPTY_LIST = new FList<Object>(null, null, 0);
    private final E myHead;
    private final FList<E> myTail;
    private final int mySize;

    private FList(E head, FList<E> tail, int size) {
        this.myHead = head;
        this.myTail = tail;
        this.mySize = size;
    }

    @Override
    public E get(int index2) {
        if (index2 < 0 || index2 >= this.mySize) {
            throw new IndexOutOfBoundsException("index = " + index2 + ", size = " + this.mySize);
        }
        FList<E> current = this;
        while (index2 > 0) {
            current = current.myTail;
            --index2;
        }
        return current.myHead;
    }

    public E getHead() {
        return this.myHead;
    }

    public FList<E> prepend(E elem) {
        return new FList<E>(elem, this, this.mySize + 1);
    }

    public FList<E> without(E elem) {
        FList<E> front = FList.emptyList();
        FList<E> current = this;
        while (!current.isEmpty()) {
            if (elem == null ? current.myHead == null : current.myHead.equals(elem)) {
                FList<E> result2 = current.myTail;
                while (!front.isEmpty()) {
                    result2 = result2.prepend(front.myHead);
                    front = front.myTail;
                }
                return result2;
            }
            front = front.prepend(current.myHead);
            current = current.myTail;
        }
        return this;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator iterator2 = new Iterator<E>(){
            private FList<E> list;
            {
                this.list = FList.this;
            }

            @Override
            public boolean hasNext() {
                return this.list.size() > 0;
            }

            @Override
            public E next() {
                if (this.list.size() == 0) {
                    throw new NoSuchElementException();
                }
                Object res = this.list.myHead;
                this.list = this.list.getTail();
                assert (this.list != null);
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/FList", "iterator"));
        }
        return iterator2;
    }

    public FList<E> getTail() {
        return this.myTail;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FList) {
            FList<E> list1 = this;
            FList<E> list2 = (FList<E>)o;
            if (this.mySize != list2.mySize) {
                return false;
            }
            while (list1 != null) {
                if (!Comparing.equal(list1.myHead, list2.myHead)) {
                    return false;
                }
                if ((list1 = list1.getTail()) != (list2 = list2.getTail())) continue;
                return true;
            }
            return true;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (FList<E> each = this; each != null; each = each.getTail()) {
            result2 = result2 * 31 + (each.myHead != null ? each.myHead.hashCode() : 0);
        }
        return result2;
    }

    public static <E> FList<E> emptyList() {
        return EMPTY_LIST;
    }
}

