/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.diff;

import java.util.BitSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineTokenizer;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Enumerator;
import org.jetbrains.kotlin.com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.kotlin.com.intellij.util.diff.IntLCS;
import org.jetbrains.kotlin.com.intellij.util.diff.LCSBuilder;
import org.jetbrains.kotlin.com.intellij.util.diff.PatienceIntLCS;
import org.jetbrains.kotlin.com.intellij.util.diff.Reindexer;

public class Diff {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.diff.Diff");

    @Nullable
    public static Change buildChanges(@NotNull CharSequence before, @NotNull CharSequence after) throws FilesTooBigForDiffException {
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "org/jetbrains/kotlin/com/intellij/util/diff/Diff", "buildChanges"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/kotlin/com/intellij/util/diff/Diff", "buildChanges"));
        }
        String[] strings1 = LineTokenizer.tokenize(before, false);
        String[] strings2 = LineTokenizer.tokenize(after, false);
        return Diff.buildChanges(strings1, strings2);
    }

    @Nullable
    public static <T> Change buildChanges(@NotNull T[] objects1, @NotNull T[] objects2) throws FilesTooBigForDiffException {
        int endCut;
        if (objects1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects1", "org/jetbrains/kotlin/com/intellij/util/diff/Diff", "buildChanges"));
        }
        if (objects2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects2", "org/jetbrains/kotlin/com/intellij/util/diff/Diff", "buildChanges"));
        }
        for (T anObjects1 : objects1) {
            LOG.assertTrue(anObjects1 != null);
        }
        for (T anObjects2 : objects2) {
            LOG.assertTrue(anObjects2 != null);
        }
        int startShift = Diff.getStartShift(objects1, objects2);
        Ref<Change> changeRef = Diff.doBuildChangesFast(objects1.length, objects2.length, startShift, endCut = Diff.getEndCut(objects1, objects2, startShift));
        if (changeRef != null) {
            return changeRef.get();
        }
        int trimmedLength = objects1.length + objects2.length - 2 * startShift - 2 * endCut;
        Enumerator<T> enumerator = new Enumerator<T>(trimmedLength, ContainerUtil.canonicalStrategy());
        int[] ints1 = enumerator.enumerate(objects1, startShift, endCut);
        int[] ints2 = enumerator.enumerate(objects2, startShift, endCut);
        return Diff.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    @Nullable
    private static Ref<Change> doBuildChangesFast(int length1, int length2, int startShift, int endCut) {
        int trimmedLength1 = length1 - startShift - endCut;
        int trimmedLength2 = length2 - startShift - endCut;
        if (trimmedLength1 != 0 && trimmedLength2 != 0) {
            return null;
        }
        Change change = trimmedLength1 != 0 || trimmedLength2 != 0 ? new Change(startShift, startShift, trimmedLength1, trimmedLength2, null) : null;
        return new Ref<Change>(change);
    }

    private static Change doBuildChanges(@NotNull int[] ints1, @NotNull int[] ints2, @NotNull ChangeBuilder builder) throws FilesTooBigForDiffException {
        BitSet[] changes2;
        if (ints1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ints1", "org/jetbrains/kotlin/com/intellij/util/diff/Diff", "doBuildChanges"));
        }
        if (ints2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ints2", "org/jetbrains/kotlin/com/intellij/util/diff/Diff", "doBuildChanges"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/util/diff/Diff", "doBuildChanges"));
        }
        Reindexer reindexer = new Reindexer();
        int[][] discarded = reindexer.discardUnique(ints1, ints2);
        if (discarded[0].length == 0 && discarded[1].length == 0) {
            builder.addChange(ints1.length, ints2.length);
            return builder.getFirstChange();
        }
        if (Registry.is("diff.patience.alg")) {
            PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
            patienceIntLCS.execute();
            changes2 = patienceIntLCS.getChanges();
        } else {
            try {
                IntLCS intLCS = new IntLCS(discarded[0], discarded[1]);
                intLCS.execute();
                changes2 = intLCS.getChanges();
            }
            catch (FilesTooBigForDiffException e) {
                PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
                patienceIntLCS.failOnSmallSizeReduction();
                patienceIntLCS.execute();
                changes2 = patienceIntLCS.getChanges();
                LOG.info("Successful fallback to patience diff");
            }
        }
        reindexer.reindex(changes2, builder);
        return builder.getFirstChange();
    }

    private static <T> int getStartShift(T[] o1, T[] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i].equals(o2[i]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static <T> int getEndCut(T[] o1, T[] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1].equals(o2[o2.length - i - 1]); ++i) {
            ++idx;
        }
        return idx;
    }

    public static int translateLine(@Nullable Change change, int line) {
        return Diff.translateLine(change, line, false);
    }

    public static int translateLine(@Nullable Change change, int line, boolean approximate) {
        int result2 = line;
        Change currentChange = change;
        while (currentChange != null && line >= currentChange.line0) {
            if (line >= currentChange.line0 + currentChange.deleted) {
                result2 += currentChange.inserted - currentChange.deleted;
            } else {
                return approximate ? currentChange.line1 : -1;
            }
            currentChange = currentChange.link;
        }
        return result2;
    }

    public static class ChangeBuilder
    implements LCSBuilder {
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private Change myFirstChange;
        private Change myLastChange;

        public ChangeBuilder(int startShift) {
            this.skip(startShift, startShift);
        }

        @Override
        public void addChange(int first, int second) {
            Change change = new Change(this.myIndex1, this.myIndex2, first, second, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
            this.skip(first, second);
        }

        private void skip(int first, int second) {
            this.myIndex1 += first;
            this.myIndex2 += second;
        }

        @Override
        public void addEqual(int length) {
            this.skip(length, length);
        }

        public Change getFirstChange() {
            return this.myFirstChange;
        }
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        public Change(int line0, int line1, int deleted, int inserted, @Nullable Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        @NonNls
        public String toString() {
            return "change[inserted=" + this.inserted + ", deleted=" + this.deleted + ", line0=" + this.line0 + ", line1=" + this.line1 + "]";
        }
    }
}

