/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.SerializationFilter;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.kotlin.org.jdom.Element;

class JDOMElementBinding
extends Binding
implements MultiNodeBinding {
    private final String myTagName;

    public JDOMElementBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/com/intellij/util/xmlb/JDOMElementBinding", "<init>"));
        }
        super(accessor);
        Tag tag = this.myAccessor.getAnnotation(Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        String tagName = tag.value();
        if (StringUtil.isEmpty(tagName)) {
            tagName = this.myAccessor.getName();
        }
        this.myTagName = tagName;
    }

    @Override
    public Object serialize(@NotNull Object o, Object context, @NotNull SerializationFilter filter2) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/util/xmlb/JDOMElementBinding", "serialize"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/com/intellij/util/xmlb/JDOMElementBinding", "serialize"));
        }
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        if (value instanceof Element) {
            Element targetElement = ((Element)value).clone();
            assert (targetElement != null);
            targetElement.setName(this.myTagName);
            return targetElement;
        }
        if (value instanceof Element[]) {
            ArrayList<Element> result2 = new ArrayList<Element>();
            for (Element element : (Element[])value) {
                result2.add(element.clone().setName(this.myTagName));
            }
            return result2;
        }
        throw new XmlSerializationException("org.jetbrains.kotlin.org.jdom.Element expected but " + value + " found");
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<Element> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/xmlb/JDOMElementBinding", "deserializeList"));
        }
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.set(context, elements.toArray(new Element[elements.size()]));
        } else {
            this.myAccessor.set(context, elements.get(0));
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/JDOMElementBinding", "deserialize"));
        }
        this.myAccessor.set(context, element);
        return context;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/JDOMElementBinding", "isBoundTo"));
        }
        return element.getName().equals(this.myTagName);
    }
}

