/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CachedAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        AccessTranslator accessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context, false);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        assert (referenceExpression instanceof KtReferenceExpression || referenceExpression instanceof KtQualifiedExpression);
        if (referenceExpression instanceof KtQualifiedExpression) {
            AccessTranslator accessTranslator = QualifiedExpressionTranslator.getAccessTranslator((KtQualifiedExpression)referenceExpression, context, forceOrderOfEvaluation);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        if (referenceExpression instanceof KtSimpleNameExpression) {
            AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator((KtSimpleNameExpression)referenceExpression, context);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        assert (referenceExpression instanceof KtArrayAccessExpression);
        AccessTranslator accessTranslator = AccessTranslationUtils.getArrayAccessTranslator((KtArrayAccessExpression)referenceExpression, context, forceOrderOfEvaluation);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    private static AccessTranslator getArrayAccessTranslator(@NotNull KtArrayAccessExpression expression, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        TranslationContext accessArrayContext;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        if (forceOrderOfEvaluation) {
            LinkedHashMap<KtExpression, JsExpression> indexesMap = new LinkedHashMap<KtExpression, JsExpression>();
            for (KtExpression indexExpression : expression.getIndexExpressions()) {
                JsExpression jsIndexExpression = context.cacheExpressionIfNeeded(Translation.translateAsExpression(indexExpression, context));
                indexesMap.put(indexExpression, jsIndexExpression);
            }
            accessArrayContext = context.innerContextWithAliasesForExpressions(indexesMap);
        } else {
            accessArrayContext = context;
        }
        ArrayAccessTranslator arrayAccessTranslator = ArrayAccessTranslator.newInstance(expression, accessArrayContext);
        if (arrayAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        return arrayAccessTranslator;
    }

    @NotNull
    public static CachedAccessTranslator getCachedAccessTranslator(@NotNull KtExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        CachedAccessTranslator cachedAccessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context).getCached();
        if (cachedAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        return cachedAccessTranslator;
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        JsExpression jsExpression = AccessTranslationUtils.getAccessTranslator(expression, context).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        return jsExpression;
    }
}

