/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

public class ManglingUtils {
    private static final Comparator<CallableDescriptor> CALLABLE_COMPARATOR = new CallableComparator();

    private ManglingUtils() {
    }

    @NotNull
    public static String getMangledName(@NotNull PropertyDescriptor descriptor2, @NotNull String suggestedName) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        String string = ManglingUtils.getStableMangledName(suggestedName, DescriptorUtils.getFqName(descriptor2).asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        return string;
    }

    @NotNull
    public static String getSuggestedName(@NotNull DeclarationDescriptor descriptor2) {
        String suggestedName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedName"));
        }
        String string = suggestedName = descriptor2.getName().isSpecial() ? "f" : descriptor2.getName().getIdentifier();
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PropertyDescriptor && DescriptorUtils.isExtension((PropertyDescriptor)descriptor2)) {
            suggestedName = ManglingUtils.getMangledName((CallableMemberDescriptor)descriptor2);
        }
        ClassDescriptor localClass = null;
        if (descriptor2 instanceof ConstructorDescriptor) {
            ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor2;
            localClass = constructor.getContainingDeclaration();
        } else if (descriptor2 instanceof ClassDescriptor) {
            localClass = (ClassDescriptor)descriptor2;
        }
        if (DescriptorUtils.isDescriptorWithLocalVisibility(localClass)) {
            suggestedName = ManglingUtils.getSuggestedLocalPrefix(localClass) + suggestedName;
        }
        String string2 = suggestedName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedName"));
        }
        return string2;
    }

    @NotNull
    private static String getSuggestedLocalPrefix(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedLocalPrefix"));
        }
        ArrayList<String> parts = new ArrayList<String>();
        while ((descriptor2 = descriptor2.getContainingDeclaration()) != null && !(descriptor2 instanceof ClassOrPackageFragmentDescriptor)) {
            parts.add(descriptor2.getName().isSpecial() ? "f" : descriptor2.getName().getIdentifier());
        }
        Collections.reverse(parts);
        String result2 = StringUtil.join(parts, "$");
        String string = !result2.isEmpty() ? result2 + "$" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedLocalPrefix"));
        }
        return string;
    }

    @NotNull
    private static String getMangledName(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        if (ManglingUtils.needsStableMangling(descriptor2)) {
            String string = ManglingUtils.getStableMangledName(descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
            }
            return string;
        }
        String string = ManglingUtils.getSimpleMangledName(descriptor2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        return string;
    }

    private static boolean needsStableMangling(CallableMemberDescriptor descriptor2) {
        if (DescriptorUtils.isOverride(descriptor2)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            return descriptor2.getVisibility().isPublicAPI();
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (!ModalityKt.isFinalOrEnum(classDescriptor)) {
                return true;
            }
            if (descriptor2 instanceof FunctionDescriptor && CodegenUtil.isEnumValueOfMethod((FunctionDescriptor)descriptor2)) {
                return true;
            }
            if (!classDescriptor.getVisibility().isPublicAPI()) {
                return false;
            }
            return descriptor2.getVisibility() == Visibilities.PUBLIC;
        }
        assert (containingDeclaration instanceof CallableMemberDescriptor) : "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor2 + ", containingDeclaration: " + containingDeclaration;
        return false;
    }

    @NotNull
    public static String getMangledMemberNameForExplicitDelegation(@NotNull String suggestedName, @NotNull FqNameUnsafe classFqName, @NotNull FqNameUnsafe typeFqName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        if (classFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFqName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        if (typeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeFqName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        String forCalculateId = classFqName.asString() + ":" + typeFqName.asString();
        String string = ManglingUtils.getStableMangledName(suggestedName, forCalculateId);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        return string;
    }

    @NotNull
    private static String getStableMangledName(@NotNull String suggestedName, String forCalculateId) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        int absHashCode = Math.abs(forCalculateId.hashCode());
        String suffix = absHashCode == 0 ? "" : "_" + Integer.toString(absHashCode, 36) + "$";
        String string = suggestedName + suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        return string;
    }

    @NotNull
    private static String getStableMangledName(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        String suggestedName = ManglingUtils.getSuggestedName(descriptor2);
        String string = ManglingUtils.getStableMangledName(suggestedName, ManglingUtils.getArgumentTypesAsString(descriptor2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        return string;
    }

    @NotNull
    private static String getSuggestedName(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedName"));
        }
        if (descriptor2 instanceof ConstructorDescriptor && !((ConstructorDescriptor)descriptor2).isPrimary()) {
            String string = descriptor2.getContainingDeclaration().getName().asString() + "_init";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedName"));
            }
            return string;
        }
        String string = descriptor2.getName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedName"));
        }
        return string;
    }

    @NotNull
    private static String getSimpleMangledName(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSimpleMangledName"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        MemberScope jetScope = null;
        String nameToCompare = descriptor2.getName().asString();
        if (descriptor2 instanceof ConstructorDescriptor) {
            nameToCompare = containingDeclaration.getName().asString();
            containingDeclaration = containingDeclaration.getContainingDeclaration();
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            jetScope = ((PackageFragmentDescriptor)containingDeclaration).getMemberScope();
        } else if (containingDeclaration instanceof ClassDescriptor) {
            jetScope = ((ClassDescriptor)containingDeclaration).getDefaultType().getMemberScope();
        }
        int counter = 0;
        if (jetScope != null) {
            final String finalNameToCompare = nameToCompare;
            Collection<DeclarationDescriptor> declarations = DescriptorUtils.getAllDescriptors(jetScope);
            List<? extends CallableDescriptor> overloadedFunctions = CollectionsKt.flatMap(declarations, new Function1<DeclarationDescriptor, Iterable<? extends CallableDescriptor>>(){

                @Override
                public Iterable<? extends CallableDescriptor> invoke(DeclarationDescriptor declarationDescriptor) {
                    if (declarationDescriptor instanceof ClassDescriptor && finalNameToCompare.equals(declarationDescriptor.getName().asString())) {
                        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
                        Collection<ConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
                        if (!DescriptorUtilsKt.hasPrimaryConstructor(classDescriptor)) {
                            ConstructorDescriptorImpl fakePrimaryConstructor = ConstructorDescriptorImpl.create(classDescriptor, Annotations.Companion.getEMPTY(), true, SourceElement.NO_SOURCE);
                            return CollectionsKt.plus(constructors2, fakePrimaryConstructor);
                        }
                        return constructors2;
                    }
                    if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                        return Collections.emptyList();
                    }
                    CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                    String name = AnnotationsUtils.getNameForAnnotatedObjectWithOverrides(callableMemberDescriptor);
                    if (name == null) {
                        if (ManglingUtils.needsStableMangling(callableMemberDescriptor) && !callableMemberDescriptor.getValueParameters().isEmpty()) {
                            return Collections.emptyList();
                        }
                        name = callableMemberDescriptor.getName().asString();
                    }
                    if (finalNameToCompare.equals(name)) {
                        return Collections.singletonList(callableMemberDescriptor);
                    }
                    return Collections.emptyList();
                }
            });
            if (overloadedFunctions.size() > 1) {
                Collections.sort(overloadedFunctions, CALLABLE_COMPARATOR);
                counter = ContainerUtil.indexOfIdentity(overloadedFunctions, descriptor2);
                assert (counter >= 0);
            }
        }
        String name = ManglingUtils.getSuggestedName(descriptor2);
        String string = counter == 0 ? name : name + '_' + counter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSimpleMangledName"));
        }
        return string;
    }

    private static String getArgumentTypesAsString(CallableDescriptor descriptor2) {
        StringBuilder argTypes = new StringBuilder();
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            argTypes.append(DescriptorUtilsKt.getJetTypeFqName(receiverParameter.getType(), true)).append(".");
        }
        argTypes.append(StringUtil.join(descriptor2.getValueParameters(), new Function<ValueParameterDescriptor, String>(){

            @Override
            public String fun(ValueParameterDescriptor descriptor2) {
                return DescriptorUtilsKt.getJetTypeFqName(descriptor2.getType(), true);
            }
        }, ","));
        return argTypes.toString();
    }

    @NotNull
    public static String getStableMangledNameForDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull String functionName) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledNameForDescriptor"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledNameForDescriptor"));
        }
        Collection<SimpleFunctionDescriptor> functions2 = descriptor2.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier(functionName), NoLookupLocation.FROM_BACKEND);
        assert (functions2.size() == 1) : "Can't select a single function: " + functionName + " in " + descriptor2;
        String string = ManglingUtils.getSuggestedName((DeclarationDescriptor)functions2.iterator().next());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledNameForDescriptor"));
        }
        return string;
    }

    private static class CallableComparator
    implements Comparator<CallableDescriptor> {
        private CallableComparator() {
        }

        @Override
        public int compare(@NotNull CallableDescriptor a, @NotNull CallableDescriptor b) {
            int bArity;
            Integer result2;
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils$CallableComparator", "compare"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils$CallableComparator", "compare"));
            }
            if (a instanceof ConstructorDescriptor && ((ConstructorDescriptor)a).isPrimary()) {
                if (!(b instanceof ConstructorDescriptor) || !((ConstructorDescriptor)b).isPrimary()) {
                    return -1;
                }
            } else if (b instanceof ConstructorDescriptor && ((ConstructorDescriptor)b).isPrimary()) {
                return 1;
            }
            if (CallableComparator.isNativeOrOverrideNative(a)) {
                if (!CallableComparator.isNativeOrOverrideNative(b)) {
                    return -1;
                }
            } else if (CallableComparator.isNativeOrOverrideNative(b)) {
                return 1;
            }
            if ((result2 = Visibilities.compare(b.getVisibility(), a.getVisibility())) != null && result2 != 0) {
                return result2;
            }
            int aArity = CallableComparator.arity(a);
            if (aArity != (bArity = CallableComparator.arity(b))) {
                return aArity - bArity;
            }
            String aArguments = ManglingUtils.getArgumentTypesAsString(a);
            String bArguments = ManglingUtils.getArgumentTypesAsString(b);
            assert (aArguments != bArguments);
            return aArguments.compareTo(bArguments);
        }

        private static int arity(CallableDescriptor descriptor2) {
            return descriptor2.getValueParameters().size() + (descriptor2.getExtensionReceiverParameter() == null ? 0 : 1);
        }

        private static boolean isNativeOrOverrideNative(CallableDescriptor descriptor2) {
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return false;
            }
            if (AnnotationsUtils.isNativeObject(descriptor2)) {
                return true;
            }
            Set<CallableMemberDescriptor> declarations = DescriptorUtils.getAllOverriddenDeclarations((CallableMemberDescriptor)descriptor2);
            for (CallableMemberDescriptor memberDescriptor : declarations) {
                if (!AnnotationsUtils.isNativeObject(memberDescriptor)) continue;
                return true;
            }
            return false;
        }
    }
}

