/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

public class Credentials {
    private String realm;
    private String host;
    private String userName;
    private String passwd;

    public Credentials(String realm, String host, String userName, String passwd) {
        this.realm = realm;
        this.host = host;
        this.userName = userName;
        this.passwd = passwd;
    }

    public String getHost() {
        return this.host;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUserName() {
        return this.userName;
    }

    public static String buildKey(String realm, String host) {
        if (realm == null || "".equals(realm.trim())) {
            return host;
        }
        return realm + "@" + host;
    }

    public String toString() {
        return this.getKey() + " " + this.getUserName() + "/" + this.getPasswdAsStars();
    }

    private String getPasswdAsStars() {
        if (this.passwd == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = this.passwd.length(); i > 0; --i) {
            sb.append('*');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Credentials) {
            Credentials c = (Credentials)o;
            return this.getKey().equals(c.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String getKey() {
        return Credentials.buildKey(this.realm, this.host);
    }
}

