/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.P3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;
import org.jmol.g3d.PrecisionRenderer;
import org.jmol.java.BS;
import org.jmol.util.Shader;

final class LineRenderer
extends PrecisionRenderer {
    private final Graphics3D g3d;
    private final Shader shader;
    private BS lineBits;
    private float slope;
    private boolean lineTypeX;
    private int nBits;
    private Map<Float, BS> lineCache = new Hashtable<Float, BS>();
    private Float slopeKey;
    private static final int VISIBILITY_UNCLIPPED = 0;
    private static final int VISIBILITY_CLIPPED = 1;
    private static final int VISIBILITY_OFFSCREEN = 2;
    private int x1t;
    private int y1t;
    private int z1t;
    private int x2t;
    private int y2t;
    private int z2t;

    LineRenderer(Graphics3D g3d) {
        this.g3d = g3d;
        this.shader = g3d.shader;
    }

    void setLineBits(float dx, float dy) {
        this.slope = dx != 0.0f ? dy / dx : (dy >= 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
        this.lineTypeX = this.slope <= 1.0f && this.slope >= -1.0f;
        this.nBits = this.lineTypeX ? this.g3d.width : this.g3d.height;
        this.slopeKey = Float.valueOf(this.slope);
        if (this.lineCache.containsKey(this.slopeKey)) {
            this.lineBits = this.lineCache.get(this.slopeKey);
            return;
        }
        this.lineBits = BS.newN(this.nBits);
        if ((dy = Math.abs(dy)) > (dx = Math.abs(dx))) {
            float t = dx;
            dx = dy;
            dy = t;
        }
        int twoDError = 0;
        float twoDx = dx + dx;
        float twoDy = dy + dy;
        for (int i = 0; i < this.nBits; ++i) {
            if (!((float)(twoDError = (int)((float)twoDError + twoDy)) > dx)) continue;
            this.lineBits.set(i);
            twoDError = (int)((float)twoDError - twoDx);
        }
        this.lineCache.put(this.slopeKey, this.lineBits);
    }

    void clearLineCache() {
        this.lineCache.clear();
    }

    void plotLineOld(int argbA, int argbB, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.x1t = xA;
        this.x2t = xB;
        this.y1t = yA;
        this.y2t = yB;
        this.z1t = zA;
        this.z2t = zB;
        boolean clipped = true;
        switch (this.getTrimmedLineImpl()) {
            case 0: {
                clipped = false;
                break;
            }
            case 2: {
                return;
            }
        }
        this.plotLineClippedOld(argbA, argbB, xA, yA, zA, xB - xA, yB - yA, zB - zA, clipped, 0, 0);
    }

    void plotLineDeltaOld(int argbA, int argbB, int xA, int yA, int zA, int dxBA, int dyBA, int dzBA, boolean clipped) {
        this.x1t = xA;
        this.x2t = xA + dxBA;
        this.y1t = yA;
        this.y2t = yA + dyBA;
        this.z1t = zA;
        this.z2t = zA + dzBA;
        if (clipped) {
            switch (this.getTrimmedLineImpl()) {
                case 2: {
                    return;
                }
                case 0: {
                    clipped = false;
                }
            }
        }
        this.plotLineClippedOld(argbA, argbB, xA, yA, zA, dxBA, dyBA, dzBA, clipped, 0, 0);
    }

    void plotLineDeltaAOld(int[] shades1, int[] shades2, int screenMask, int shadeIndex, int x, int y, int z, int dx, int dy, int dz, boolean clipped) {
        this.x1t = x;
        this.x2t = x + dx;
        this.y1t = y;
        this.y2t = y + dy;
        this.z1t = z;
        this.z2t = z + dz;
        if (clipped) {
            switch (this.getTrimmedLineImpl()) {
                case 2: {
                    return;
                }
                case 0: {
                    clipped = false;
                }
            }
        }
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int runIndex = 0;
        int rise = Integer.MAX_VALUE;
        int run = 1;
        int offset = y * width + x;
        int offsetMax = this.g3d.bufferSize;
        int shadeIndexUp = shadeIndex < 63 ? shadeIndex + 1 : shadeIndex;
        int shadeIndexDn = shadeIndex > 0 ? shadeIndex - 1 : shadeIndex;
        int argb1 = shades1[shadeIndex];
        int argb1Up = shades1[shadeIndexUp];
        int argb1Dn = shades1[shadeIndexDn];
        int argb2 = shades2[shadeIndex];
        int argb2Up = shades2[shadeIndexUp];
        int argb2Dn = shades2[shadeIndexDn];
        int argb = argb1;
        Pixelator p = this.g3d.pixel;
        if (screenMask != 0) {
            p = this.g3d.setScreened((screenMask & 1) == 1);
            this.g3d.currentShadeIndex = 0;
        }
        if (argb != 0 && !clipped && offset >= 0 && offset < offsetMax && z < zbuf[offset]) {
            p.addPixel(offset, z, argb);
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yOffsetIncrement = width;
        int x2 = x + dx;
        int y2 = y + dy;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z << 10;
        int argbUp = argb1Up;
        int argbDn = argb1Dn;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n1 = Math.abs(x2 - this.x2t) - 1;
            int n2 = Math.abs(x2 - this.x1t) - 1;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid) {
                    argb = argb2;
                    if (argb == 0) {
                        return;
                    }
                    argbUp = argb2Up;
                    argbDn = argb2Dn;
                    if (screenMask % 3 != 0) {
                        p = this.g3d.setScreened((screenMask & 2) == 2);
                        this.g3d.currentShadeIndex = 0;
                    }
                }
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                }
                if (argb != 0 && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    int rand8 = this.shader.nextRandom8Bit();
                    p.addPixel(offset, zCurrent, rand8 < 85 ? argbDn : (rand8 > 170 ? argbUp : argb));
                }
                runIndex = (runIndex + 1) % run;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n1 = Math.abs(y2 - this.y2t) - 1;
            int n2 = Math.abs(y2 - this.y1t) - 1;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid) {
                    argb = argb2;
                    if (argb == 0) {
                        return;
                    }
                    argbUp = argb2Up;
                    argbDn = argb2Dn;
                    if (screenMask % 3 != 0) {
                        p = this.g3d.setScreened((screenMask & 2) == 2);
                        this.g3d.currentShadeIndex = 0;
                    }
                }
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                }
                if (argb != 0 && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    int rand8 = this.g3d.shader.nextRandom8Bit();
                    p.addPixel(offset, zCurrent, rand8 < 85 ? argbDn : (rand8 > 170 ? argbUp : argb));
                }
                runIndex = (runIndex + 1) % run;
            }
        }
    }

    void plotLineDeltaABits(int[] shades1, int[] shades2, int shadeIndex, P3i ptA, P3i ptB, int screenMask, boolean clipped) {
        int yOffsetIncrement;
        int xIncrement;
        int iIncrement;
        int iMid;
        int i2;
        int i1;
        int i0;
        int x = ptA.x;
        int y = ptA.y;
        int z = ptA.z;
        int bx = ptB.x;
        int by = ptB.y;
        int bz = ptB.z;
        int dx = bx - x;
        int dy = by - y;
        this.x1t = x;
        this.x2t = bx;
        this.y1t = y;
        this.y2t = by;
        this.z1t = z;
        this.z2t = bz;
        if (clipped && this.getTrimmedLineImpl() == 2) {
            return;
        }
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int runIndex = 0;
        int rise = Integer.MAX_VALUE;
        int run = 1;
        int shadeIndexUp = shadeIndex < 63 ? shadeIndex + 1 : shadeIndex;
        int shadeIndexDn = shadeIndex > 0 ? shadeIndex - 1 : shadeIndex;
        int argb1 = shades1[shadeIndex];
        int argb1Up = shades1[shadeIndexUp];
        int argb1Dn = shades1[shadeIndexDn];
        int argb2 = shades2[shadeIndex];
        int argb2Up = shades2[shadeIndexUp];
        int argb2Dn = shades2[shadeIndexDn];
        int offset = y * width + x;
        int offsetMax = this.g3d.bufferSize;
        if (this.lineTypeX) {
            i0 = x;
            i1 = this.x1t;
            i2 = this.x2t;
            iMid = x + dx / 2;
            xIncrement = iIncrement = dx >= 0 ? 1 : -1;
            yOffsetIncrement = dy >= 0 ? width : -width;
            this.setRastAB(ptA.x, ptA.z, ptB.x, ptB.z);
        } else {
            i0 = y;
            i1 = this.y1t;
            i2 = this.y2t;
            iMid = y + dy / 2;
            iIncrement = dy >= 0 ? 1 : -1;
            xIncrement = dy >= 0 ? width : -width;
            yOffsetIncrement = dx >= 0 ? 1 : -1;
            this.setRastAB(ptA.y, ptA.z, ptB.y, ptB.z);
        }
        float zCurrent = z;
        int argb = argb1;
        int argbUp = argb1Up;
        int argbDn = argb1Dn;
        boolean isInWindow = false;
        Pixelator p = this.g3d.pixel;
        if (screenMask != 0) {
            p = this.g3d.setScreened((screenMask & 1) == 1);
            this.g3d.currentShadeIndex = 0;
        }
        int i = i0;
        int iBits = i0;
        while (true) {
            if (i == i1) {
                isInWindow = true;
            }
            if (i == iMid) {
                argb = argb2;
                if (argb == 0) {
                    return;
                }
                argbUp = argb2Up;
                argbDn = argb2Dn;
                if (screenMask % 3 != 0) {
                    p = this.g3d.setScreened((screenMask & 2) == 2);
                    this.g3d.currentShadeIndex = 0;
                }
            }
            if (argb != 0 && isInWindow && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = (float)this.getZCurrent(this.a, this.b, i)) < (float)zbuf[offset]) {
                int rand8 = this.shader.nextRandom8Bit();
                p.addPixel(offset, (int)zCurrent, rand8 < 85 ? argbDn : (rand8 > 170 ? argbUp : argb));
            }
            if (i == i2) break;
            runIndex = (runIndex + 1) % run;
            offset += xIncrement;
            while (iBits < 0) {
                iBits += this.nBits;
            }
            if (this.lineBits.get(iBits % this.nBits)) {
                offset += yOffsetIncrement;
            }
            i += iIncrement;
            iBits += iIncrement;
        }
    }

    void plotLineBits(int argbA, int argbB, P3i ptA, P3i ptB, int run, int rise, boolean andClip) {
        if (ptA.z <= 1 || ptB.z <= 1) {
            return;
        }
        boolean clipped = true;
        this.x1t = ptA.x;
        this.y1t = ptA.y;
        this.z1t = ptA.z;
        this.x2t = ptB.x;
        this.y2t = ptB.y;
        this.z2t = ptB.z;
        switch (this.getTrimmedLineImpl()) {
            case 2: {
                return;
            }
            case 0: {
                clipped = false;
                break;
            }
            default: {
                if (!andClip) break;
                ptA.set(this.x1t, this.y1t, this.z1t);
                ptB.set(this.x2t, this.y2t, this.z2t);
            }
        }
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int runIndex = 0;
        if (run == 0) {
            rise = Integer.MAX_VALUE;
            run = 1;
        }
        int x = ptA.x;
        int y = ptA.y;
        int z = ptA.z;
        int dx = ptB.x - x;
        int x2 = x + dx;
        int dy = ptB.y - y;
        int y2 = y + dy;
        int offset = y * width + x;
        int offsetMax = this.g3d.bufferSize;
        int argb = argbA;
        Pixelator p = this.g3d.pixel;
        if (argb != 0 && !clipped && offset >= 0 && offset < offsetMax && z < zbuf[offset]) {
            p.addPixel(offset, z, argb);
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yIncrement = 1;
        int yOffsetIncrement = width;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
            yIncrement = -1;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        if (dy <= dx) {
            this.setRastAB(ptA.x, ptA.z, ptB.x, ptB.z);
            int twoDxAccumulatedYError = 0;
            int n1 = Math.abs(x2 - this.x2t) - 1;
            int n2 = Math.abs(x2 - this.x1t) - 1;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid && (argb = argbB) == 0) {
                    return;
                }
                offset += xIncrement;
                x += xIncrement;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                }
                if (argb != 0 && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = this.getZCurrent(this.a, this.b, x)) < zbuf[offset]) {
                    p.addPixel(offset, zCurrent, argb);
                }
                runIndex = (runIndex + 1) % run;
            }
        } else {
            this.setRastAB(ptA.y, ptA.z, ptB.y, ptB.z);
            int twoDyAccumulatedXError = 0;
            int n1 = Math.abs(y2 - this.y2t) - 1;
            int n2 = Math.abs(y2 - this.y1t) - 1;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid && (argb = argbB) == 0) {
                    return;
                }
                offset += yOffsetIncrement;
                y += yIncrement;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                }
                if (argb != 0 && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = this.getZCurrent(this.a, this.b, y)) < zbuf[offset]) {
                    p.addPixel(offset, zCurrent, argb);
                }
                runIndex = (runIndex + 1) % run;
            }
        }
    }

    private int getTrimmedLineImpl() {
        int cc1 = this.g3d.clipCode3(this.x1t, this.y1t, this.z1t);
        int cc2 = this.g3d.clipCode3(this.x2t, this.y2t, this.z2t);
        int c = cc1 | cc2;
        if ((cc1 | cc2) == 0) {
            return 0;
        }
        if (c == -1) {
            return 2;
        }
        int xLast = this.g3d.xLast;
        int yLast = this.g3d.yLast;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        do {
            if ((cc1 & cc2) != 0) {
                return 2;
            }
            float dx = this.x2t - this.x1t;
            float dy = this.y2t - this.y1t;
            float dz = this.z2t - this.z1t;
            if (cc1 != 0) {
                if ((cc1 & 8) != 0) {
                    this.y1t += (int)((float)(-this.x1t) * dy / dx);
                    this.z1t += (int)((float)(-this.x1t) * dz / dx);
                    this.x1t = 0;
                } else if ((cc1 & 4) != 0) {
                    this.y1t += (int)((float)(xLast - this.x1t) * dy / dx);
                    this.z1t += (int)((float)(xLast - this.x1t) * dz / dx);
                    this.x1t = xLast;
                } else if ((cc1 & 2) != 0) {
                    this.x1t += (int)((float)(-this.y1t) * dx / dy);
                    this.z1t += (int)((float)(-this.y1t) * dz / dy);
                    this.y1t = 0;
                } else if ((cc1 & 1) != 0) {
                    this.x1t += (int)((float)(yLast - this.y1t) * dx / dy);
                    this.z1t += (int)((float)(yLast - this.y1t) * dz / dy);
                    this.y1t = yLast;
                } else if ((cc1 & 0x20) != 0) {
                    this.x1t += (int)((float)(slab - this.z1t) * dx / dz);
                    this.y1t += (int)((float)(slab - this.z1t) * dy / dz);
                    this.z1t = slab;
                } else {
                    this.x1t += (int)((float)(depth - this.z1t) * dx / dz);
                    this.y1t += (int)((float)(depth - this.z1t) * dy / dz);
                    this.z1t = depth;
                }
                cc1 = this.g3d.clipCode3(this.x1t, this.y1t, this.z1t);
                continue;
            }
            if ((cc2 & 8) != 0) {
                this.y2t += (int)((float)(-this.x2t) * dy / dx);
                this.z2t += (int)((float)(-this.x2t) * dz / dx);
                this.x2t = 0;
            } else if ((cc2 & 4) != 0) {
                this.y2t += (int)((float)(xLast - this.x2t) * dy / dx);
                this.z2t += (int)((float)(xLast - this.x2t) * dz / dx);
                this.x2t = xLast;
            } else if ((cc2 & 2) != 0) {
                this.x2t += (int)((float)(-this.y2t) * dx / dy);
                this.z2t += (int)((float)(-this.y2t) * dz / dy);
                this.y2t = 0;
            } else if ((cc2 & 1) != 0) {
                this.x2t += (int)((float)(yLast - this.y2t) * dx / dy);
                this.z2t += (int)((float)(yLast - this.y2t) * dz / dy);
                this.y2t = yLast;
            } else if ((cc2 & 0x20) != 0) {
                this.x2t += (int)((float)(slab - this.z2t) * dx / dz);
                this.y2t += (int)((float)(slab - this.z2t) * dy / dz);
                this.z2t = slab;
            } else {
                this.x2t += (int)((float)(depth - this.z2t) * dx / dz);
                this.y2t += (int)((float)(depth - this.z2t) * dy / dz);
                this.z2t = depth;
            }
            cc2 = this.g3d.clipCode3(this.x2t, this.y2t, this.z2t);
        } while ((cc1 | cc2) != 0);
        return 1;
    }

    private void plotLineClippedOld(int argb1, int argb2, int x, int y, int z, int dx, int dy, int dz, boolean clipped, int run, int rise) {
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int runIndex = 0;
        if (run == 0) {
            rise = Integer.MAX_VALUE;
            run = 1;
        }
        int offset = y * width + x;
        int offsetMax = this.g3d.bufferSize;
        int argb = argb1;
        Pixelator p = this.g3d.pixel;
        if (argb != 0 && !clipped && offset >= 0 && offset < offsetMax && z < zbuf[offset]) {
            p.addPixel(offset, z, argb);
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yOffsetIncrement = width;
        int x2 = x + dx;
        int y2 = y + dy;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z << 10;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n1 = Math.abs(x2 - this.x2t) - 1;
            int n2 = Math.abs(x2 - this.x1t) - 1;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid && (argb = argb2) == 0) {
                    return;
                }
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                }
                if (argb != 0 && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    p.addPixel(offset, zCurrent, argb);
                }
                runIndex = (runIndex + 1) % run;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n1 = Math.abs(y2 - this.y2t) - 1;
            int n2 = Math.abs(y2 - this.y1t) - 1;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid && (argb = argb2) == 0) {
                    return;
                }
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                }
                if (argb != 0 && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    p.addPixel(offset, zCurrent, argb);
                }
                runIndex = (runIndex + 1) % run;
            }
        }
    }
}

