/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.tiff;

import com.drew.imaging.tiff.TiffDataFormat;
import com.drew.imaging.tiff.TiffHandler;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TiffReader {
    public void processTiff(@NotNull RandomAccessReader randomAccessReader, @NotNull TiffHandler tiffHandler, int n) throws TiffProcessingException, IOException {
        short s = randomAccessReader.getInt16(n);
        if (s == 19789) {
            randomAccessReader.setMotorolaByteOrder(true);
        } else if (s == 18761) {
            randomAccessReader.setMotorolaByteOrder(false);
        } else {
            throw new TiffProcessingException("Unclear distinction between Motorola/Intel byte ordering: " + s);
        }
        int n2 = randomAccessReader.getUInt16(2 + n);
        tiffHandler.setTiffMarker(n2);
        int n3 = randomAccessReader.getInt32(4 + n) + n;
        if ((long)n3 >= randomAccessReader.getLength() - 1L) {
            tiffHandler.warn("First IFD offset is beyond the end of the TIFF data segment -- trying default offset");
            n3 = n + 2 + 2 + 4;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        TiffReader.processIfd(tiffHandler, randomAccessReader, hashSet, n3, n);
        tiffHandler.completed(randomAccessReader, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processIfd(@NotNull TiffHandler tiffHandler, @NotNull RandomAccessReader randomAccessReader, @NotNull Set<Integer> set, int n, int n2) throws IOException {
        Boolean bl = null;
        try {
            int n3;
            int n4;
            int n5;
            if (set.contains(n)) {
                return;
            }
            set.add(n);
            if ((long)n >= randomAccessReader.getLength() || n < 0) {
                tiffHandler.error("Ignored IFD marked to start outside data segment");
                return;
            }
            int n6 = randomAccessReader.getUInt16(n);
            if (n6 > 255 && (n6 & 0xFF) == 0) {
                bl = randomAccessReader.isMotorolaByteOrder();
                n6 >>= 8;
                randomAccessReader.setMotorolaByteOrder(!randomAccessReader.isMotorolaByteOrder());
            }
            if ((long)((n5 = 2 + 12 * n6 + 4) + n) > randomAccessReader.getLength()) {
                tiffHandler.error("Illegally sized IFD");
                return;
            }
            int n7 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                long l;
                long l2;
                n3 = TiffReader.calculateTagOffset(n, n4);
                int n8 = randomAccessReader.getUInt16(n3);
                int n9 = randomAccessReader.getUInt16(n3 + 2);
                TiffDataFormat tiffDataFormat = TiffDataFormat.fromTiffFormatCode(n9);
                long l3 = randomAccessReader.getUInt32(n3 + 4);
                if (tiffDataFormat == null) {
                    Long l4 = tiffHandler.tryCustomProcessFormat(n8, n9, l3);
                    if (l4 == null) {
                        tiffHandler.error(String.format("Invalid TIFF tag format code %d for tag 0x%04X", n9, n8));
                        if (++n7 <= 5) continue;
                        tiffHandler.error("Stopping processing as too many errors seen in TIFF IFD");
                        return;
                    }
                    l2 = l4;
                } else {
                    l2 = l3 * (long)tiffDataFormat.getComponentSizeBytes();
                }
                if (l2 > 4L) {
                    long l5 = randomAccessReader.getUInt32(n3 + 8);
                    if (l5 + l2 > randomAccessReader.getLength()) {
                        tiffHandler.error("Illegal TIFF tag pointer offset");
                        continue;
                    }
                    l = (long)n2 + l5;
                } else {
                    l = n3 + 8;
                }
                if (l < 0L || l > randomAccessReader.getLength()) {
                    tiffHandler.error("Illegal TIFF tag pointer offset");
                    continue;
                }
                if (l2 < 0L || l + l2 > randomAccessReader.getLength()) {
                    tiffHandler.error("Illegal number of bytes for TIFF tag data: " + l2);
                    continue;
                }
                boolean bl2 = false;
                if (l2 == 4L * l3) {
                    int n10 = 0;
                    while ((long)n10 < l3) {
                        if (tiffHandler.tryEnterSubIfd(n8)) {
                            bl2 = true;
                            int n11 = n2 + randomAccessReader.getInt32((int)(l + (long)(n10 * 4)));
                            TiffReader.processIfd(tiffHandler, randomAccessReader, set, n11, n2);
                        }
                        ++n10;
                    }
                }
                if (bl2 || tiffHandler.customProcessTag((int)l, set, n2, randomAccessReader, n8, (int)l2)) continue;
                TiffReader.processTag(tiffHandler, n8, (int)l, (int)l3, n9, randomAccessReader);
            }
            n4 = TiffReader.calculateTagOffset(n, n6);
            n3 = randomAccessReader.getInt32(n4);
            if (n3 != 0) {
                if ((long)(n3 += n2) >= randomAccessReader.getLength()) {
                    return;
                }
                if (n3 < n) {
                    return;
                }
                if (tiffHandler.hasFollowerIfd()) {
                    TiffReader.processIfd(tiffHandler, randomAccessReader, set, n3, n2);
                }
            }
        }
        finally {
            tiffHandler.endingIFD();
            if (bl != null) {
                randomAccessReader.setMotorolaByteOrder(bl);
            }
        }
    }

    private static void processTag(@NotNull TiffHandler tiffHandler, int n, int n2, int n3, int n4, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        switch (n4) {
            case 7: {
                tiffHandler.setByteArray(n, randomAccessReader.getBytes(n2, n3));
                break;
            }
            case 2: {
                tiffHandler.setString(n, randomAccessReader.getNullTerminatedString(n2, n3));
                break;
            }
            case 10: {
                if (n3 == 1) {
                    tiffHandler.setRational(n, new Rational(randomAccessReader.getInt32(n2), randomAccessReader.getInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(randomAccessReader.getInt32(n2 + 8 * i), randomAccessReader.getInt32(n2 + 4 + 8 * i));
                }
                tiffHandler.setRationalArray(n, rationalArray);
                break;
            }
            case 5: {
                if (n3 == 1) {
                    tiffHandler.setRational(n, new Rational(randomAccessReader.getUInt32(n2), randomAccessReader.getUInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(randomAccessReader.getUInt32(n2 + 8 * i), randomAccessReader.getUInt32(n2 + 4 + 8 * i));
                }
                tiffHandler.setRationalArray(n, rationalArray);
                break;
            }
            case 11: {
                if (n3 == 1) {
                    tiffHandler.setFloat(n, randomAccessReader.getFloat32(n2));
                    break;
                }
                float[] fArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    fArray[i] = randomAccessReader.getFloat32(n2 + i * 4);
                }
                tiffHandler.setFloatArray(n, fArray);
                break;
            }
            case 12: {
                if (n3 == 1) {
                    tiffHandler.setDouble(n, randomAccessReader.getDouble64(n2));
                    break;
                }
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = randomAccessReader.getDouble64(n2 + i * 4);
                }
                tiffHandler.setDoubleArray(n, dArray);
                break;
            }
            case 6: {
                if (n3 == 1) {
                    tiffHandler.setInt8s(n, randomAccessReader.getInt8(n2));
                    break;
                }
                byte[] byArray = new byte[n3];
                for (int i = 0; i < n3; ++i) {
                    byArray[i] = randomAccessReader.getInt8(n2 + i);
                }
                tiffHandler.setInt8sArray(n, byArray);
                break;
            }
            case 1: {
                if (n3 == 1) {
                    tiffHandler.setInt8u(n, randomAccessReader.getUInt8(n2));
                    break;
                }
                short[] sArray = new short[n3];
                for (int i = 0; i < n3; ++i) {
                    sArray[i] = randomAccessReader.getUInt8(n2 + i);
                }
                tiffHandler.setInt8uArray(n, sArray);
                break;
            }
            case 8: {
                if (n3 == 1) {
                    tiffHandler.setInt16s(n, randomAccessReader.getInt16(n2));
                    break;
                }
                short[] sArray = new short[n3];
                for (int i = 0; i < n3; ++i) {
                    sArray[i] = randomAccessReader.getInt16(n2 + i * 2);
                }
                tiffHandler.setInt16sArray(n, sArray);
                break;
            }
            case 3: {
                if (n3 == 1) {
                    tiffHandler.setInt16u(n, randomAccessReader.getUInt16(n2));
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = randomAccessReader.getUInt16(n2 + i * 2);
                }
                tiffHandler.setInt16uArray(n, nArray);
                break;
            }
            case 9: {
                if (n3 == 1) {
                    tiffHandler.setInt32s(n, randomAccessReader.getInt32(n2));
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = randomAccessReader.getInt32(n2 + i * 4);
                }
                tiffHandler.setInt32sArray(n, nArray);
                break;
            }
            case 4: {
                if (n3 == 1) {
                    tiffHandler.setInt32u(n, randomAccessReader.getUInt32(n2));
                    break;
                }
                long[] lArray = new long[n3];
                for (int i = 0; i < n3; ++i) {
                    lArray[i] = randomAccessReader.getUInt32(n2 + i * 4);
                }
                tiffHandler.setInt32uArray(n, lArray);
                break;
            }
            default: {
                tiffHandler.error(String.format("Invalid TIFF tag format code %d for tag 0x%04X", n4, n));
            }
        }
    }

    private static int calculateTagOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }
}

