/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGException;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Rect
extends ShapeElement {
    public static final String TAG_NAME = "rect";
    float x = 0.0f;
    float y = 0.0f;
    float width = 0.0f;
    float height = 0.0f;
    float rx = 0.0f;
    float ry = 0.0f;
    RectangularShape rect;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat(this.x);
        objectOutputStream.writeFloat(this.y);
        objectOutputStream.writeFloat(this.width);
        objectOutputStream.writeFloat(this.height);
        objectOutputStream.writeFloat(this.rx);
        objectOutputStream.writeFloat(this.ry);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.x = objectInputStream.readFloat();
        this.y = objectInputStream.readFloat();
        this.width = objectInputStream.readFloat();
        this.height = objectInputStream.readFloat();
        this.rx = objectInputStream.readFloat();
        this.ry = objectInputStream.readFloat();
        this.rect = this.rx == 0.0f && this.ry == 0.0f ? new Rectangle2D.Float(this.x, this.y, this.width, this.height) : new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.rx * 2.0f, this.ry * 2.0f);
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("width"))) {
            this.width = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("height"))) {
            this.height = styleAttribute.getFloatValueWithUnits();
        }
        boolean bl = false;
        if (this.getPres(styleAttribute.setName("rx"))) {
            this.rx = styleAttribute.getFloatValueWithUnits();
            bl = true;
        }
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("ry"))) {
            this.ry = styleAttribute.getFloatValueWithUnits();
            bl2 = true;
        }
        if (!bl) {
            this.rx = this.ry;
        }
        if (!bl2) {
            this.ry = this.rx;
        }
        this.rect = this.rx == 0.0f && this.ry == 0.0f ? new Rectangle2D.Float(this.x, this.y, this.width, this.height) : new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.rx * 2.0f, this.ry * 2.0f);
    }

    @Override
    public void render(Graphics2D graphics2D) throws SVGException {
        this.beginLayer(graphics2D);
        this.renderShape(graphics2D, this.rect);
        this.finishLayer(graphics2D);
    }

    @Override
    public Shape getShape() {
        return this.shapeToParent(this.rect);
    }

    @Override
    public Rectangle2D getBoundingBox() throws SVGException {
        return this.boundsToParent(this.includeStrokeInBounds(this.rect.getBounds2D()));
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x) {
            this.x = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y) {
            this.y = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("width")) && (f = styleAttribute.getFloatValueWithUnits()) != this.width) {
            this.width = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("height")) && (f = styleAttribute.getFloatValueWithUnits()) != this.height) {
            this.height = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("rx")) && (f = styleAttribute.getFloatValueWithUnits()) != this.rx) {
            this.rx = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("ry")) && (f = styleAttribute.getFloatValueWithUnits()) != this.ry) {
            this.ry = f;
            bl2 = true;
        }
        if (bl2) {
            this.build();
        }
        return bl || bl2;
    }
}

