/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadNotesTask
extends AbstractDownloadTask<NoteData> {
    private static final String PATTERN_API_URL = "https?://.*/api/0.6/notes.*";
    private static final String PATTERN_DUMP_FILE = "https?://.*/(.*\\.osn(.bz2)?)";
    public static final IntegerProperty DOWNLOAD_LIMIT = new IntegerProperty("osm.notes.downloadLimit", 1000);
    public static final IntegerProperty DAYS_CLOSED = new IntegerProperty("osm.notes.daysClosed", 7);
    private DownloadTask downloadTask;

    public Future<?> download(long l, ProgressMonitor progressMonitor) {
        String string = OsmApi.getOsmApi().getBaseUrl() + "notes/" + l;
        this.downloadTask = new DownloadRawUrlTask(new OsmServerLocationReader(string), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadBoundingBoxTask(new BoundingBoxDownloader(bounds), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        this.downloadTask = string.endsWith(".bz2") ? new DownloadBzip2RawUrlTask(new OsmServerLocationReader(string), progressMonitor) : new DownloadRawUrlTask(new OsmServerLocationReader(string), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        return null;
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM Notes", new Object[0]);
    }

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_API_URL, PATTERN_DUMP_FILE};
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    class DownloadBzip2RawUrlTask
    extends DownloadTask {
        DownloadBzip2RawUrlTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(osmServerReader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseRawNotesBzip2(progressMonitor);
            }
            catch (OsmTransferException osmTransferException) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                DownloadNotesTask.this.rememberException(osmTransferException);
            }
        }
    }

    class DownloadRawUrlTask
    extends DownloadTask {
        DownloadRawUrlTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(osmServerReader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseRawNotes(progressMonitor);
            }
            catch (OsmTransferException osmTransferException) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                DownloadNotesTask.this.rememberException(osmTransferException);
            }
        }
    }

    class DownloadBoundingBoxTask
    extends DownloadTask {
        DownloadBoundingBoxTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(osmServerReader, progressMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            if (DownloadNotesTask.this.isCanceled()) {
                return;
            }
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            try {
                this.notesData = this.reader.parseNotes(DOWNLOAD_LIMIT.get(), DAYS_CLOSED.get(), progressMonitor);
            }
            catch (BoundingBoxDownloader.MoreNotesException moreNotesException) {
                Main.debug(moreNotesException);
                this.notesData = moreNotesException.notes;
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.trn("{0} note has been downloaded.", "{0} notes have been downloaded.", moreNotesException.limit, moreNotesException.limit) + "<br>" + I18n.tr("Since the download limit was {0}, there might be more notes to download.", moreNotesException.limit) + "<br>" + I18n.tr("Request a smaller area to make sure that all notes are being downloaded.", new Object[0]) + "</html>", I18n.tr("More notes to download", new Object[0]), 1);
            }
            catch (OsmTransferException osmTransferException) {
                if (DownloadNotesTask.this.isCanceled()) {
                    return;
                }
                DownloadNotesTask.this.rememberException(osmTransferException);
            }
        }
    }

    abstract class DownloadTask
    extends PleaseWaitRunnable {
        protected OsmServerReader reader;
        protected List<Note> notesData;

        DownloadTask(OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading Notes", new Object[0]), progressMonitor, false);
            this.reader = osmServerReader;
        }

        @Override
        protected void finish() {
            List<NoteLayer> list;
            DownloadNotesTask.this.rememberDownloadedData(new NoteData(this.notesData));
            if (DownloadNotesTask.this.isCanceled() || DownloadNotesTask.this.isFailed() || this.notesData == null || this.notesData.isEmpty()) {
                return;
            }
            if (Main.isDebugEnabled()) {
                Main.debug("Notes downloaded: " + this.notesData.size());
            }
            if (!(list = Main.getLayerManager().getLayersOfType(NoteLayer.class)).isEmpty()) {
                list.get(0).getNoteData().addNotes(this.notesData);
            } else {
                Main.getLayerManager().addLayer(new NoteLayer(this.notesData, I18n.tr("Notes", new Object[0])));
            }
        }

        @Override
        protected void cancel() {
            DownloadNotesTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public abstract void realRun() throws IOException, SAXException, OsmTransferException;
    }
}

