/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class NameMismatch
extends Test.TagTest {
    protected static final int NAME_MISSING = 1501;
    protected static final int NAME_TRANSLATION_MISSING = 1502;
    private static final Pattern NAME_SPLIT_PATTERN = Pattern.compile(" - ");

    public NameMismatch() {
        super(I18n.tr("Missing name:* translation", new Object[0]), I18n.tr("This test finds multilingual objects whose ''name'' attribute is not equal to some ''name:*'' attribute and not a composition of ''name:*'' attributes, e.g., Italia - Italien - Italy.", new Object[0]));
    }

    private void missingTranslation(OsmPrimitive osmPrimitive, String string) {
        this.errors.add(TestError.builder(this, Severity.OTHER, 1502).message(I18n.tr("Missing name:* translation", new Object[0]), I18n.marktr("Missing name:*={0}. Add tag with correct language key."), string).primitives(osmPrimitive).build());
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        HashSet hashSet = new HashSet();
        osmPrimitive.getKeys().forEach((string, string2) -> {
            if (string2 != null && string.startsWith("name:") && !"name:etymology:wikidata".equals(string)) {
                hashSet.add(string2);
            }
        });
        if (hashSet.isEmpty()) {
            return;
        }
        String string3 = osmPrimitive.get("name");
        if (string3 == null) {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1501).message(I18n.tr("A name is missing, even though name:* exists.", new Object[0])).primitives(osmPrimitive).build());
            return;
        }
        if (hashSet.contains(string3)) {
            return;
        }
        String[] stringArray = NAME_SPLIT_PATTERN.split(string3);
        if (stringArray.length == 1) {
            this.missingTranslation(osmPrimitive, stringArray[0]);
            return;
        }
        for (String string4 : stringArray) {
            if (hashSet.contains(string4)) continue;
            this.missingTranslation(osmPrimitive, string4);
        }
    }
}

