/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class RelationChecker
extends Test {
    public static final int ROLE_UNKNOWN = 1701;
    public static final int ROLE_EMPTY = 1702;
    public static final int WRONG_TYPE = 1703;
    public static final int HIGH_COUNT = 1704;
    public static final int LOW_COUNT = 1705;
    public static final int ROLE_MISSING = 1706;
    public static final int RELATION_UNKNOWN = 1707;
    public static final int RELATION_EMPTY = 1708;
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("Checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        RelationChecker.initializePresets();
    }

    public static synchronized void initializePresets() {
        if (!relationpresets.isEmpty()) {
            return;
        }
        block0: for (TaggingPreset taggingPreset : TaggingPresets.getTaggingPresets()) {
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (!(taggingPresetItem instanceof Roles)) continue;
                relationpresets.add(taggingPreset);
                continue block0;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        Map<String, RolePreset> map = RelationChecker.buildAllRoles(relation);
        if (map.isEmpty() && relation.hasTag("type", "route") && relation.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1707).message(I18n.tr("Route scheme is unspecified. Add {0} ({1}=public_transport; {2}=legacy)", "public_transport:version", "2", "1")).primitives(relation).build());
        } else if (map.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1707).message(I18n.tr("Relation type is unknown", new Object[0])).primitives(relation).build());
        }
        Map<String, RoleInfo> map2 = RelationChecker.buildRoleInfoMap(relation);
        if (map2.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1708).message(I18n.tr("Relation is empty", new Object[0])).primitives(relation).build());
        } else if (!map.isEmpty()) {
            this.checkRoles(relation, map, map2);
        }
    }

    private static Map<String, RoleInfo> buildRoleInfoMap(Relation relation) {
        HashMap<String, RoleInfo> hashMap = new HashMap<String, RoleInfo>();
        for (RelationMember relationMember : relation.getMembers()) {
            String string = relationMember.getRole();
            RoleInfo roleInfo = (RoleInfo)hashMap.get(string);
            if (roleInfo == null) {
                roleInfo = new RoleInfo();
                hashMap.put(string, roleInfo);
            }
            roleInfo.total++;
        }
        return hashMap;
    }

    private static Map<String, RolePreset> buildAllRoles(Relation relation) {
        HashMap<String, RolePreset> hashMap = new HashMap<String, RolePreset>();
        for (TaggingPreset taggingPreset : relationpresets) {
            boolean bl = TaggingPresetItem.matches(Utils.filteredCollection(taggingPreset.data, KeyedItem.class), relation.getKeys());
            Roles roles = Utils.find(taggingPreset.data, Roles.class);
            if (!bl || roles == null) continue;
            for (Roles.Role role : roles.roles) {
                List<Roles.Role> list;
                String string = role.key;
                if (hashMap.containsKey(string)) {
                    list = ((RolePreset)hashMap.get(string)).roles;
                } else {
                    list = new LinkedList();
                    hashMap.put(string, new RolePreset(list, taggingPreset.name));
                }
                list.add(role);
            }
        }
        return hashMap;
    }

    private boolean checkMemberType(Roles.Role role, RelationMember relationMember) {
        if (role.types != null) {
            switch (relationMember.getDisplayType()) {
                case NODE: {
                    return role.types.contains((Object)TaggingPresetType.NODE);
                }
                case CLOSEDWAY: {
                    return role.types.contains((Object)TaggingPresetType.CLOSEDWAY);
                }
                case WAY: {
                    return role.types.contains((Object)TaggingPresetType.WAY);
                }
                case MULTIPOLYGON: {
                    return role.types.contains((Object)TaggingPresetType.MULTIPOLYGON);
                }
                case RELATION: {
                    return role.types.contains((Object)TaggingPresetType.RELATION);
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkMemberExpressionAndType(RolePreset rolePreset, RelationMember relationMember, Relation relation) {
        if (rolePreset == null || rolePreset.roles == null) {
            return true;
        }
        TestError testError = null;
        for (Object object : rolePreset.roles) {
            if (this.checkMemberType((Roles.Role)object, relationMember)) {
                if (((Roles.Role)object).memberExpression == null) {
                    return true;
                }
                Object object2 = relationMember.getMember();
                if (!((AbstractPrimitive)object2).isUsable()) {
                    return true;
                }
                if (((Roles.Role)object).memberExpression.match((OsmPrimitive)object2)) {
                    return true;
                }
                testError = TestError.builder(this, Severity.WARNING, 1703).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role member does not match expression {0} in template {1}"), ((Roles.Role)object).memberExpression, rolePreset.name).primitives(relationMember.getMember().isUsable() ? relationMember.getMember() : relation).build();
                continue;
            }
            if (!OsmPrimitiveType.RELATION.equals((Object)relationMember.getType()) || relationMember.getMember().isUsable() || !((Roles.Role)object).types.contains((Object)TaggingPresetType.MULTIPOLYGON)) continue;
            return true;
        }
        if (testError != null) {
            this.errors.add(testError);
        } else {
            Object object;
            EnumSet<TaggingPresetType> enumSet = EnumSet.noneOf(TaggingPresetType.class);
            for (Object object2 : rolePreset.roles) {
                enumSet.addAll(((Roles.Role)object2).types);
            }
            object = enumSet.stream().map(taggingPresetType -> I18n.tr(taggingPresetType.getName(), new Object[0])).collect(Collectors.joining("/"));
            this.errors.add(TestError.builder(this, Severity.WARNING, 1703).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role member type {0} does not match accepted list of {1} in template {2}"), new Object[]{relationMember.getType(), object, rolePreset.name}).primitives(relationMember.getMember().isUsable() ? relationMember.getMember() : relation).build());
        }
        return false;
    }

    private void checkRoles(Relation relation, Map<String, RolePreset> map, Map<String, RoleInfo> map2) {
        Object object;
        for (RelationMember object2 : relation.getMembers()) {
            object = object2.getRole();
            this.checkMemberExpressionAndType(map.get(object), object2, relation);
        }
        for (RolePreset rolePreset : map.values()) {
            for (Roles.Role role : rolePreset.roles) {
                String string2 = role.key;
                if (string2.isEmpty()) {
                    string2 = I18n.tr("<empty>", new Object[0]);
                }
                this.checkRoleCounts(relation, role, string2, map2.get(role.key));
            }
        }
        for (String string3 : map2.keySet()) {
            if (map.containsKey(string3)) continue;
            object = map.keySet().stream().map(string -> I18n.tr(string, new Object[0])).collect(Collectors.joining("/"));
            if (!string3.isEmpty()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1701).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role {0} unknown in templates {1}"), string3, object).primitives(relation).build());
                continue;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 1702).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Empty role type found when expecting one of {0}"), object).primitives(relation).build());
        }
    }

    private void checkRoleCounts(Relation relation, Roles.Role role, String string, RoleInfo roleInfo) {
        long l;
        long l2 = roleInfo == null ? 0L : (long)roleInfo.total;
        if (l2 != (l = role.getValidCount(l2))) {
            if (l2 == 0L) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1706).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role {0} missing"), string).primitives(relation).build());
            } else if (l > l2) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1705).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of {0} roles too low ({1})"), string, l2).primitives(relation).build());
            } else {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1704).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of {0} roles too high ({1})"), string, l2).primitives(relation).build());
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (this.isFixable(testError) && !testError.getPrimitives().iterator().next().isDeleted()) {
            return new DeleteCommand(testError.getPrimitives());
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        return testError.getCode() == 1708 && !collection.isEmpty() && collection.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total;

        private RoleInfo() {
        }
    }

    private static class RolePreset {
        private final List<Roles.Role> roles;
        private final String name;

        RolePreset(List<Roles.Role> list, String string) {
            this.roles = list;
            this.name = string;
        }
    }
}

