/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

class NotificationManager {
    private final Timer hideTimer;
    private final Timer pauseTimer;
    private final Timer unfreezeDelayTimer;
    private boolean running;
    private Notification currentNotification;
    private NotificationPanel currentNotificationPanel;
    private final Queue<Notification> queue = new LinkedList<Notification>();
    private static IntegerProperty pauseTime = new IntegerProperty("notification-default-pause-time-ms", 300);
    private long displayTimeStart;
    private long elapsedTime;
    private static NotificationManager instance;
    private static final Color PANEL_SEMITRANSPARENT;
    private static final Color PANEL_OPAQUE;

    NotificationManager() {
        this.hideTimer = new Timer(Notification.TIME_DEFAULT, actionEvent -> this.stopHideTimer());
        this.hideTimer.setRepeats(false);
        this.pauseTimer = new Timer(pauseTime.get(), new PauseFinishedEvent());
        this.pauseTimer.setRepeats(false);
        this.unfreezeDelayTimer = new Timer(10, new UnfreezeEvent());
        this.unfreezeDelayTimer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNotification(Notification notification) {
        Queue<Notification> queue = this.queue;
        synchronized (queue) {
            this.queue.add(notification);
            this.processQueue();
        }
    }

    private void processQueue() {
        if (this.running) {
            return;
        }
        this.currentNotification = this.queue.poll();
        if (this.currentNotification == null) {
            return;
        }
        this.currentNotificationPanel = new NotificationPanel(this.currentNotification, new FreezeMouseListener(), actionEvent -> this.stopHideTimer());
        this.currentNotificationPanel.validate();
        int n = 5;
        JFrame jFrame = (JFrame)Main.parent;
        Dimension dimension = this.currentNotificationPanel.getPreferredSize();
        if (jFrame != null) {
            int n2;
            int n3;
            if (Main.isDisplayingMapView() && Main.map.mapView.getHeight() > 0) {
                MapView mapView = Main.map.mapView;
                Point point = SwingUtilities.convertPoint(mapView.getParent(), mapView.getX(), mapView.getY(), Main.parent);
                n3 = point.x + n;
                n2 = point.y + mapView.getHeight() - Main.map.statusLine.getHeight() - dimension.height - n;
            } else {
                n3 = n;
                n2 = jFrame.getHeight() - Main.toolbar.control.getSize().height - dimension.height - n;
            }
            jFrame.getLayeredPane().add(this.currentNotificationPanel, JLayeredPane.POPUP_LAYER, 0);
            this.currentNotificationPanel.setLocation(n3, n2);
        }
        this.currentNotificationPanel.setSize(dimension);
        this.currentNotificationPanel.setVisible(true);
        this.running = true;
        this.elapsedTime = 0L;
        this.startHideTimer();
    }

    private void startHideTimer() {
        int n = (int)((long)this.currentNotification.getDuration() - this.elapsedTime);
        if (n < 300) {
            n = 300;
        }
        this.displayTimeStart = System.currentTimeMillis();
        this.hideTimer.setInitialDelay(n);
        this.hideTimer.restart();
    }

    private void stopHideTimer() {
        this.hideTimer.stop();
        if (this.currentNotificationPanel != null) {
            this.currentNotificationPanel.setVisible(false);
            JFrame jFrame = (JFrame)Main.parent;
            if (jFrame != null) {
                jFrame.getLayeredPane().remove(this.currentNotificationPanel);
            }
            this.currentNotificationPanel = null;
        }
        this.pauseTimer.restart();
    }

    public static synchronized NotificationManager getInstance() {
        if (instance == null) {
            instance = new NotificationManager();
        }
        return instance;
    }

    static {
        PANEL_SEMITRANSPARENT = new Color(224, 236, 249, 230);
        PANEL_OPAQUE = new Color(224, 236, 249);
    }

    public static class RoundedPanel
    extends JPanel {
        RoundedPanel() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getBackground());
            float f = 1.4f;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double((double)f / 2.0 + (double)this.getInsets().left, (double)f / 2.0 + (double)this.getInsets().top, (double)this.getWidth() - (double)f / 2.0 - (double)this.getInsets().left - (double)this.getInsets().right, (double)this.getHeight() - (double)f / 2.0 - (double)this.getInsets().top - (double)this.getInsets().bottom, 20.0, 20.0);
            graphics2D.fill(double_);
            graphics2D.setColor(this.getForeground());
            graphics2D.setStroke(new BasicStroke(f));
            graphics2D.draw(double_);
            super.paintComponent(graphics);
        }
    }

    class FreezeMouseListener
    extends MouseAdapter {
        FreezeMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (NotificationManager.this.unfreezeDelayTimer.isRunning()) {
                NotificationManager.this.unfreezeDelayTimer.stop();
            } else {
                NotificationManager.this.hideTimer.stop();
                NotificationManager.this.elapsedTime = NotificationManager.this.elapsedTime + (System.currentTimeMillis() - NotificationManager.this.displayTimeStart);
                NotificationManager.this.currentNotificationPanel.setNotificationBackground(PANEL_OPAQUE);
                NotificationManager.this.currentNotificationPanel.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            NotificationManager.this.unfreezeDelayTimer.restart();
        }
    }

    private static class NotificationPanel
    extends JPanel {
        private JPanel innerPanel;

        NotificationPanel(Notification notification, MouseListener mouseListener, ActionListener actionListener) {
            this.setVisible(false);
            this.build(notification, mouseListener, actionListener);
        }

        public void setNotificationBackground(Color color) {
            this.innerPanel.setBackground(color);
        }

        private void build(final Notification notification, MouseListener mouseListener, ActionListener actionListener) {
            Object object;
            JButton jButton = new JButton();
            jButton.addActionListener(actionListener);
            jButton.setIcon(ImageProvider.get("misc", "grey_x"));
            jButton.setPreferredSize(new Dimension(50, 50));
            jButton.setMargin(new Insets(0, 0, 1, 1));
            jButton.setContentAreaFilled(false);
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setBorderPainted(false);
            jToolBar.setOpaque(false);
            jToolBar.add(jButton);
            JToolBar jToolBar2 = null;
            if (notification.getHelpTopic() != null) {
                object = new JButton(I18n.tr("Help", new Object[0]));
                ((AbstractButton)object).setIcon(ImageProvider.get("help"));
                ((JComponent)object).setToolTipText(I18n.tr("Show help information", new Object[0]));
                HelpUtil.setHelpContext((JComponent)object, notification.getHelpTopic());
                ((AbstractButton)object).addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(() -> HelpBrowser.setUrlForHelpTopic(notification.getHelpTopic()));
                    }
                });
                ((JComponent)object).setOpaque(false);
                jToolBar2 = new JToolBar();
                jToolBar2.setFloatable(false);
                jToolBar2.setBorderPainted(false);
                jToolBar2.setOpaque(false);
                jToolBar2.add((Component)object);
            }
            this.setOpaque(false);
            this.innerPanel = new RoundedPanel();
            this.innerPanel.setBackground(PANEL_SEMITRANSPARENT);
            this.innerPanel.setForeground(Color.BLACK);
            object = new GroupLayout(this.innerPanel);
            this.innerPanel.setLayout((LayoutManager)object);
            ((GroupLayout)object).setAutoCreateGaps(true);
            ((GroupLayout)object).setAutoCreateContainerGaps(true);
            this.innerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add(this.innerPanel);
            JLabel jLabel = null;
            if (notification.getIcon() != null) {
                jLabel = new JLabel(notification.getIcon());
            }
            Component component = notification.getContent();
            GroupLayout.SequentialGroup sequentialGroup = ((GroupLayout)object).createSequentialGroup();
            if (jLabel != null) {
                sequentialGroup.addComponent(jLabel);
            }
            if (jToolBar2 != null) {
                sequentialGroup.addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(component).addComponent(jToolBar2));
            } else {
                sequentialGroup.addComponent(component);
            }
            sequentialGroup.addComponent(jToolBar);
            GroupLayout.ParallelGroup parallelGroup = ((GroupLayout)object).createParallelGroup();
            if (jLabel != null) {
                parallelGroup.addComponent(jLabel);
            }
            parallelGroup.addComponent(component);
            parallelGroup.addComponent(jToolBar);
            ((GroupLayout)object).setHorizontalGroup(sequentialGroup);
            if (jToolBar2 != null) {
                ((GroupLayout)object).setVerticalGroup(((GroupLayout)object).createSequentialGroup().addGroup(parallelGroup).addComponent(jToolBar2));
            } else {
                ((GroupLayout)object).setVerticalGroup(parallelGroup);
            }
            NotificationPanel.addMouseListenerToAllChildComponents(this, mouseListener);
        }

        private static void addMouseListenerToAllChildComponents(Component component, MouseListener mouseListener) {
            component.addMouseListener(mouseListener);
            if (component instanceof Container) {
                for (Component component2 : ((Container)component).getComponents()) {
                    NotificationPanel.addMouseListenerToAllChildComponents(component2, mouseListener);
                }
            }
        }
    }

    private class UnfreezeEvent
    implements ActionListener {
        private UnfreezeEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NotificationManager.this.currentNotificationPanel != null) {
                NotificationManager.this.currentNotificationPanel.setNotificationBackground(PANEL_SEMITRANSPARENT);
                NotificationManager.this.currentNotificationPanel.repaint();
            }
            NotificationManager.this.startHideTimer();
        }
    }

    private class PauseFinishedEvent
    implements ActionListener {
        private PauseFinishedEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Queue queue = NotificationManager.this.queue;
            synchronized (queue) {
                NotificationManager.this.running = false;
                NotificationManager.this.processQueue();
            }
        }
    }
}

