/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.josm.gui.layer.imagery.TilePosition;

public class TileRange {
    protected int minX;
    protected int maxX;
    protected int minY;
    protected int maxY;
    protected int zoom;

    protected TileRange() {
    }

    protected TileRange(TileXY tileXY, TileXY tileXY2, int n) {
        this.minX = (int)Math.floor(Math.min(tileXY.getX(), tileXY2.getX()));
        this.minY = (int)Math.floor(Math.min(tileXY.getY(), tileXY2.getY()));
        this.maxX = (int)Math.ceil(Math.max(tileXY.getX(), tileXY2.getX()));
        this.maxY = (int)Math.ceil(Math.max(tileXY.getY(), tileXY2.getY()));
        this.zoom = n;
    }

    protected double tilesSpanned() {
        return Math.sqrt(1.0 * (double)this.size());
    }

    public int size() {
        int n = this.maxX - this.minX + 1;
        int n2 = this.maxY - this.minY + 1;
        return n * n2;
    }

    public Stream<TilePosition> tilePositions() {
        if (this.zoom == 0) {
            return Stream.empty();
        }
        return IntStream.rangeClosed(this.minX, this.maxX).mapToObj(n -> IntStream.rangeClosed(this.minY, this.maxY).mapToObj(n2 -> new TilePosition(n, n2, this.zoom))).flatMap(Function.identity());
    }
}

