/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SystemExit"}, parent="Exception")
public class RubySystemExit
extends RubyException {
    IRubyObject status;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySystemExit(runtime, klass);
        }
    };

    static RubyClass createSystemExitClass(Ruby runtime, RubyClass exceptionClass) {
        RubyClass systemExitClass = runtime.defineClass("SystemExit", exceptionClass, ALLOCATOR);
        systemExitClass.defineAnnotatedMethods(RubySystemExit.class);
        return systemExitClass;
    }

    public static RubySystemExit newInstance(Ruby runtime, int status2, String message2) {
        RubyClass klass = runtime.getSystemExit();
        IRubyObject[] args2 = new IRubyObject[]{runtime.newFixnum(status2), runtime.newString(message2)};
        return (RubySystemExit)klass.newInstance(runtime.getCurrentContext(), args2, Block.NULL_BLOCK);
    }

    protected RubySystemExit(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
        this.status = runtime.getNil();
    }

    @Override
    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        if (args2.length > 0) {
            IRubyObject arg2 = args2[0];
            if (arg2 instanceof RubyFixnum) {
                this.status = arg2;
                if (args2.length > 1) {
                    this.setMessage(args2[1]);
                }
            } else if (arg2 instanceof RubyBoolean) {
                Ruby runtime;
                this.status = runtime.newFixnum(arg2 == (runtime = this.getRuntime()).getTrue() ? 0 : 1);
                if (args2.length > 1) {
                    this.setMessage(args2[1]);
                }
            } else {
                this.setMessage(arg2);
                this.status = RubyFixnum.zero(this.getRuntime());
            }
        } else {
            this.status = RubyFixnum.zero(this.getRuntime());
        }
        super.initialize(NULL_ARRAY, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject status() {
        return this.status;
    }

    @JRubyMethod(name={"success?"})
    public IRubyObject success_p() {
        Ruby runtime = this.getRuntime();
        IRubyObject status2 = this.status;
        if (status2.isNil()) {
            return runtime.getTrue();
        }
        if (status2 == runtime.getTrue() || status2 == runtime.getFalse()) {
            return status2;
        }
        if (status2.equals(RubyFixnum.zero(runtime))) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }
}

