/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import java.io.InputStream;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class Main {
    public static void main(String[] args) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setHardExit(true);
        config.processArguments(args);
        InputStream in = config.getScriptSource();
        String filename = config.displayedFileName();
        Ruby runtime = Ruby.newInstance((RubyInstanceConfig)config);
        config.setCompileMode(RubyInstanceConfig.CompileMode.TRUFFLE);
        if (in != null) {
            ValueAccessor programName = new ValueAccessor((IRubyObject)runtime.newString(filename));
            runtime.getGlobalVariables().define("$PROGRAM_NAME", (IAccessor)programName, GlobalVariable.Scope.GLOBAL);
            runtime.getGlobalVariables().define("$0", (IAccessor)programName, GlobalVariable.Scope.GLOBAL);
            for (Map.Entry entry : config.getOptionGlobals().entrySet()) {
                Object varvalue = entry.getValue() != null ? runtime.newString((String)entry.getValue()) : runtime.getTrue();
                runtime.getGlobalVariables().set("$" + (String)entry.getKey(), (IRubyObject)varvalue);
            }
            int exitCode = runtime.getTruffleContext().execute(filename);
            System.exit(exitCode);
        }
    }
}

