/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class Match2ParseNode
extends ParseNode {
    private final ParseNode receiverNode;
    private final ParseNode valueNode;

    public Match2ParseNode(ISourcePosition position, ParseNode receiverNode, ParseNode valueNode) {
        super(position, receiverNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MATCH2NODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitMatch2Node(this);
    }

    public ParseNode getReceiverNode() {
        return this.receiverNode;
    }

    public ParseNode getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

