/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.scope;

import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;
import org.jruby.util.ArraySupport;

public class ManyVarsDynamicScope
extends DynamicScope {
    private IRubyObject[] variableValues;

    public ManyVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
        this.allocate();
    }

    public ManyVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
        this.allocate();
    }

    private void allocate() {
        if (this.variableValues == null) {
            int size = this.staticScope.getNumberOfVariables();
            this.variableValues = new IRubyObject[size];
        }
    }

    @Override
    public DynamicScope cloneScope() {
        return new ManyVarsDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return this.variableValues;
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        this.assertGetValue(offset, depth);
        return this.variableValues[offset];
    }

    @Override
    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        this.assertGetValueDepthZeroOrNil(offset);
        IRubyObject value = this.variableValues[offset];
        return value == null ? this.setValueDepthZero(nil, offset) : value;
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueZeroDepthZeroOrNil();
        IRubyObject value = this.variableValues[0];
        return value == null ? this.setValueZeroDepthZero(nil) : value;
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueOneDepthZeroOrNil();
        IRubyObject value = this.variableValues[1];
        return value == null ? this.setValueOneDepthZero(nil) : value;
    }

    @Override
    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueTwoDepthZeroOrNil();
        IRubyObject value = this.variableValues[2];
        return value == null ? this.setValueTwoDepthZero(nil) : value;
    }

    @Override
    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueThreeDepthZeroOrNil();
        IRubyObject value = this.variableValues[3];
        return value == null ? this.setValueThreeDepthZero(nil) : value;
    }

    @Override
    public IRubyObject setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            this.assertParent();
            return this.parent.setValue(offset, value, depth - 1);
        }
        this.assertSetValue(offset, value);
        return this.setValueDepthZero(value, offset);
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value, int offset) {
        this.assertSetValueDepthZero(offset, value);
        this.variableValues[offset] = value;
        return this.variableValues[offset];
    }

    @Override
    public IRubyObject setValueZeroDepthZero(IRubyObject value) {
        this.assertSetValueZeroDepthZero(value);
        this.variableValues[0] = value;
        return this.variableValues[0];
    }

    @Override
    public IRubyObject setValueOneDepthZero(IRubyObject value) {
        this.assertSetValueOneDepthZero(value);
        this.variableValues[1] = value;
        return this.variableValues[1];
    }

    @Override
    public IRubyObject setValueTwoDepthZero(IRubyObject value) {
        this.assertSetValueTwoDepthZero(value);
        this.variableValues[2] = value;
        return this.variableValues[2];
    }

    @Override
    public IRubyObject setValueThreeDepthZero(IRubyObject value) {
        this.assertSetValueThreeDepthZero(value);
        this.variableValues[3] = value;
        return this.variableValues[3];
    }

    @Override
    public void growIfNeeded() {
        int dynamicSize;
        int n = dynamicSize = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > dynamicSize) {
            Object[] values = new IRubyObject[this.staticScope.getNumberOfVariables()];
            if (dynamicSize > 0) {
                ArraySupport.copy((Object[])this.variableValues, (int)0, (Object[])values, (int)0, (int)dynamicSize);
            }
            this.variableValues = values;
        }
    }

    private void assertGetValue(int offset, int depth) {
        IRubyObject[] values = this.variableValues;
        assert (values != null && offset < values.length) : "No variables or index to big for getValue off: " + offset + ", Dep: " + depth + ", O: " + this;
    }

    private void assertGetValueDepthZeroOrNil(int offset) {
        IRubyObject[] values = this.variableValues;
        assert (values != null && offset < values.length) : "No variables or index too big for getValue off: " + offset + ", Dep: " + 0 + ", O: " + this;
    }

    private void assertGetValueZeroDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 0 < values.length) : "No variables or index to big for getValue off: 0, Dep: 0, O: " + this;
    }

    private void assertGetValueOneDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 1 < values.length) : "No variables or index to big for getValue off: 1, Dep: 0, O: " + this;
    }

    private void assertGetValueTwoDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 3 < values.length) : "No variables or index to big for getValue off: 3, Dep: 0, O: " + this;
    }

    private void assertGetValueThreeDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 2 < values.length) : "No variables or index to big for getValue off: 2, Dep: 0, O: " + this;
    }

    private void assertParent() {
        assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
    }

    private void assertSetValue(int offset, IRubyObject value) {
        assert (offset < this.variableValues.length) : "Setting " + offset + " to " + value + ", O: " + this;
    }

    private void assertSetValueDepthZero(int offset, IRubyObject value) {
        assert (offset < this.variableValues.length) : "Setting " + offset + " to " + value + ", O: " + this;
    }

    private void assertSetValueZeroDepthZero(IRubyObject value) {
        assert (0 < this.variableValues.length) : "Setting 0 to " + value + ", O: " + this;
    }

    private void assertSetValueOneDepthZero(IRubyObject value) {
        assert (1 < this.variableValues.length) : "Setting 1 to " + value + ", O: " + this;
    }

    private void assertSetValueThreeDepthZero(IRubyObject value) {
        assert (3 < this.variableValues.length) : "Setting 3 to " + value + ", O: " + this;
    }

    private void assertSetValueTwoDepthZero(IRubyObject value) {
        assert (2 < this.variableValues.length) : "Setting 2 to " + value + ", O: " + this;
    }
}

