/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.jsr166e.ConcurrentHashMapV8;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.ExpiringCache;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DynamicTimer
extends AbstractMonitor<Long>
implements CompositeMonitor<Long> {
    private static final String DEFAULT_EXPIRATION = "15";
    private static final String DEFAULT_EXPIRATION_UNIT = "MINUTES";
    private static final String CLASS_NAME = DynamicTimer.class.getCanonicalName();
    private static final String EXPIRATION_PROP = CLASS_NAME + ".expiration";
    private static final String EXPIRATION_PROP_UNIT = CLASS_NAME + ".expirationUnit";
    private static final String INTERNAL_ID = "servoTimers";
    private static final MonitorConfig BASE_CONFIG = new MonitorConfig.Builder("servoTimers").build();
    private static final DynamicTimer INSTANCE = new DynamicTimer();
    private final ExpiringCache<ConfigUnit, Timer> timers;

    private DynamicTimer() {
        super(BASE_CONFIG);
        String expiration = System.getProperty(EXPIRATION_PROP, DEFAULT_EXPIRATION);
        String expirationUnit = System.getProperty(EXPIRATION_PROP_UNIT, DEFAULT_EXPIRATION_UNIT);
        long expirationValue = Long.valueOf(expiration);
        TimeUnit expirationUnitValue = TimeUnit.valueOf(expirationUnit);
        long expireAfterMs = expirationUnitValue.toMillis(expirationValue);
        this.timers = new ExpiringCache<ConfigUnit, Timer>(expireAfterMs, new ConcurrentHashMapV8.Fun<ConfigUnit, Timer>(){

            @Override
            public Timer apply(ConfigUnit configUnit) {
                return new BasicTimer(configUnit.config, configUnit.unit);
            }
        });
        DefaultMonitorRegistry.getInstance().register(this);
    }

    private Timer get(MonitorConfig config, TimeUnit unit) {
        return this.timers.get(new ConfigUnit(config, unit));
    }

    public static Stopwatch start(MonitorConfig config, TimeUnit unit) {
        return INSTANCE.get(config, unit).start();
    }

    public static Stopwatch start(MonitorConfig config) {
        return INSTANCE.get(config, TimeUnit.MILLISECONDS).start();
    }

    public static void record(MonitorConfig config, long duration) {
        INSTANCE.get(config, TimeUnit.MILLISECONDS).record(duration, TimeUnit.MILLISECONDS);
    }

    public static void record(MonitorConfig config, long duration, TimeUnit unit) {
        INSTANCE.get(config, unit).record(duration, unit);
    }

    public static Stopwatch start(String name, String ... tags) {
        MonitorConfig.Builder configBuilder = MonitorConfig.builder(name);
        Preconditions.checkArgument((tags.length % 2 == 0 ? 1 : 0) != 0, (Object)"The sequence of (key, value) pairs must have even size: one key, one value");
        for (int i = 0; i < tags.length; i += 2) {
            configBuilder.withTag(tags[i], tags[i + 1]);
        }
        return INSTANCE.get(configBuilder.build(), TimeUnit.MILLISECONDS).start();
    }

    public static Stopwatch start(String name, TagList list) {
        MonitorConfig config = new MonitorConfig.Builder(name).withTags(list).build();
        return INSTANCE.get(config, TimeUnit.MILLISECONDS).start();
    }

    public static Stopwatch start(String name, TagList list, TimeUnit unit) {
        MonitorConfig config = new MonitorConfig.Builder(name).withTags(list).build();
        return INSTANCE.get(config, unit).start();
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        List<Monitor<?>> list = this.timers.values();
        return list;
    }

    @Override
    public Long getValue(int pollerIdx) {
        return this.timers.size();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("baseConfig", (Object)BASE_CONFIG).add("totalTimers", this.timers.size()).add("timers", this.timers).toString();
    }

    static class ConfigUnit {
        final MonitorConfig config;
        final TimeUnit unit;

        ConfigUnit(MonitorConfig config, TimeUnit unit) {
            this.config = config;
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigUnit that = (ConfigUnit)o;
            return this.config.equals(that.config) && this.unit == that.unit;
        }

        public int hashCode() {
            int result = this.config.hashCode();
            result = 31 * result + this.unit.hashCode();
            return result;
        }
    }
}

