/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.RotationShardShuffler;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.ShardShuffler;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class IndexShardRoutingTable
implements Iterable<ShardRouting> {
    final ShardShuffler shuffler;
    final ShardId shardId;
    final ShardRouting primary;
    final List<ShardRouting> primaryAsList;
    final List<ShardRouting> replicas;
    final List<ShardRouting> shards;
    final List<ShardRouting> activeShards;
    final List<ShardRouting> assignedShards;
    static final List<ShardRouting> NO_SHARDS = Collections.emptyList();
    final boolean allShardsStarted;
    private volatile Map<AttributesKey, AttributesRoutings> activeShardsByAttributes = Collections.emptyMap();
    private volatile Map<AttributesKey, AttributesRoutings> initializingShardsByAttributes = Collections.emptyMap();
    private final Object shardsByAttributeMutex = new Object();
    final List<ShardRouting> allInitializingShards;

    IndexShardRoutingTable(ShardId shardId, List<ShardRouting> shards) {
        this.shardId = shardId;
        this.shuffler = new RotationShardShuffler(Randomness.get().nextInt());
        this.shards = Collections.unmodifiableList(shards);
        ShardRouting primary = null;
        ArrayList<ShardRouting> replicas = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> activeShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> assignedShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> allInitializingShards = new ArrayList<ShardRouting>();
        boolean allShardsStarted = true;
        for (ShardRouting shard : shards) {
            if (shard.primary()) {
                primary = shard;
            } else {
                replicas.add(shard);
            }
            if (shard.active()) {
                activeShards.add(shard);
            }
            if (shard.initializing()) {
                allInitializingShards.add(shard);
            }
            if (shard.relocating()) {
                allInitializingShards.add(shard.getTargetRelocatingShard());
            }
            if (shard.assignedToNode()) {
                assignedShards.add(shard);
            }
            if (shard.state() == ShardRoutingState.STARTED) continue;
            allShardsStarted = false;
        }
        this.allShardsStarted = allShardsStarted;
        this.primary = primary;
        this.primaryAsList = primary != null ? Collections.singletonList(primary) : Collections.emptyList();
        this.replicas = Collections.unmodifiableList(replicas);
        this.activeShards = Collections.unmodifiableList(activeShards);
        this.assignedShards = Collections.unmodifiableList(assignedShards);
        this.allInitializingShards = Collections.unmodifiableList(allInitializingShards);
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    @Override
    public Iterator<ShardRouting> iterator() {
        return this.shards.iterator();
    }

    public int size() {
        return this.shards.size();
    }

    public int getSize() {
        return this.size();
    }

    public List<ShardRouting> shards() {
        return this.shards;
    }

    public List<ShardRouting> getShards() {
        return this.shards();
    }

    public List<ShardRouting> activeShards() {
        return this.activeShards;
    }

    public List<ShardRouting> getActiveShards() {
        return this.activeShards();
    }

    public List<ShardRouting> assignedShards() {
        return this.assignedShards;
    }

    public List<ShardRouting> getAssignedShards() {
        return this.assignedShards;
    }

    public ShardIterator shardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.shuffler.shuffle(this.shards));
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId, this.shards);
    }

    public ShardIterator shardsIt(int seed) {
        return new PlainShardIterator(this.shardId, this.shuffler.shuffle(this.shards, seed));
    }

    public ShardIterator activeInitializingShardsRandomIt() {
        return this.activeInitializingShardsIt(this.shuffler.nextSeed());
    }

    public ShardIterator activeInitializingShardsIt(int seed) {
        if (this.allInitializingShards.isEmpty()) {
            return new PlainShardIterator(this.shardId, this.shuffler.shuffle(this.activeShards, seed));
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        ordered.addAll(this.shuffler.shuffle(this.activeShards, seed));
        ordered.addAll(this.allInitializingShards);
        return new PlainShardIterator(this.shardId, ordered);
    }

    private boolean noPrimariesActive() {
        return !this.primaryAsList.isEmpty() && !this.primaryAsList.get(0).active() && !this.primaryAsList.get(0).initializing();
    }

    public ShardIterator primaryShardIt() {
        return new PlainShardIterator(this.shardId, this.primaryAsList);
    }

    public ShardIterator primaryActiveInitializingShardIt() {
        if (this.noPrimariesActive()) {
            return new PlainShardIterator(this.shardId, NO_SHARDS);
        }
        return this.primaryShardIt();
    }

    public ShardIterator primaryFirstActiveInitializingShardsIt() {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards)) {
            ordered.add(shardRouting);
            if (!shardRouting.primary()) continue;
            ordered.set(ordered.size() - 1, ordered.get(0));
            ordered.set(0, shardRouting);
        }
        if (!this.allInitializingShards.isEmpty()) {
            ordered.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator replicaActiveInitializingShardIt() {
        if (this.noPrimariesActive()) {
            return new PlainShardIterator(this.shardId, NO_SHARDS);
        }
        LinkedList<ShardRouting> ordered = new LinkedList<ShardRouting>();
        for (ShardRouting replica : this.shuffler.shuffle(this.replicas)) {
            if (replica.active()) {
                ordered.addFirst(replica);
                continue;
            }
            if (!replica.initializing()) continue;
            ordered.addLast(replica);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator replicaFirstActiveInitializingShardsIt() {
        if (this.noPrimariesActive()) {
            return new PlainShardIterator(this.shardId, NO_SHARDS);
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (ShardRouting replica : this.shuffler.shuffle(this.replicas)) {
            if (!replica.active()) continue;
            ordered.add(replica);
        }
        ordered.add(this.primary);
        if (!this.allInitializingShards.isEmpty()) {
            ordered.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator onlyNodeActiveInitializingShardsIt(String nodeId) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        int seed = this.shuffler.nextSeed();
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards, seed)) {
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.allInitializingShards, seed)) {
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator onlyNodeSelectorActiveInitializingShardsIt(String nodeAttributes, DiscoveryNodes discoveryNodes) {
        return this.onlyNodeSelectorActiveInitializingShardsIt(new String[]{nodeAttributes}, discoveryNodes);
    }

    public ShardIterator onlyNodeSelectorActiveInitializingShardsIt(String[] nodeAttributes, DiscoveryNodes discoveryNodes) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        HashSet<String> selectedNodes = Sets.newHashSet(discoveryNodes.resolveNodes(nodeAttributes));
        int seed = this.shuffler.nextSeed();
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards, seed)) {
            if (!selectedNodes.contains(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.allInitializingShards, seed)) {
            if (!selectedNodes.contains(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        if (ordered.isEmpty()) {
            String message = String.format(Locale.ROOT, "no data nodes with %s [%s] found for shard: %s", nodeAttributes.length == 1 ? "criteria" : "criterion", String.join((CharSequence)",", nodeAttributes), this.shardId());
            throw new IllegalArgumentException(message);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator preferNodeActiveInitializingShardsIt(Set<String> nodeIds) {
        ArrayList<ShardRouting> preferred = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        ArrayList<ShardRouting> notPreferred = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards)) {
            if (nodeIds.contains(shardRouting.currentNodeId())) {
                preferred.add(shardRouting);
                continue;
            }
            notPreferred.add(shardRouting);
        }
        preferred.addAll(notPreferred);
        if (!this.allInitializingShards.isEmpty()) {
            preferred.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, preferred);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexShardRoutingTable that = (IndexShardRoutingTable)o;
        if (!this.shardId.equals(that.shardId)) {
            return false;
        }
        return this.shards.equals(that.shards);
    }

    public int hashCode() {
        int result = this.shardId.hashCode();
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public boolean allShardsStarted() {
        return this.allShardsStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributesRoutings getActiveAttribute(AttributesKey key, DiscoveryNodes nodes) {
        AttributesRoutings shardRoutings = this.activeShardsByAttributes.get(key);
        if (shardRoutings == null) {
            Object object = this.shardsByAttributeMutex;
            synchronized (object) {
                ArrayList<ShardRouting> from = new ArrayList<ShardRouting>(this.activeShards);
                List<ShardRouting> to = IndexShardRoutingTable.collectAttributeShards(key, nodes, from);
                shardRoutings = new AttributesRoutings(to, Collections.unmodifiableList(from));
                this.activeShardsByAttributes = MapBuilder.newMapBuilder(this.activeShardsByAttributes).put(key, shardRoutings).immutableMap();
            }
        }
        return shardRoutings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributesRoutings getInitializingAttribute(AttributesKey key, DiscoveryNodes nodes) {
        AttributesRoutings shardRoutings = this.initializingShardsByAttributes.get(key);
        if (shardRoutings == null) {
            Object object = this.shardsByAttributeMutex;
            synchronized (object) {
                ArrayList<ShardRouting> from = new ArrayList<ShardRouting>(this.allInitializingShards);
                List<ShardRouting> to = IndexShardRoutingTable.collectAttributeShards(key, nodes, from);
                shardRoutings = new AttributesRoutings(to, Collections.unmodifiableList(from));
                this.initializingShardsByAttributes = MapBuilder.newMapBuilder(this.initializingShardsByAttributes).put(key, shardRoutings).immutableMap();
            }
        }
        return shardRoutings;
    }

    private static List<ShardRouting> collectAttributeShards(AttributesKey key, DiscoveryNodes nodes, ArrayList<ShardRouting> from) {
        ArrayList<ShardRouting> to = new ArrayList<ShardRouting>();
        for (String attribute : key.attributes) {
            String localAttributeValue = nodes.getLocalNode().getAttributes().get(attribute);
            if (localAttributeValue == null) continue;
            Iterator<ShardRouting> iterator = from.iterator();
            while (iterator.hasNext()) {
                ShardRouting fromShard = iterator.next();
                DiscoveryNode discoveryNode = nodes.get(fromShard.currentNodeId());
                if (discoveryNode == null) {
                    iterator.remove();
                    continue;
                }
                if (!localAttributeValue.equals(discoveryNode.getAttributes().get(attribute))) continue;
                iterator.remove();
                to.add(fromShard);
            }
        }
        return Collections.unmodifiableList(to);
    }

    public ShardIterator preferAttributesActiveInitializingShardsIt(String[] attributes, DiscoveryNodes nodes) {
        return this.preferAttributesActiveInitializingShardsIt(attributes, nodes, this.shuffler.nextSeed());
    }

    public ShardIterator preferAttributesActiveInitializingShardsIt(String[] attributes, DiscoveryNodes nodes, int seed) {
        AttributesKey key = new AttributesKey(attributes);
        AttributesRoutings activeRoutings = this.getActiveAttribute(key, nodes);
        AttributesRoutings initializingRoutings = this.getInitializingAttribute(key, nodes);
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(activeRoutings.totalSize + initializingRoutings.totalSize);
        ordered.addAll(this.shuffler.shuffle(activeRoutings.withSameAttribute, seed));
        ordered.addAll(this.shuffler.shuffle(activeRoutings.withoutSameAttribute, seed));
        ordered.addAll(this.shuffler.shuffle(initializingRoutings.withSameAttribute, seed));
        ordered.addAll(this.shuffler.shuffle(initializingRoutings.withoutSameAttribute, seed));
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardRouting primaryShard() {
        return this.primary;
    }

    public List<ShardRouting> replicaShards() {
        return this.replicas;
    }

    public List<ShardRouting> replicaShardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this.replicas) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        if (state == ShardRoutingState.INITIALIZING) {
            return this.allInitializingShards;
        }
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            if (shardEntry.state() != state) continue;
            shards.add(shardEntry);
        }
        return shards;
    }

    public static class Builder {
        private ShardId shardId;
        private final List<ShardRouting> shards;

        public Builder(IndexShardRoutingTable indexShard) {
            this.shardId = indexShard.shardId;
            this.shards = new ArrayList<ShardRouting>(indexShard.shards);
        }

        public Builder(ShardId shardId) {
            this.shardId = shardId;
            this.shards = new ArrayList<ShardRouting>();
        }

        public Builder addShard(ShardRouting shardEntry) {
            for (ShardRouting shard : this.shards) {
                if (!shard.assignedToNode() || !shardEntry.assignedToNode() || !shard.currentNodeId().equals(shardEntry.currentNodeId())) continue;
                return this;
            }
            this.shards.add(shardEntry);
            return this;
        }

        public Builder removeShard(ShardRouting shardEntry) {
            this.shards.remove(shardEntry);
            return this;
        }

        public IndexShardRoutingTable build() {
            return new IndexShardRoutingTable(this.shardId, Collections.unmodifiableList(new ArrayList<ShardRouting>(this.shards)));
        }

        public static IndexShardRoutingTable readFrom(StreamInput in) throws IOException {
            Index index = new Index(in);
            return Builder.readFromThin(in, index);
        }

        public static IndexShardRoutingTable readFromThin(StreamInput in, Index index) throws IOException {
            int iShardId = in.readVInt();
            ShardId shardId = new ShardId(index, iShardId);
            Builder builder = new Builder(shardId);
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                ShardRouting shard = new ShardRouting(shardId, in);
                builder.addShard(shard);
            }
            return builder.build();
        }

        public static void writeTo(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeString(indexShard.shardId().getIndex().getName());
            Builder.writeToThin(indexShard, out);
        }

        public static void writeToThin(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeVInt(indexShard.shards.size());
            for (ShardRouting entry : indexShard) {
                entry.writeToThin(out);
            }
        }
    }

    static class AttributesRoutings {
        public final List<ShardRouting> withSameAttribute;
        public final List<ShardRouting> withoutSameAttribute;
        public final int totalSize;

        AttributesRoutings(List<ShardRouting> withSameAttribute, List<ShardRouting> withoutSameAttribute) {
            this.withSameAttribute = withSameAttribute;
            this.withoutSameAttribute = withoutSameAttribute;
            this.totalSize = withoutSameAttribute.size() + withSameAttribute.size();
        }
    }

    static class AttributesKey {
        final String[] attributes;

        AttributesKey(String[] attributes) {
            this.attributes = attributes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.attributes);
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.attributes, ((AttributesKey)obj).attributes);
        }
    }
}

