/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.WritePipelineResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.ingest.IngestInfo;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.ingest.Processor;

public class PipelineStore
extends AbstractComponent
implements ClusterStateListener {
    private final Pipeline.Factory factory = new Pipeline.Factory();
    private final Map<String, Processor.Factory> processorFactories;
    volatile Map<String, Pipeline> pipelines = new HashMap<String, Pipeline>();

    public PipelineStore(Settings settings, Map<String, Processor.Factory> processorFactories) {
        super(settings);
        this.processorFactories = processorFactories;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.innerUpdatePipelines(event.previousState(), event.state());
    }

    void innerUpdatePipelines(ClusterState previousState, ClusterState state) {
        IngestMetadata previousIngestMetadata;
        IngestMetadata ingestMetadata = (IngestMetadata)state.getMetaData().custom("ingest");
        if (Objects.equals(ingestMetadata, previousIngestMetadata = (IngestMetadata)previousState.getMetaData().custom("ingest"))) {
            return;
        }
        HashMap<String, Pipeline> pipelines = new HashMap<String, Pipeline>();
        for (PipelineConfiguration pipeline : ingestMetadata.getPipelines().values()) {
            try {
                pipelines.put(pipeline.getId(), this.factory.create(pipeline.getId(), pipeline.getConfigAsMap(), this.processorFactories));
            }
            catch (ElasticsearchParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("Error updating pipeline with id [" + pipeline.getId() + "]", (Throwable)e, new Object[0]);
            }
        }
        this.pipelines = Collections.unmodifiableMap(pipelines);
    }

    public void delete(ClusterService clusterService, final DeletePipelineRequest request, ActionListener<WritePipelineResponse> listener) {
        clusterService.submitStateUpdateTask("delete-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<WritePipelineResponse>((AckedRequest)request, listener){

            @Override
            protected WritePipelineResponse newResponse(boolean acknowledged) {
                return new WritePipelineResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return PipelineStore.this.innerDelete(request, currentState);
            }
        });
    }

    ClusterState innerDelete(DeletePipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metaData().custom("ingest");
        if (currentIngestMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
        if (!pipelines.containsKey(request.getId())) {
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        pipelines = new HashMap<String, PipelineConfiguration>(pipelines);
        pipelines.remove(request.getId());
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metaData(MetaData.builder(currentState.getMetaData()).putCustom("ingest", new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    public void put(ClusterService clusterService, Map<DiscoveryNode, IngestInfo> ingestInfos, final PutPipelineRequest request, ActionListener<WritePipelineResponse> listener) throws Exception {
        this.validatePipeline(ingestInfos, request);
        clusterService.submitStateUpdateTask("put-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<WritePipelineResponse>((AckedRequest)request, listener){

            @Override
            protected WritePipelineResponse newResponse(boolean acknowledged) {
                return new WritePipelineResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return PipelineStore.this.innerPut(request, currentState);
            }
        });
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, PutPipelineRequest request) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        Map<String, Object> pipelineConfig = XContentHelper.convertToMap(request.getSource(), false).v2();
        Pipeline pipeline = this.factory.create(request.getId(), pipelineConfig, this.processorFactories);
        ArrayList<IllegalArgumentException> exceptions = new ArrayList<IllegalArgumentException>();
        for (Processor processor : pipeline.flattenAllProcessors()) {
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                if (entry.getValue().containsProcessor(processor.getType())) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + entry.getKey() + "]";
                exceptions.add(new IllegalArgumentException(message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    ClusterState innerPut(PutPipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metaData().custom("ingest");
        HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metaData(MetaData.builder(currentState.getMetaData()).putCustom("ingest", new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    public Pipeline get(String id) {
        return this.pipelines.get(id);
    }

    public Map<String, Processor.Factory> getProcessorFactories() {
        return this.processorFactories;
    }

    public List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetaData().custom("ingest");
        return this.innerGetPipelines(ingestMetadata, ids);
    }

    List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }
}

