#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.3.8
id: tls-1.3.8-AP2CWOA2Qcw6OdA165NwUU
key: tls-1.3.8-AP2CWOA2Qcw6OdA165NwUU
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Internal Network.TLS.Extra Network.TLS.Extra.Cipher
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.ECDH Network.TLS.ErrT
                Network.TLS.Extension Network.TLS.Extension.EC
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
abi: d463db9c1ad70ba77437d6052e57a93f
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/tls-1.3.8
library-dirs: /usr/lib/ghc-8.0.1/site-local/tls-1.3.8
data-dir: /usr/share/arm-linux-ghc-8.0.1/tls-1.3.8
hs-libraries: HStls-1.3.8-AP2CWOA2Qcw6OdA165NwUU
depends:
    asn1-encoding-0.9.4-G3Eu427lfih60n7Hu41ILm
    asn1-types-0.3.2-7OJ0HzVkSNEBIwzF1QvaHd
    async-2.1.0-IGx6TJY2BPOHCk3x4WAuIK base-4.9.0.0 bytestring-0.10.8.1
    cereal-0.5.4.0-1RWVeyNi1If1ir8gxayRPi
    cryptonite-0.20-5Mid6BVFFeIFMzbvEgM6vI
    data-default-class-0.1.2.0-6eetmQ6CbQOLoXb6k5kODu
    memory-0.13-9YH63fsEcp4AuUH5L0KHp mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    network-2.6.3.1-G4Up1CPKbp7DeFsnywOnGG transformers-0.5.2.0
    x509-1.6.4-AQd8BJOkfBD1up0H04WoXR
    x509-store-1.6.2-6UQrEcokOvBAMbtSL6B67o
    x509-validation-1.6.5-1wJ1PPg1FNLyGUX9VDyGO
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
