/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadReferrersTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private OsmServerReader reader;
    private final OsmDataLayer targetLayer;
    private final Map<Long, OsmPrimitiveType> children;
    private final DataSet parents;

    public DownloadReferrersTask(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        super("Download referrers", false);
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "targetLayer");
        this.canceled = false;
        this.children = new HashMap<Long, OsmPrimitiveType>();
        if (collection != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.isNew()) continue;
                this.children.put(osmPrimitive.getId(), OsmPrimitiveType.from(osmPrimitive));
            }
        }
        this.targetLayer = osmDataLayer;
        this.parents = new DataSet();
    }

    public DownloadReferrersTask(OsmDataLayer osmDataLayer, PrimitiveId primitiveId, ProgressMonitor progressMonitor) {
        super("Download referrers", progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "targetLayer");
        if (primitiveId.isNew()) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot download referrers for new primitives (ID {0})", primitiveId.getUniqueId()));
        }
        this.canceled = false;
        this.children = new HashMap<Long, OsmPrimitiveType>();
        this.children.put(primitiveId.getUniqueId(), primitiveId.getType());
        this.targetLayer = osmDataLayer;
        this.parents = new DataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadReferrersTask downloadReferrersTask = this;
        synchronized (downloadReferrersTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionUtil.explainException(this.lastException);
            return;
        }
        DataSetMerger dataSetMerger = new DataSetMerger(this.targetLayer.data, this.parents);
        dataSetMerger.merge();
        SwingUtilities.invokeLater(this.targetLayer::onPostDownloadFromServer);
        if (dataSetMerger.getConflicts().isEmpty()) {
            return;
        }
        this.targetLayer.getConflicts().add(dataSetMerger.getConflicts());
        JOptionPane.showMessageDialog(Main.parent, I18n.trn("There was {0} conflict during import.", "There were {0} conflicts during import.", dataSetMerger.getConflicts().size(), dataSetMerger.getConflicts().size()), I18n.trn("Conflict during download", "Conflicts during download", dataSetMerger.getConflicts().size(), new Object[0]), 2);
        Main.map.conflictDialog.unfurlDialog();
        Main.map.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadParents(long l, OsmPrimitiveType osmPrimitiveType, ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSetMerger dataSetMerger;
        this.reader = new OsmServerBackreferenceReader(l, osmPrimitiveType);
        DataSet dataSet = this.reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
        Object object = this;
        synchronized (object) {
            this.reader = null;
        }
        object = dataSet.getWays();
        if (!object.isEmpty()) {
            Object object2;
            HashSet<Node> hashSet = new HashSet<Node>();
            Object object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = (Way)object3.next();
                hashSet.addAll(((Way)object2).getNodes());
            }
            hashSet.removeAll(this.targetLayer.data.getNodes());
            if (!hashSet.isEmpty()) {
                this.reader = MultiFetchServerObjectReader.create();
                ((MultiFetchServerObjectReader)this.reader).append(hashSet);
                object3 = this.reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                object2 = this;
                synchronized (object2) {
                    this.reader = null;
                }
                dataSetMerger = new DataSetMerger(dataSet, (DataSet)object3);
                dataSetMerger.merge();
            }
        }
        dataSetMerger = new DataSetMerger(this.parents, dataSet);
        dataSetMerger.merge();
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.progressMonitor.setTicksCount(this.children.size());
            int n = 1;
            for (Map.Entry<Long, OsmPrimitiveType> entry : this.children.entrySet()) {
                String string;
                if (this.canceled) {
                    return;
                }
                switch (entry.getValue()) {
                    case NODE: {
                        string = I18n.tr("({0}/{1}) Loading parents of node {2}", n + 1, this.children.size(), entry.getKey());
                        break;
                    }
                    case WAY: {
                        string = I18n.tr("({0}/{1}) Loading parents of way {2}", n + 1, this.children.size(), entry.getKey());
                        break;
                    }
                    case RELATION: {
                        string = I18n.tr("({0}/{1}) Loading parents of relation {2}", n + 1, this.children.size(), entry.getKey());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.progressMonitor.subTask(string);
                this.downloadParents(entry.getKey(), entry.getValue(), this.progressMonitor);
                ++n;
            }
        }
        catch (OsmTransferException osmTransferException) {
            if (this.canceled) {
                return;
            }
            this.lastException = osmTransferException;
        }
    }
}

