/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class MultipolygonTest
extends Test {
    public static final int WRONG_MEMBER_TYPE = 1601;
    public static final int WRONG_MEMBER_ROLE = 1602;
    public static final int NON_CLOSED_WAY = 1603;
    public static final int MISSING_OUTER_WAY = 1604;
    public static final int INNER_WAY_OUTSIDE = 1605;
    public static final int CROSSING_WAYS = 1606;
    public static final int OUTER_STYLE_MISMATCH = 1607;
    public static final int INNER_STYLE_MISMATCH = 1608;
    public static final int NOT_CLOSED = 1609;
    public static final int NO_STYLE = 1610;
    public static final int NO_STYLE_POLYGON = 1611;
    public static final int OUTER_STYLE = 1613;
    public static final int REPEATED_MEMBER_SAME_ROLE = 1614;
    public static final int REPEATED_MEMBER_DIFF_ROLE = 1615;
    private static volatile ElemStyles styles;
    private final Set<String> keysCheckedByAnotherTest = new HashSet<String>();

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid.", new Object[0]));
    }

    @Override
    public void initialize() {
        styles = MapPaintStyles.getStyles();
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.keysCheckedByAnotherTest.clear();
        for (Test test : OsmValidator.getEnabledTests(false)) {
            if (!(test instanceof UnclosedWays)) continue;
            this.keysCheckedByAnotherTest.addAll(((UnclosedWays)test).getCheckedKeys());
            break;
        }
    }

    @Override
    public void endTest() {
        this.keysCheckedByAnotherTest.clear();
        super.endTest();
    }

    private static GeneralPath createPath(List<Node> list) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)list.get(0).getCoor().lat(), (float)list.get(0).getCoor().lon());
        for (int i = 1; i < list.size(); ++i) {
            Node node = list.get(i);
            generalPath.lineTo((float)node.getCoor().lat(), (float)node.getCoor().lon());
        }
        return generalPath;
    }

    private static List<GeneralPath> createPolygons(List<Multipolygon.PolyData> list) {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (Multipolygon.PolyData polyData : list) {
            arrayList.add(MultipolygonTest.createPath(polyData.getNodes()));
        }
        return arrayList;
    }

    private static Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath generalPath, List<Node> list) {
        boolean bl = false;
        boolean bl2 = false;
        for (Node node : list) {
            boolean bl3 = generalPath.contains(node.getCoor().lat(), node.getCoor().lon());
            if (!((bl |= bl3) & (bl2 |= !bl3))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return bl ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Way way) {
        if (!way.isArea() && ElemStyles.hasOnlyAreaElemStyle(way)) {
            List<Node> list = way.getNodes();
            if (list.isEmpty()) {
                return;
            }
            for (String string : this.keysCheckedByAnotherTest) {
                if (!way.hasKey(string)) continue;
                return;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 1609).message(I18n.tr("Area style way is not closed", new Object[0])).primitives(way).highlight(Arrays.asList(list.get(0), list.get(list.size() - 1))).build());
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isMultipolygon()) {
            this.checkMembersAndRoles(relation);
            this.checkOuterWay(relation);
            this.checkRepeatedWayMembers(relation);
            if (!relation.hasIncompleteMembers()) {
                Multipolygon multipolygon = new Multipolygon(relation);
                this.checkMemberRoleCorrectness(relation);
                this.checkStyleConsistency(relation, multipolygon);
                this.checkGeometry(relation, multipolygon);
            }
        }
    }

    private void checkOuterWay(Relation relation) {
        boolean bl = false;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!"outer".equals(relationMember.getRole())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1604).message(I18n.tr("No outer way for multipolygon", new Object[0])).primitives(relation).build());
        }
    }

    private void checkMemberRoleCorrectness(Relation relation) {
        Pair<Relation, Relation> pair = CreateMultipolygonAction.createMultipolygonRelation(relation.getMemberPrimitives(Way.class), false);
        if (pair != null) {
            for (RelationMember relationMember : relation.getMembers()) {
                Collection<RelationMember> collection = ((Relation)pair.b).getMembersFor(Collections.singleton(relationMember.getMember()));
                if (collection == null || collection.isEmpty()) continue;
                String string = collection.iterator().next().getRole();
                if (relationMember.getRole().equals(string)) continue;
                this.errors.add(TestError.builder(this, Severity.WARNING, 1602).message(RelationChecker.ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role for ''{0}'' should be ''{1}''"), relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance()), string).primitives(MultipolygonTest.addRelationIfNeeded(relation, relationMember.getMember())).highlight(relationMember.getMember()).build());
            }
        }
    }

    private void checkStyleConsistency(Relation relation, Multipolygon multipolygon) {
        if (styles != null && !"boundary".equals(relation.get("type"))) {
            boolean bl;
            AreaElement areaElement = ElemStyles.getAreaElemStyle(relation, false);
            boolean bl2 = bl = areaElement != null;
            if (areaElement == null) {
                Way way;
                Iterator<Way> iterator = multipolygon.getOuterWays().iterator();
                while (iterator.hasNext() && (areaElement = ElemStyles.getAreaElemStyle(way = iterator.next(), true)) == null) {
                }
                if (areaElement == null) {
                    this.errors.add(TestError.builder(this, Severity.OTHER, 1610).message(I18n.tr("No area style for multipolygon", new Object[0])).primitives(relation).build());
                } else {
                    this.errors.add(TestError.builder(this, Severity.WARNING, 1611).message(I18n.trn("Multipolygon relation should be tagged with area tags and not the outer way", "Multipolygon relation should be tagged with area tags and not the outer ways", multipolygon.getOuterWays().size(), new Object[0])).primitives(relation).build());
                }
            }
            if (areaElement != null) {
                AreaElement areaElement2;
                for (Way way : multipolygon.getInnerWays()) {
                    areaElement2 = ElemStyles.getAreaElemStyle(way, false);
                    if (areaElement2 == null || !areaElement.equals(areaElement2)) continue;
                    this.errors.add(TestError.builder(this, Severity.OTHER, 1608).message(I18n.tr("With the currently used mappaint style the style for inner way equals the multipolygon style", new Object[0])).primitives(MultipolygonTest.addRelationIfNeeded(relation, way)).highlight(way).build());
                }
                for (Way way : multipolygon.getOuterWays()) {
                    areaElement2 = ElemStyles.getAreaElemStyle(way, false);
                    if (areaElement2 == null) continue;
                    if (!areaElement.equals(areaElement2)) {
                        String string = !bl ? I18n.tr("Style for outer way mismatches", new Object[0]) : I18n.tr("With the currently used mappaint style(s) the style for outer way mismatches the area style", new Object[0]);
                        this.errors.add(TestError.builder(this, Severity.OTHER, 1607).message(string).primitives(MultipolygonTest.addRelationIfNeeded(relation, way)).highlight(way).build());
                        continue;
                    }
                    if (!bl) continue;
                    this.errors.add(TestError.builder(this, Severity.WARNING, 1613).message(I18n.tr("Area style on outer way", new Object[0])).primitives(MultipolygonTest.addRelationIfNeeded(relation, way)).highlight(way).build());
                }
            }
        }
    }

    private void checkGeometry(Relation relation, Multipolygon multipolygon) {
        int n;
        Multipolygon.PolyData polyData;
        int n2;
        List<Node> list = multipolygon.getOpenEnds();
        if (!list.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1603).message(I18n.tr("Multipolygon is not closed", new Object[0])).primitives(MultipolygonTest.addRelationIfNeeded(relation, list)).highlight(list).build());
        }
        List<Multipolygon.PolyData> list2 = multipolygon.getInnerPolygons();
        List<Multipolygon.PolyData> list3 = multipolygon.getOuterPolygons();
        List<GeneralPath> list4 = list2.isEmpty() ? Collections.emptyList() : MultipolygonTest.createPolygons(list2);
        List<GeneralPath> list5 = MultipolygonTest.createPolygons(list3);
        for (n2 = 0; n2 < list3.size(); ++n2) {
            polyData = list3.get(n2);
            for (n = n2 + 1; n < list3.size(); ++n) {
                this.checkCrossingWays(relation, list3, list5, polyData, n);
            }
        }
        for (n2 = 0; n2 < list2.size(); ++n2) {
            polyData = list2.get(n2);
            for (n = n2 + 1; n < list2.size(); ++n) {
                this.checkCrossingWays(relation, list2, list4, polyData, n);
            }
            n = 1;
            for (int i = 0; i < list3.size(); ++i) {
                n &= this.checkCrossingWays(relation, list3, list5, polyData, i) == Multipolygon.PolyData.Intersection.OUTSIDE ? 1 : 0;
            }
            if (n == 0) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 1605).message(I18n.tr("Multipolygon inner way is outside", new Object[0])).primitives(relation).highlightNodePairs(Collections.singletonList(polyData.getNodes())).build());
        }
    }

    private Multipolygon.PolyData.Intersection checkCrossingWays(Relation relation, List<Multipolygon.PolyData> list, List<GeneralPath> list2, Multipolygon.PolyData polyData, int n) {
        Multipolygon.PolyData polyData2;
        Multipolygon.PolyData.Intersection intersection = MultipolygonTest.getPolygonIntersection(list2.get(n), polyData.getNodes());
        if (intersection == Multipolygon.PolyData.Intersection.CROSSING && (polyData2 = list.get(n)) != null) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1606).message(I18n.tr("Intersection between multipolygon ways", new Object[0])).primitives(relation).highlightNodePairs(Arrays.asList(polyData.getNodes(), polyData2.getNodes())).build());
        }
        return intersection;
    }

    private void checkMembersAndRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isWay()) {
                if (relationMember.hasRole("inner", "outer") || !relationMember.hasRole()) continue;
                this.errors.add(TestError.builder(this, Severity.WARNING, 1602).message(I18n.tr("No useful role for multipolygon member", new Object[0])).primitives(MultipolygonTest.addRelationIfNeeded(relation, relationMember.getMember())).build());
                continue;
            }
            if (relationMember.hasRole("admin_centre", "label", "subarea", "land_area")) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 1601).message(I18n.tr("Non-Way in multipolygon", new Object[0])).primitives(MultipolygonTest.addRelationIfNeeded(relation, relationMember.getMember())).build());
        }
    }

    private static Collection<? extends OsmPrimitive> addRelationIfNeeded(Relation relation, OsmPrimitive osmPrimitive) {
        return MultipolygonTest.addRelationIfNeeded(relation, Collections.singleton(osmPrimitive));
    }

    private static Collection<? extends OsmPrimitive> addRelationIfNeeded(Relation relation, Collection<? extends OsmPrimitive> collection) {
        if (!collection.contains(relation)) {
            ArrayList<? extends OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection);
            arrayList.add(0, relation);
            return arrayList;
        }
        return collection;
    }

    private boolean checkRepeatedWayMembers(Relation relation) {
        boolean bl = false;
        HashMap<OsmPrimitive, ArrayList<RelationMember>> hashMap = new HashMap<OsmPrimitive, ArrayList<RelationMember>>();
        for (RelationMember object : relation.getMembers()) {
            List<RelationMember> list = (List)hashMap.get(object.getMember());
            if (list == null) {
                list = new ArrayList<RelationMember>(2);
                hashMap.put(object.getMember(), (ArrayList<RelationMember>)list);
            } else {
                bl = true;
            }
            list.add(object);
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            ArrayList<OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>();
            for (Map.Entry entry : hashMap.entrySet()) {
                List list = (List)entry.getValue();
                if (((List)entry.getValue()).size() == 1) continue;
                boolean bl2 = false;
                RelationMember relationMember = (RelationMember)list.get(0);
                ArrayList<OsmPrimitive> arrayList3 = new ArrayList<OsmPrimitive>();
                for (int i = 1; i < list.size(); ++i) {
                    RelationMember relationMember2 = (RelationMember)list.get(i);
                    arrayList3.add(relationMember.getMember());
                    if (relationMember2.getRole().equals(relationMember.getRole())) continue;
                    bl2 = true;
                }
                if (bl2) {
                    arrayList2.addAll(arrayList3);
                    continue;
                }
                arrayList.addAll(arrayList3);
            }
            this.addRepeatedMemberError(relation, arrayList2, 1615, I18n.tr("Multipolygon member(s) repeated with different role", new Object[0]));
            this.addRepeatedMemberError(relation, arrayList, 1614, I18n.tr("Multipolygon member(s) repeated with same role", new Object[0]));
        }
        return bl;
    }

    private void addRepeatedMemberError(Relation relation, List<OsmPrimitive> list, int n, String string) {
        if (!list.isEmpty()) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(1 + list.size());
            arrayList.add(relation);
            arrayList.addAll(list);
            this.errors.add(TestError.builder(this, Severity.WARNING, n).message(string).primitives(arrayList).highlight(list).build());
        }
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<? extends OsmPrimitive> arrayList;
        if (testError.getCode() == 1614 && (arrayList = new ArrayList<OsmPrimitive>(testError.getPrimitives())).size() >= 2 && arrayList.get(0) instanceof Relation) {
            Relation relation = (Relation)arrayList.get(0);
            Relation relation2 = new Relation(relation);
            List<? extends OsmPrimitive> list = arrayList.subList(1, arrayList.size());
            List<RelationMember> list2 = relation.getMembers();
            ArrayList<RelationMember> arrayList2 = new ArrayList<RelationMember>();
            HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(list);
            HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>(list.size());
            for (RelationMember relationMember : list2) {
                if (hashSet.contains(relationMember.getMember())) {
                    if (hashSet2.contains(relationMember.getMember())) continue;
                    hashSet2.add(relationMember.getMember());
                    arrayList2.add(relationMember);
                    continue;
                }
                arrayList2.add(relationMember);
            }
            relation2.setMembers(arrayList2);
            return new ChangeCommand(relation, relation2);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getCode() == 1614;
    }
}

