/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.animation.transition;

import com.sun.javafx.animation.transition.Position2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.ArrayList;

public class AnimationPathHelper {
    private static final int SMOOTH_ZONE = 10;
    private ArrayList<Segment> segments = new ArrayList();
    private double totalLength = 0.0;

    public AnimationPathHelper(Path2D path2D, BaseTransform baseTransform, double d) {
        Segment segment = Segment.getZeroSegment();
        Segment segment2 = Segment.getZeroSegment();
        float[] fArray = new float[6];
        PathIterator pathIterator = path2D.getPathIterator(baseTransform, (float)d);
        while (!pathIterator.isDone()) {
            Segment segment3 = null;
            int n = pathIterator.currentSegment(fArray);
            double d2 = fArray[0];
            double d3 = fArray[1];
            switch (n) {
                case 0: {
                    segment3 = segment = Segment.newMoveTo(d2, d3, segment2.accumLength);
                    break;
                }
                case 4: {
                    segment3 = Segment.newClosePath(segment2, segment);
                    if (segment3 != null) break;
                    segment2.convertToClosePath(segment);
                    break;
                }
                case 1: {
                    segment3 = Segment.newLineTo(segment2, d2, d3);
                }
            }
            if (segment3 != null) {
                this.segments.add(segment3);
                segment2 = segment3;
            }
            pathIterator.next();
        }
        this.totalLength = segment2.accumLength;
    }

    public Position2D getPosition2D(double d, boolean bl, Position2D position2D) {
        double d2 = this.totalLength * Math.min(1.0, Math.max(0.0, d));
        int n = this.findSegment(0, this.segments.size() - 1, d2);
        Segment segment = this.segments.get(n);
        double d3 = segment.accumLength - segment.length;
        double d4 = d2 - d3;
        if (position2D == null) {
            position2D = new Position2D();
        }
        double d5 = d4 / segment.length;
        Segment segment2 = segment.prevSeg;
        position2D.x = segment2.toX + (segment.toX - segment2.toX) * d5;
        position2D.y = segment2.toY + (segment.toY - segment2.toY) * d5;
        position2D.rotateAngle = segment.rotateAngle;
        double d6 = Math.min(10.0, segment.length / 2.0);
        if (d4 < d6 && !segment2.isMoveTo) {
            position2D.rotateAngle = AnimationPathHelper.interpolate(segment2.rotateAngle, segment.rotateAngle, d4 / d6 / 2.0 + 0.5);
        } else {
            double d7 = segment.length - d4;
            Segment segment3 = segment.nextSeg;
            if (d7 < d6 && segment3 != null && !segment3.isMoveTo) {
                position2D.rotateAngle = AnimationPathHelper.interpolate(segment.rotateAngle, segment3.rotateAngle, (d6 - d7) / d6 / 2.0);
            }
        }
        return position2D;
    }

    private static double interpolate(double d, double d2, double d3) {
        double d4 = d2 - d;
        if (Math.abs(d4) > 180.0) {
            d2 += d4 > 0.0 ? -360.0 : 360.0;
        }
        return AnimationPathHelper.normalize(d + d3 * (d2 - d));
    }

    private static double normalize(double d) {
        while (d > 360.0) {
            d -= 360.0;
        }
        while (d < 0.0) {
            d += 360.0;
        }
        return d;
    }

    private int findSegment(int n, int n2, double d) {
        if (n == n2) {
            return this.segments.get((int)n).isMoveTo && n > 0 ? this.findSegment(n - 1, n - 1, d) : n;
        }
        int n3 = n + (n2 - n) / 2;
        return this.segments.get((int)n3).accumLength > d ? this.findSegment(n, n3, d) : this.findSegment(n3 + 1, n2, d);
    }

    private static class Segment {
        private static Segment zeroSegment;
        boolean isMoveTo;
        double length;
        double accumLength;
        double toX;
        double toY;
        double rotateAngle;
        Segment prevSeg;
        Segment nextSeg;

        private Segment(boolean bl, double d, double d2, double d3, double d4, double d5) {
            this.isMoveTo = bl;
            this.toX = d;
            this.toY = d2;
            this.length = d3;
            this.accumLength = d4 + d3;
            this.rotateAngle = d5;
        }

        public static Segment getZeroSegment() {
            if (zeroSegment == null) {
                zeroSegment = new Segment(true, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            return zeroSegment;
        }

        public static Segment newMoveTo(double d, double d2, double d3) {
            return new Segment(true, d, d2, 0.0, d3, 0.0);
        }

        public static Segment newLineTo(Segment segment, double d, double d2) {
            double d3 = d - segment.toX;
            double d4 = d2 - segment.toY;
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            if (d5 >= 1.0 || segment.isMoveTo) {
                Segment segment2;
                double d6 = Math.signum(d4 == 0.0 ? d3 : d4);
                double d7 = d6 * Math.acos(d3 / d5);
                d7 = AnimationPathHelper.normalize(d7 / Math.PI * 180.0);
                segment.nextSeg = segment2 = new Segment(false, d, d2, d5, segment.accumLength, d7);
                segment2.prevSeg = segment;
                return segment2;
            }
            return null;
        }

        public static Segment newClosePath(Segment segment, Segment segment2) {
            Segment segment3 = Segment.newLineTo(segment, segment2.toX, segment2.toY);
            if (segment3 != null) {
                segment3.convertToClosePath(segment2);
            }
            return segment3;
        }

        public void convertToClosePath(Segment segment) {
            Segment segment2;
            this.nextSeg = segment2 = segment.nextSeg;
            segment2.prevSeg = this;
        }
    }
}

