/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.exceptions;

import com.sun.org.apache.xml.internal.security.utils.I18n;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class XMLSecurityException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected Exception originalException = null;
    protected String msgID;

    public XMLSecurityException() {
        super("Missing message string");
        this.msgID = null;
        this.originalException = null;
    }

    public XMLSecurityException(String _msgID) {
        super(I18n.getExceptionMessage(_msgID));
        this.msgID = _msgID;
        this.originalException = null;
    }

    public XMLSecurityException(String _msgID, Object[] exArgs) {
        super(MessageFormat.format(I18n.getExceptionMessage(_msgID), exArgs));
        this.msgID = _msgID;
        this.originalException = null;
    }

    public XMLSecurityException(Exception _originalException) {
        super("Missing message ID to locate message string in resource bundle \"com/sun/org/apache/xml/internal/security/resource/xmlsecurity\". Original Exception was a " + _originalException.getClass().getName() + " and message " + _originalException.getMessage());
        this.originalException = _originalException;
    }

    public XMLSecurityException(String _msgID, Exception _originalException) {
        super(I18n.getExceptionMessage(_msgID, _originalException));
        this.msgID = _msgID;
        this.originalException = _originalException;
    }

    public XMLSecurityException(String _msgID, Object[] exArgs, Exception _originalException) {
        super(MessageFormat.format(I18n.getExceptionMessage(_msgID), exArgs));
        this.msgID = _msgID;
        this.originalException = _originalException;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = super.getLocalizedMessage();
        message = message != null ? s + ": " + message : s;
        if (this.originalException != null) {
            message = message + "\nOriginal Exception was " + this.originalException.toString();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
            if (this.originalException != null) {
                this.originalException.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void printStackTrace(PrintWriter printwriter) {
        super.printStackTrace(printwriter);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printwriter);
        }
    }

    @Override
    public void printStackTrace(PrintStream printstream) {
        super.printStackTrace(printstream);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printstream);
        }
    }

    public Exception getOriginalException() {
        return this.originalException;
    }
}

