/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Stack;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.nbo.FileHndlr;
import org.openscience.jmol.app.nbo.HelpBtn;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBOService;

abstract class NBODialogModel
extends NBODialogConfig {
    private static final String INPUT_FILE_EXTENSIONS = "adf;cfi;gau;log;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;vfi;g09;com;47";
    private static final String OUTPUT_FILE_EXTENSIONS = "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;vfi;g09;com";
    private static final String[] editInfo = new String[]{"Edit nuclear charge, bond length, bond angle, or dihedral angle", "Remove bond between two atoms", "Delete monovalent atoms and replace with bond", "Add bond between two atoms", "Replace atom with a new substituent-group", "Switch location of two groups", "Perform rigid torsional twist about dihedral angle", "Value of nuclear charge, bond length, bond angle, and dihedral angle", "Create 3-center linkage between two atoms and a ligand"};
    protected int editMode;
    private static final int ALTER = 4;
    private static final int CLIP = 2;
    private static final int MUTATE = 1;
    private static final int MAX_HISTORY = 5;
    private static final String LOAD_SCRIPT = ";set zoomlarge false;zoomTo 0.5 {*} 0;";
    protected String editAction;
    private String moveTo;
    private Box editBox;
    private JTextField jtJmolInput;
    private JTextField jtLineInput;
    private JComboBox<String> jcSymOps;
    protected JTextField editValueTf;
    protected JButton jbEdit;
    protected JButton jbClear;
    protected JComboBox<String> jComboSave;
    protected JButton undo;
    protected JButton redo;
    Stack<String> undoStack;
    Stack<String> redoStack;
    protected JTextField currVal;
    protected JTextField[] atomNumBox;
    protected JLabel valLab = new JLabel("");
    protected JPanel panel;
    private boolean loadModel;
    protected String selected = "";
    ActionListener redoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBODialogModel.this.redoStack.pop();
            if (NBODialogModel.this.redoStack.isEmpty()) {
                NBODialogModel.this.redo.setEnabled(false);
            }
            NBODialogModel.this.loadModelToNBO(curr);
            NBODialogModel.this.appendOutputWithCaret("Redo", 'i');
        }
    };
    ActionListener undoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBODialogModel.this.undoStack.pop();
            if (NBODialogModel.this.undoStack.isEmpty()) {
                NBODialogModel.this.undo.setEnabled(false);
                return;
            }
            String tmp = NBODialogModel.this.undoStack.pop();
            NBODialogModel.this.loadModelToNBO(tmp);
            NBODialogModel.this.redoStack.push(curr);
            if (NBODialogModel.this.redoStack.size() > 5) {
                NBODialogModel.this.redoStack.removeElementAt(5);
            }
            NBODialogModel.this.appendOutputWithCaret("Undo", 'i');
        }
    };

    protected NBODialogModel(JFrame f) {
        super(f);
    }

    protected JPanel buildModelPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(NBODialogModel.titleBox(" Input Model ", new HelpBtn("model_input_intro_help.htm")));
        this.panel.add(this.useBox());
        this.panel.add(this.editBox(this.panel)).setVisible(false);
        this.panel.add(NBODialogModel.titleBox(" Save Model ", new HelpBtn("model_save_intro_help.htm"))).setVisible(false);
        this.panel.add(this.saveBox()).setVisible(false);
        if (this.vwr.ms.ac > 0) {
            this.runScriptNow("select within(model,visible)");
            this.loadModelToNBO(this.runScriptNow("print data({selected},'cfi')"));
        }
        return this.panel;
    }

    private Component useBox() {
        Box inputBox = this.borderBox(true);
        inputBox.setMaximumSize(new Dimension(355, 155));
        JRadioButton jrJmolIn = new JRadioButton("NIH/PubChem");
        jrJmolIn.setFont(nboFont);
        jrJmolIn.setSelected(true);
        JRadioButton jrLineIn = new JRadioButton("Line Formula");
        jrLineIn.setFont(nboFont);
        JRadioButton jrFileIn = new JRadioButton("File Input");
        jrFileIn.setFont(nboFont);
        ButtonGroup rg = new ButtonGroup();
        rg.add(jrJmolIn);
        rg.add(jrLineIn);
        rg.add(jrFileIn);
        this.jtJmolInput = new JTextField();
        this.createInput(this.jtJmolInput, jrJmolIn);
        this.jtLineInput = new JTextField();
        this.createInput(this.jtLineInput, jrLineIn);
        this.jtLineInput.add(new JLabel("line formula"));
        String[] useOps = new String[]{"<Select File  Type>", "[.cfi]  JMol Cartesian", "[.vfi]  JMol Valence", "[.47]   NBO Archive", "[.gau]  Gaussian Input", "[.log]  Gaussian Output", "[.gms]  GAMESS Input", "[.adf]  ADF Input", "[.jag]  Jaguar Input", "[.mm2]  MM2-Input", "[.mnd]  Dewar Type Input", "[.mp]   Molpro Input", "[.nw]   NWChem Input", "[.orc]  Orca Input", "[.pqs]  PQS Input", "[.qc]   Q-Chem Input"};
        final JComboBox<String> jComboUse = new JComboBox<String>(useOps);
        jComboUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = jComboUse.getSelectedItem();
                String tmp = NBODialogModel.this.fileHndlr.tfExt.getText();
                String s = "";
                if (jComboUse.getSelectedIndex() != 0) {
                    s = item.toString();
                    s = s.substring(s.indexOf("[") + 2, s.indexOf("]"));
                    NBODialogModel.this.fileHndlr.tfExt.setText(s);
                    NBODialogModel.this.fileHndlr.useExt = s;
                    if (!NBODialogModel.this.fileHndlr.browsePressed()) {
                        NBODialogModel.this.fileHndlr.tfExt.setText(tmp);
                    }
                } else {
                    NBODialogModel.this.fileHndlr.tfExt.setText("");
                    NBODialogModel.this.fileHndlr.useExt = s = NBODialogModel.INPUT_FILE_EXTENSIONS;
                    if (!NBODialogModel.this.fileHndlr.browsePressed()) {
                        NBODialogModel.this.fileHndlr.tfExt.setText(tmp);
                    }
                }
            }
        });
        JPanel p2 = new JPanel(new GridLayout(3, 2));
        p2.add(jrJmolIn);
        p2.add(this.jtJmolInput);
        p2.add(jrLineIn);
        p2.add(this.jtLineInput);
        p2.add(jrFileIn);
        p2.add(jComboUse);
        this.addListenersAndSize(jComboUse, jrFileIn);
        inputBox.add(p2);
        this.fileHndlr = new FileHndlr("", "", 1, INPUT_FILE_EXTENSIONS, (NBODialog)this){

            @Override
            protected boolean browsePressed() {
                int button;
                String folder = this.tfDir.getText().trim();
                String name = this.tfName.getText();
                String ext = this.tfExt.getText();
                if (!folder.equals("")) {
                    if (!folder.contains(":")) {
                        folder = "C:/" + folder;
                    }
                    folder = folder + "/" + (name.equals("") ? "new" : name + "." + ext);
                }
                JFileChooser myChooser = new JFileChooser();
                if (this.useExt.contains(";")) {
                    myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt.split(";")));
                } else {
                    myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt));
                }
                myChooser.setFileHidingEnabled(true);
                if (!folder.equals("")) {
                    myChooser.setSelectedFile(new File(folder));
                }
                if ((button = myChooser.showDialog(this, GT._("Select"))) == 0) {
                    File newFile = myChooser.getSelectedFile();
                    if (newFile.toString().indexOf(".") < 0) {
                        NBODialogModel.this.appendOutputWithCaret("File not found", 'i');
                        return false;
                    }
                    this.jobStem = 2.getJobStem(newFile);
                    NBODialogModel.this.loadModelFromNBO(newFile.getParent(), this.jobStem, FileHndlr.getExt(newFile));
                    NBODialogModel.this.fileHndlr.setInput(this.fileDir, this.jobStem, FileHndlr.getExt(newFile));
                    this.fileDir = newFile.getParent();
                    return true;
                }
                return false;
            }
        };
        inputBox.add(this.fileHndlr);
        return inputBox;
    }

    private Box editBox(Container c) {
        Box topBox = Box.createHorizontalBox();
        this.undo = new JButton("<HTML>&#8592Undo</HTML>");
        this.redo = new JButton("<HTML>Redo&#8594</HTML>");
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.redo.addActionListener(this.redoAction);
        this.undo.addActionListener(this.undoAction);
        topBox.add(this.undo);
        topBox.add(this.redo);
        topBox.add(new HelpBtn("model_edit_intro_help.htm"));
        c.add(NBODialogModel.titleBox(" Edit Model ", topBox)).setVisible(false);
        Box editBox = this.borderBox(false);
        Box actionBox = Box.createVerticalBox();
        final String[] actions = new String[]{"Alter", "Clip", "Fuse", "Link", "Mutate", "Switch", "Twist", "Value", "3chb"};
        JRadioButton[] btns = new JRadioButton[actions.length];
        ButtonGroup rg = new ButtonGroup();
        for (int i = 0; i < actions.length; ++i) {
            btns[i] = new JRadioButton(actions[i]);
            btns[i].setToolTipText(editInfo[i]);
            actionBox.add(btns[i]);
            rg.add(btns[i]);
            final int op = i;
            btns[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialogModel.this.editAction = actions[op].toLowerCase();
                    NBODialogModel.this.actionSelected(NBODialogModel.this.editAction.charAt(0));
                }
            });
        }
        editBox.add(actionBox);
        Box rightBox = Box.createVerticalBox();
        this.editBox2();
        rightBox.add(this.editBox);
        Box lowBox = Box.createHorizontalBox();
        JButton sym = new JButton("Symmetry?");
        sym.setToolTipText("Display point-group symmetry of current model");
        sym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.getSymmetry();
            }
        });
        lowBox.add(sym);
        JButton rebond = new JButton("Rebond");
        rebond.setToolTipText("Change bonding symmetry around transition metal");
        rebond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.editAction = "rebond";
                NBODialogModel.this.actionSelected(NBODialogModel.this.editAction.charAt(0));
            }
        });
        lowBox.add(rebond);
        rightBox.add(lowBox);
        editBox.add(rightBox);
        btns[0].doClick();
        return editBox;
    }

    private void editBox2() {
        this.editBox = Box.createVerticalBox();
        this.editBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.editBox.setMaximumSize(new Dimension(275, 200));
        this.editBox.setAlignmentX(0.5f);
        this.editBox.setVisible(false);
        Box atBox = Box.createHorizontalBox();
        atBox.add(new JLabel("Atoms: "));
        this.atomNumBox = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.atomNumBox[i] = new JTextField();
            this.atomNumBox[i].setMaximumSize(new Dimension(50, 50));
            atBox.add(this.atomNumBox[i]).setVisible(false);
            final int num = i;
            this.atomNumBox[i].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    if (num == NBODialogModel.this.editMode - 1) {
                        NBODialogModel.this.jbEdit.setEnabled(true);
                    }
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    int atnum = 0;
                    try {
                        atnum = Integer.parseInt(NBODialogModel.this.atomNumBox[num].getText());
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (atnum > NBODialogModel.this.vwr.ms.ac) {
                        NBODialogModel.this.atomNumBox[num].setText("");
                    }
                    String[] tmp = new String[NBODialogModel.this.editMode];
                    NBODialogModel.this.selected = "";
                    for (int j = 0; j < NBODialogModel.this.editMode; ++j) {
                        tmp[j] = NBODialogModel.this.atomNumBox[j].getText();
                        NBODialogModel.this.selected = NBODialogModel.this.selected + (tmp[j].length() > 0 ? tmp[j] + " " : "");
                    }
                    NBODialogModel.this.getValue();
                    NBODialogModel.this.showSelected(NBODialogModel.this.selected.split(" "));
                    NBODialogModel.this.editValueTf.setText("");
                    NBODialogModel.this.editValueTf.setEnabled(true);
                }
            });
            this.atomNumBox[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialogModel.this.selected = "";
                    for (int j = 0; j < NBODialogModel.this.atomNumBox.length; ++j) {
                        String tmp = NBODialogModel.this.atomNumBox[j].getText();
                        NBODialogModel.this.selected = NBODialogModel.this.selected + (tmp.length() > 0 ? tmp + " " : "");
                    }
                    NBODialogModel.this.editModel(NBODialogModel.this.editAction);
                }
            });
        }
        this.editBox.add(atBox);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Symmetry Type: "));
        this.jcSymOps = new JComboBox();
        this.jcSymOps.addItem("<Select Transition Metal>");
        this.jcSymOps.setMaximumSize(new Dimension(180, 40));
        this.jcSymOps.setEnabled(false);
        box.add(this.jcSymOps);
        box.setVisible(false);
        this.editBox.add(box);
        this.currVal = new JTextField();
        this.currVal.setMaximumSize(new Dimension(200, 40));
        this.currVal.setEditable(false);
        this.editBox.add(this.currVal).setVisible(false);
        this.valLab = new JLabel();
        this.valLab.setAlignmentX(0.5f);
        this.editBox.add(this.valLab).setVisible(false);
        this.editValueTf = new JTextField("Select atoms...");
        this.editValueTf.setVisible(false);
        this.editValueTf.setMaximumSize(new Dimension(200, 30));
        this.editValueTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.editModel(NBODialogModel.this.editAction);
            }
        });
        this.editValueTf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                if (!NBODialogModel.this.editValueTf.getText().equals("") && !NBODialogModel.this.editValueTf.getText().contains("Select")) {
                    NBODialogModel.this.jbEdit.setEnabled(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (NBODialogModel.this.editValueTf.getText().equals("")) {
                    NBODialogModel.this.jbEdit.setEnabled(false);
                }
            }
        });
        this.editBox.add(this.editValueTf).setVisible(false);
        this.jbClear = new JButton("Clear Selected");
        this.jbClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.clearSelected();
            }
        });
        this.jbEdit = new JButton("Apply");
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.editModel(NBODialogModel.this.editAction);
            }
        });
        Box lowBox = Box.createHorizontalBox();
        lowBox.add(this.jbClear).setVisible(false);
        lowBox.add(this.jbEdit).setVisible(false);
        this.editBox.add(lowBox);
    }

    private Box saveBox() {
        Box sBox = this.borderBox(true);
        String[] SAVE_OPTIONS = new String[]{"<Select File Type>", "JMol Cartesian             [.cfi]", "JMol Valence               [.vfi]", "Gaussian Input             [.gau]", "Gaussian Input (Cartesian) [.gau]", "Gaussian Input (z-Matrix)  [.gau]", "GAMESS Input               [.gms]", "ADF Input                  [.adf]", "Jaguar Input               [.jag]", "MM2-Input                  [.mm2]", "Dewar Type Input           [.mnd]", "Molpro Input               [.mp]", "NWChem Input               [.nw]", "Orca Input                 [.orc]", "PQS Input                  [.pqs]", "Q-Chem Input               [.qc]"};
        this.jComboSave = new JComboBox<String>(SAVE_OPTIONS);
        this.jComboSave.setFont(nboFont);
        final FileHndlr saveBox = new FileHndlr("", "", 5, OUTPUT_FILE_EXTENSIONS, (NBODialog)this){

            @Override
            protected boolean browsePressed() {
                String folder = this.tfDir.getText().trim();
                String name = this.tfName.getText().trim();
                String ext = this.tfExt.getText().trim();
                if (!(ext.equals("") || folder.equals("") || name.equals(""))) {
                    File f = new File(folder + "/" + name + "." + ext);
                    if (!PT.isOneOf(ext, NBODialogModel.OUTPUT_FILE_EXTENSIONS)) {
                        NBODialogModel.this.vwr.alert("Invalid output extenstion");
                        return false;
                    }
                    if (f.exists()) {
                        int i = JOptionPane.showConfirmDialog(null, "File " + f + " already exists, do you want to overwrite contents?", "Warning", 0);
                        if (i == 1) {
                            return false;
                        }
                        this.dialog.fileHndlr.setInput(folder, name, ext);
                    }
                    NBODialogModel.this.saveModel(folder, name, ext);
                    this.saveWorkHistory();
                    return true;
                }
                JFileChooser myChooser = new JFileChooser();
                this.useExt = ext.equals("") ? NBODialogModel.OUTPUT_FILE_EXTENSIONS : ext;
                myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt.split(",")));
                myChooser.setFileHidingEnabled(true);
                String savePath = this.fileDir;
                if (!folder.equals("")) {
                    if (!folder.contains(":")) {
                        folder = "C:/" + folder;
                    }
                } else {
                    folder = new File(this.fileDir).getParent();
                }
                savePath = name.equals("") && this.jobStem != null ? this.tfDir.getText() + "/" + (this.jobStem.equals("") ? "new.cfi" : this.jobStem + (ext.contains(";") ? "" : "." + ext)) : this.tfDir.getText() + "/" + name + "." + ext;
                myChooser.setSelectedFile(new File(savePath));
                int button = myChooser.showSaveDialog(this);
                if (button == 0) {
                    File newFile = myChooser.getSelectedFile();
                    ext = FileHndlr.getExt(newFile);
                    if (PT.isOneOf(FileHndlr.getExt(newFile), NBODialogModel.OUTPUT_FILE_EXTENSIONS)) {
                        int i;
                        if (newFile.exists() && (i = JOptionPane.showConfirmDialog(null, "File " + newFile + " already exists, do you want to overwrite contents?", "Warning", 0)) == 1) {
                            return false;
                        }
                        this.dialog.fileHndlr.setInput(folder, name, ext);
                        this.fileDir = newFile.getParent();
                        NBODialogModel.this.saveModel(newFile.getParent(), FileHndlr.getJobStem(newFile), ext);
                        this.saveWorkHistory();
                    } else {
                        NBODialogModel.this.appendOutputWithCaret("Invalid extension defined", 'b');
                    }
                }
                return false;
            }
        };
        this.jComboSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = NBODialogModel.this.jComboSave.getSelectedItem();
                if (NBODialogModel.this.jComboSave.getSelectedIndex() != 0) {
                    String s = item.toString();
                    String ext = s.substring(s.indexOf("[") + 2, s.indexOf("]"));
                    saveBox.tfExt.setText(ext);
                }
            }
        });
        sBox.add(this.jComboSave);
        sBox.add(saveBox);
        return sBox;
    }

    protected void showSelected(String[] s) {
        this.runScriptNow("select remove {*}");
        for (String x : s) {
            this.runScriptNow("select add {*}[" + x + "]");
        }
        this.runScriptQueued("select on");
    }

    private void createInput(final JTextField field, JRadioButton radio) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.getModel(field);
            }
        });
        this.addListenersAndSize(field, radio);
    }

    private void addListenersAndSize(final JComponent field, final JRadioButton radio) {
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                radio.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        radio.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                field.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    protected void actionSelected(char action) {
        this.clearSelected();
        switch (action) {
            case 'c': 
            case 'f': 
            case 'l': 
            case 's': {
                this.editMode = 2;
                this.setEditBox();
                break;
            }
            case '3': {
                this.editMode = 2;
                this.setEditBox();
                break;
            }
            case 'm': {
                this.editMode = 1;
                this.setEditBox();
                break;
            }
            case 'a': 
            case 't': 
            case 'v': {
                this.editMode = 4;
                this.setEditBox();
                break;
            }
            case 'r': {
                this.editMode = 1;
                this.setEditBox();
            }
        }
    }

    protected void setEditBox() {
        this.jbEdit.setEnabled(false);
        for (int i = 0; i < 4; ++i) {
            this.atomNumBox[i].setVisible(i < this.editMode);
        }
        this.editValueTf.setText("Select atoms...");
        this.editValueTf.setEnabled(false);
        this.jcSymOps.getParent().setVisible(this.editAction.charAt(0) == 'r');
        switch (this.editAction.charAt(0)) {
            case '3': 
            case 'a': 
            case 'm': 
            case 't': {
                this.editValueTf.setVisible(true);
                break;
            }
            default: {
                this.editValueTf.setVisible(false);
            }
        }
        this.currVal.setVisible(this.editMode == 4);
        this.valLab.setVisible(this.editMode == 4);
        this.jbEdit.setVisible(!this.editAction.equals("value"));
        this.jbClear.setVisible(!this.editAction.equals("value"));
        this.editBox.repaint();
        this.editBox.revalidate();
    }

    protected void clearSelected() {
        for (int i = 0; i < this.editMode; ++i) {
            this.atomNumBox[i].setText("");
        }
        if (this.currVal != null) {
            this.currVal.setText("");
        }
        if (this.valLab != null) {
            this.valLab.setText(" ");
        }
        this.runScriptQueued("measure off;select remove {selected};refresh");
        this.selected = "";
        if (this.editValueTf != null) {
            this.editValueTf.setText("Select atoms...");
            this.editValueTf.setEnabled(false);
            this.jbEdit.setEnabled(false);
        }
    }

    protected void editModel(String item) {
        SB sb = new SB();
        String cmd = item + " " + this.selected;
        String val = this.editValueTf.getText();
        if (this.editValueTf != null) {
            if (this.editMode == 4 || this.editMode == 1) {
                cmd = cmd + val;
            } else if (item.equals("3chb")) {
                if (!val.startsWith(":")) {
                    cmd = cmd + ":";
                }
                cmd = cmd + val;
            }
        }
        if (this.editAction.charAt(0) == 'r') {
            cmd = cmd + this.jcSymOps.getSelectedItem().toString();
        }
        sb.append("CMD " + cmd);
        this.appendOutputWithCaret(cmd, 'i');
        this.jbEdit.setEnabled(false);
        this.nboService.rawCmdNew("m", sb, 1, null, "Getting model...");
    }

    protected void getSymmetry() {
        SB sb = new SB();
        sb.append("CMD symmetry");
        this.appendOutputWithCaret("Symmetry: ", 'p');
        this.nboService.rawCmdNew("m", sb, 1, null, "Getting model...");
    }

    protected void getModel(JTextField textBox) {
        String model = textBox.getText();
        if (textBox.getText().equals("")) {
            return;
        }
        String s = "";
        this.fileHndlr.tfName.setText("");
        this.fileHndlr.tfExt.setText("");
        if (textBox.equals(this.jtJmolInput)) {
            this.loadModel = true;
            this.jtLineInput.setText("");
            s = "load $" + model;
            if (this.runScriptNow(s) == null) {
                if (this.runScriptNow("load :" + model) != null) {
                    return;
                }
                this.appendOutputWithCaret("File not found", 'i');
                this.loadModel = false;
                return;
            }
        } else if (textBox.equals(this.jtLineInput)) {
            SB sb = new SB();
            this.jtJmolInput.setText("");
            s = "show " + model;
            sb.append("CMD " + s);
            this.nboService.rawCmdNew("m", sb, 1, null, "Getting model...");
        }
        textBox.setText(model);
        this.appendOutputWithCaret(s, 'i');
    }

    protected void loadModelToNBO(String s) {
        String fName = this.nboService.serverDir + "/jmol_outfile.cfi";
        SB sb = new SB();
        this.vwr.writeTextFile(fName, s);
        sb.append("GLOBAL C_PATH " + this.nboService.serverDir + sep);
        sb.append("GLOBAL C_ESS c" + sep);
        sb.append("GLOBAL C_FNAME jmol_outfile" + sep);
        sb.append("GLOBAL C_IN_EXT cfi" + sep);
        sb.append("CMD use");
        this.nboService.rawCmdNew("m", sb, 1, null, "Getting model...");
    }

    protected void loadModelFromNBO(String path, String fname, String ext) {
        String ess = this.getEss(ext, true);
        SB sb = new SB();
        if (this.jtJmolInput != null) {
            this.jtJmolInput.setText("");
            this.jtLineInput.setText("");
        }
        sb.append("GLOBAL C_PATH " + path + sep);
        sb.append("GLOBAL C_ESS " + ess + sep);
        sb.append("GLOBAL C_FNAME " + fname + sep);
        sb.append("GLOBAL C_IN_EXT " + ext.toLowerCase() + sep);
        sb.append("CMD use");
        this.appendOutputWithCaret("use." + ess + " " + fname + "." + ext, 'i');
        this.nboService.rawCmdNew("m", sb, 1, null, "Getting model...");
    }

    protected void saveModel(String path, String fname, String ext) {
        String ess = this.getEss(ext, false);
        SB sb = new SB();
        sb.append("GLOBAL C_PATH " + path + sep);
        sb.append("GLOBAL C_ESS " + ess + sep);
        sb.append("GLOBAL C_FNAME " + fname + sep);
        sb.append("GLOBAL C_OUT_EXT " + ext + sep);
        sb.append("CMD save");
        this.nboService.rawCmdNew("m", sb, 1, null, "Saving model...");
        this.appendOutputWithCaret("save." + ess + " " + fname, 'i');
        this.appendOutputWithCaret("--Model Saved--<br>" + path + "\\" + fname + "." + ext, 'b');
    }

    private String getEss(String ext, boolean use) {
        if (((ext = ext.toLowerCase()).equals("gau") || ext.equals("g09") || ext.equals("com")) && !use) {
            if (this.jComboSave.getSelectedItem().toString().contains("(C")) {
                return ext.charAt(0) + "c";
            }
            if (this.jComboSave.getSelectedItem().toString().contains("(z")) {
                return ext.charAt(0) + "z";
            }
            return "g";
        }
        if (ext.equals("cfi") || ext.equals("vfi") || ext.equals("gau") || ext.equals("log") || ext.equals("g09")) {
            return "" + ext.charAt(0);
        }
        if (ext.equals("47")) {
            return "a";
        }
        if (ext.equals("mm2")) {
            return "mm";
        }
        if (ext.equals("com")) {
            return "g";
        }
        return ext;
    }

    protected void notifyPick_m(String atomno) {
        String st;
        if (this.editMode == 0) {
            return;
        }
        String[] tok = atomno.split(",");
        if (tok.length > 1) {
            if (this.editMode == 2) {
                this.clearSelected();
            }
            String[] tok2 = tok[1].split(" ");
            String at1 = tok2[2].replaceAll("[\\D]", "");
            if (!this.selected.contains(" " + at1 + " ")) {
                this.notifyPick_m(at1);
            }
            String at2 = tok2[5].replaceAll("[\\D]", "");
            if (!this.selected.contains(" " + at2 + " ")) {
                this.notifyPick_m(at2);
            }
            return;
        }
        this.editValueTf.requestFocus();
        this.editValueTf.setText("");
        if (this.editMode < 3) {
            this.editValueTf.setEnabled(true);
        }
        if ((st = this.runScriptNow("print {*}[" + atomno + "].selected")).contains("1.0")) {
            this.selected = this.selected.replace(atomno + " ", "");
            this.runScriptQueued("select remove {*}[" + atomno + "];measure off;");
            if (this.selected.split(" ").length > 1) {
                this.runScriptQueued("measure " + this.selected);
            }
            for (int i = 0; i < this.atomNumBox.length; ++i) {
                if (i >= this.selected.split(" ").length) {
                    this.atomNumBox[i].setText("");
                    continue;
                }
                this.atomNumBox[i].setText(this.selected.split(" ")[i]);
            }
            return;
        }
        int cnt = this.selected.equals("") ? 1 : this.selected.split(" ").length + 1;
        switch (this.editMode) {
            case 4: {
                String script = "";
                if (cnt == 1) {
                    this.editValueTf.setText("");
                    script = "print {*}[" + atomno + "].elemno";
                    this.editValueTf.setEnabled(true);
                    this.valLab.setText("(Atomic number)");
                    this.currVal.setText("Current Value: " + this.runScriptNow(script));
                    break;
                }
                if (cnt == 5) {
                    this.clearSelected();
                    this.valLab.setText("(Atomic number)");
                    script = "print {*}[" + atomno + "].elemno";
                    this.currVal.setText("Current Value: " + this.runScriptNow(script));
                    cnt = 1;
                    break;
                }
                if (cnt == 2) {
                    this.valLab.setText("(Bond length)");
                    this.runScriptQueued("measure off;measure " + this.selected + " " + atomno + "\"2:%0.4VALUE //A\"" + ";measure " + this.selected + " " + atomno + "\"2:%0.4VALUE //A\"");
                } else {
                    if (cnt == 3) {
                        this.valLab.setText("(Valence angle)");
                    } else {
                        this.valLab.setText("(Dihedral angle)");
                    }
                    this.runScriptQueued("measure off;measure " + this.selected + " " + atomno);
                }
                script = "print measure({*}[";
                for (String x : this.selected.split(" ")) {
                    script = script + x + "],{*}[";
                }
                script = script + atomno + "])";
                String s = this.runScriptNow(script).split("\\s+")[1];
                double val = Double.parseDouble(s);
                val = NBOService.round(val, 2);
                this.currVal.setText("Current Value: " + val);
                break;
            }
            case 2: {
                if (cnt == 2) {
                    this.jbEdit.setEnabled(true);
                    if (this.editValueTf.isVisible()) {
                        this.editValueTf.requestFocus();
                        break;
                    }
                    this.atomNumBox[1].requestFocus();
                    break;
                }
                if (cnt != 3) break;
                this.clearSelected();
                cnt = 1;
                break;
            }
            case 1: {
                if (cnt == 2) {
                    this.clearSelected();
                    cnt = 1;
                }
                if (cnt != 1) break;
                if (this.editAction.charAt(0) == 'r') {
                    this.jcSymOps.removeAllItems();
                    this.jcSymOps.setEnabled(true);
                    int atomInd = Integer.parseInt(atomno) - 1;
                    int val = this.vwr.ms.at[atomInd].getValence();
                    this.jbEdit.setEnabled(true);
                    switch (val) {
                        case 4: {
                            for (String x : new String[]{"td", "c3vi", "c4v"}) {
                                this.jcSymOps.addItem(x);
                            }
                            break;
                        }
                        case 5: {
                            for (String x : new String[]{"c4vo", "c4vi"}) {
                                this.jcSymOps.addItem(x);
                            }
                            break;
                        }
                        case 6: {
                            for (String x : new String[]{"c3vo", "c3vi", "c5vo", "c5vi"}) {
                                this.jcSymOps.addItem(x);
                            }
                            break;
                        }
                        default: {
                            this.jcSymOps.addItem("<Select Transition Metal>");
                            this.jcSymOps.setEnabled(false);
                            this.jbEdit.setEnabled(false);
                        }
                    }
                }
                this.editValueTf.setEnabled(true);
                this.editValueTf.setText("");
                this.editValueTf.requestFocus();
            }
        }
        this.selected = this.selected + atomno + " ";
        this.runScriptQueued("select add {*}[" + atomno + "]");
        this.atomNumBox[cnt - 1].setText("  " + atomno);
    }

    protected void getValue() {
        String script = "";
        String[] ats = this.selected.split(" ");
        int cnt = ats.length;
        if (cnt == 1) {
            this.valLab.setText("(Atomic number)");
            this.editValueTf.setText("");
            this.editValueTf.setEnabled(true);
            script = "print {*}[" + this.selected + "].elemno";
            if (this.currVal != null) {
                this.currVal.setText("Current Value: " + this.runScriptNow(script));
            }
        } else {
            if (cnt == 2) {
                this.valLab.setText("(Bond length)");
                this.runScriptQueued("measure off;measure " + this.selected + "\"2:%0.4VALUE //A\"" + ";measure " + this.selected + "\"2:%0.4VALUE //A\"");
            } else {
                this.runScriptQueued("measure off;measure " + this.selected + " ");
                if (cnt == 3) {
                    this.valLab.setText("(Valence angle)");
                } else if (cnt == 4) {
                    this.valLab.setText("(Dihedral angle)");
                }
            }
            script = "print measure({*}[";
            for (int i = 0; i < ats.length - 1; ++i) {
                script = script + ats[i] + "],{*}[";
            }
            String s = this.runScriptNow(script = script + ats[ats.length - 1] + "]);");
            if (s != null && s.split("\\s+").length > 1) {
                this.currVal.setText("Current Value: " + s.split("\\s+")[1]);
            }
        }
    }

    protected void notifyLoad_m() {
        if (this.loadModel) {
            this.loadModel = false;
            this.runScriptNow("select within(model,visible)");
            this.loadModelToNBO(this.runScriptNow("print data({selected},'cfi')"));
            return;
        }
        this.clearSelected();
        this.showAtomNums(false);
        for (Component c : this.panel.getComponents()) {
            c.setVisible(true);
        }
        this.editBox.setVisible(true);
        this.runScriptNow("select within(model,visible)");
        String fileContents = this.evaluateJmolString("data({selected},'cfi')");
        if (this.vwr.ms.ac > 0 && fileContents != null) {
            this.undoStack.push(fileContents);
            if (this.undoStack.size() > 5) {
                this.undoStack.removeElementAt(0);
            }
        }
        if (this.undoStack.size() > 1) {
            this.undo.setEnabled(true);
        } else {
            this.undo.setEnabled(false);
        }
        if (!this.redoStack.isEmpty()) {
            this.redo.setEnabled(true);
        } else {
            this.redo.setEnabled(false);
        }
        this.runScriptQueued("select remove{*}; select on");
    }

    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(null, st, "Warning", 0);
        if (i == 0) {
            this.saveModel(newFile.getParent(), FileHndlr.getJobStem(newFile), ext);
        }
    }
}

