/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class SelfIntersectingWay
extends Test {
    protected static final int SELF_INTERSECT = 401;

    public SelfIntersectingWay() {
        super(I18n.tr("Self-intersecting ways", new Object[0]), I18n.tr("This test checks for ways that contain some of their nodes more than once.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 1; i < way.getNodesCount() - 1; ++i) {
            Node node = way.getNode(i);
            if (hashSet.contains(node)) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 401).message(I18n.tr("Self-intersecting ways", new Object[0])).primitives(way).highlight(node).build());
                break;
            }
            hashSet.add(node);
        }
    }
}

