# Auto-generated by Stone, do not modify.

from abc import ABCMeta, abstractmethod
import warnings

from . import (
    async,
    auth,
    files,
    properties,
    sharing,
    team,
    team_common,
    team_policies,
    users,
)


class DropboxBase(object):
    __metaclass__ = ABCMeta

    @abstractmethod
    def request(self, route, namespace, arg, arg_binary=None):
        pass

    # ------------------------------------------
    # Routes in auth namespace

    def auth_token_revoke(self):
        """
        Disables the access token used to authenticate the call.

        :rtype: None
        """
        arg = None
        r = self.request(
            auth.token_revoke,
            'auth',
            arg,
            None,
        )
        return None

    # ------------------------------------------
    # Routes in files namespace

    def files_alpha_get_metadata(self,
                                 path,
                                 include_media_info=False,
                                 include_deleted=False,
                                 include_has_explicit_shared_members=False,
                                 include_property_templates=None):
        """
        Returns the metadata for a file or folder. This is an alpha endpoint
        compatible with the properties API. Note: Metadata for the root folder
        is unsupported.

        :param Nullable include_property_templates: If set to a valid list of
            template IDs, ``FileMetadata.property_groups`` is set for files with
            custom properties.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.AlphaGetMetadataError`
        """
        arg = files.AlphaGetMetadataArg(path,
                                        include_media_info,
                                        include_deleted,
                                        include_has_explicit_shared_members,
                                        include_property_templates)
        r = self.request(
            files.alpha_get_metadata,
            'files',
            arg,
            None,
        )
        return r

    def files_alpha_upload(self,
                           f,
                           path,
                           mode=files.WriteMode.add,
                           autorename=False,
                           client_modified=None,
                           mute=False,
                           property_groups=None):
        """
        Create a new file with the contents provided in the request. Note that
        this endpoint is part of the properties API alpha and is slightly
        different from :meth:`files_upload`. Do not use this to upload a file
        larger than 150 MB. Instead, create an upload session with
        :meth:`files_upload_session_start`.

        :param bytes f: Contents to upload.
        :param Nullable property_groups: List of custom properties to add to
            file.
        :rtype: :class:`dropbox.files.FileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadErrorWithProperties`
        """
        arg = files.CommitInfoWithProperties(path,
                                             mode,
                                             autorename,
                                             client_modified,
                                             mute,
                                             property_groups)
        r = self.request(
            files.alpha_upload,
            'files',
            arg,
            f,
        )
        return r

    def files_copy(self,
                   from_path,
                   to_path,
                   allow_shared_folder=False,
                   autorename=False):
        """
        Copy a file or folder to a different location in the user's Dropbox. If
        the source path is a folder all its contents will be copied.

        :param bool allow_shared_folder: If true, :meth:`files_copy` will copy
            contents in shared folder, otherwise
            ``RelocationError.cant_copy_shared_folder`` will be returned if
            ``from_path`` contains shared folder. This field is always true for
            :meth:`files_move`.
        :param bool autorename: If there's a conflict, have the Dropbox server
            try to autorename the file to avoid the conflict.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.RelocationError`
        """
        arg = files.RelocationArg(from_path,
                                  to_path,
                                  allow_shared_folder,
                                  autorename)
        r = self.request(
            files.copy,
            'files',
            arg,
            None,
        )
        return r

    def files_copy_batch(self,
                         entries,
                         allow_shared_folder=False,
                         autorename=False):
        """
        Copy multiple files or folders to different locations at once in the
        user's Dropbox. If ``RelocationBatchArg.allow_shared_folder`` is false,
        this route is atomic. If on entry failes, the whole transaction will
        abort. If ``RelocationBatchArg.allow_shared_folder`` is true, not
        atomicity is guaranteed, but you will be able to copy the contents of
        shared folders to new locations. This route will return job ID
        immediately and do the async copy job in background. Please use
        :meth:`files_copy_batch_check` to check the job status.

        :param list entries: List of entries to be moved or copied. Each entry
            is :class:`dropbox.files.RelocationPath`.
        :param bool allow_shared_folder: If true, :meth:`files_copy_batch` will
            copy contents in shared folder, otherwise
            ``RelocationError.cant_copy_shared_folder`` will be returned if
            ``RelocationPath.from_path`` contains shared folder.  This field is
            always true for :meth:`files_move_batch`.
        :param bool autorename: If there's a conflict with any file, have the
            Dropbox server try to autorename that file to avoid the conflict.
        :rtype: :class:`dropbox.files.LaunchEmptyResult`
        """
        arg = files.RelocationBatchArg(entries,
                                       allow_shared_folder,
                                       autorename)
        r = self.request(
            files.copy_batch,
            'files',
            arg,
            None,
        )
        return r

    def files_copy_batch_check(self,
                               async_job_id):
        """
        Returns the status of an asynchronous job for :meth:`files_copy_batch`.
        If success, it returns list of results for each entry.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.files.RelocationBatchJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            files.copy_batch_check,
            'files',
            arg,
            None,
        )
        return r

    def files_copy_reference_get(self,
                                 path):
        """
        Get a copy reference to a file or folder. This reference string can be
        used to save that file or folder to another user's Dropbox by passing it
        to :meth:`files_copy_reference_save`.

        :param str path: The path to the file or folder you want to get a copy
            reference to.
        :rtype: :class:`dropbox.files.GetCopyReferenceResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.GetCopyReferenceError`
        """
        arg = files.GetCopyReferenceArg(path)
        r = self.request(
            files.copy_reference_get,
            'files',
            arg,
            None,
        )
        return r

    def files_copy_reference_save(self,
                                  copy_reference,
                                  path):
        """
        Save a copy reference returned by :meth:`files_copy_reference_get` to
        the user's Dropbox.

        :param str copy_reference: A copy reference returned by
            :meth:`files_copy_reference_get`.
        :param str path: Path in the user's Dropbox that is the destination.
        :rtype: :class:`dropbox.files.SaveCopyReferenceResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.SaveCopyReferenceError`
        """
        arg = files.SaveCopyReferenceArg(copy_reference,
                                         path)
        r = self.request(
            files.copy_reference_save,
            'files',
            arg,
            None,
        )
        return r

    def files_create_folder(self,
                            path,
                            autorename=False):
        """
        Create a folder at a given path.

        :param str path: Path in the user's Dropbox to create.
        :param bool autorename: If there's a conflict, have the Dropbox server
            try to autorename the folder to avoid the conflict.
        :rtype: :class:`dropbox.files.FolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.CreateFolderError`
        """
        arg = files.CreateFolderArg(path,
                                    autorename)
        r = self.request(
            files.create_folder,
            'files',
            arg,
            None,
        )
        return r

    def files_delete(self,
                     path):
        """
        Delete the file or folder at a given path. If the path is a folder, all
        its contents will be deleted too. A successful response indicates that
        the file or folder was deleted. The returned metadata will be the
        corresponding :class:`dropbox.files.FileMetadata` or
        :class:`dropbox.files.FolderMetadata` for the item at time of deletion,
        and not a :class:`dropbox.files.DeletedMetadata` object.

        :param str path: Path in the user's Dropbox to delete.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DeleteError`
        """
        arg = files.DeleteArg(path)
        r = self.request(
            files.delete,
            'files',
            arg,
            None,
        )
        return r

    def files_delete_batch(self,
                           entries):
        """
        Delete multiple files/folders at once. This route is asynchronous, which
        returns a job ID immediately and runs the delete batch asynchronously.
        Use :meth:`files_delete_batch_check` to check the job status.

        :type entries: list
        :rtype: :class:`dropbox.files.LaunchEmptyResult`
        """
        arg = files.DeleteBatchArg(entries)
        r = self.request(
            files.delete_batch,
            'files',
            arg,
            None,
        )
        return r

    def files_delete_batch_check(self,
                                 async_job_id):
        """
        Returns the status of an asynchronous job for
        :meth:`files_delete_batch`. If success, it returns list of result for
        each entry.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.files.DeleteBatchJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            files.delete_batch_check,
            'files',
            arg,
            None,
        )
        return r

    def files_download(self,
                       path,
                       rev=None):
        """
        Download a file from a user's Dropbox.

        :param str path: The path of the file to download.
        :param Nullable rev: Deprecated. Please specify revision in ``path``
            instead.
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DownloadError`

        If you do not consume the entire response body, then you must call close
        on the response object, otherwise you will max out your available
        connections. We recommend using the `contextlib.closing
        <https://docs.python.org/2/library/contextlib.html#contextlib.closing>`_
        context manager to ensure this.
        """
        arg = files.DownloadArg(path,
                                rev)
        r = self.request(
            files.download,
            'files',
            arg,
            None,
        )
        return r

    def files_download_to_file(self,
                               download_path,
                               path,
                               rev=None):
        """
        Download a file from a user's Dropbox.

        :param str download_path: Path on local machine to save file.
        :param str path: The path of the file to download.
        :param Nullable rev: Deprecated. Please specify revision in ``path``
            instead.
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DownloadError`
        """
        arg = files.DownloadArg(path,
                                rev)
        r = self.request(
            files.download,
            'files',
            arg,
            None,
        )
        self._save_body_to_file(download_path, r[1])
        return r[0]

    def files_get_metadata(self,
                           path,
                           include_media_info=False,
                           include_deleted=False,
                           include_has_explicit_shared_members=False):
        """
        Returns the metadata for a file or folder. Note: Metadata for the root
        folder is unsupported.

        :param str path: The path of a file or folder on Dropbox.
        :param bool include_media_info: If true, ``FileMetadata.media_info`` is
            set for photo and video.
        :param bool include_deleted: If true,
            :class:`dropbox.files.DeletedMetadata` will be returned for deleted
            file or folder, otherwise ``LookupError.not_found`` will be
            returned.
        :param bool include_has_explicit_shared_members: If true, the results
            will include a flag for each file indicating whether or not  that
            file has any explicit members.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.GetMetadataError`
        """
        arg = files.GetMetadataArg(path,
                                   include_media_info,
                                   include_deleted,
                                   include_has_explicit_shared_members)
        r = self.request(
            files.get_metadata,
            'files',
            arg,
            None,
        )
        return r

    def files_get_preview(self,
                          path,
                          rev=None):
        """
        Get a preview for a file. Currently previews are only generated for the
        files with  the following extensions: .doc, .docx, .docm, .ppt, .pps,
        .ppsx, .ppsm, .pptx, .pptm,  .xls, .xlsx, .xlsm, .rtf.

        :param str path: The path of the file to preview.
        :param Nullable rev: Deprecated. Please specify revision in ``path``
            instead.
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PreviewError`

        If you do not consume the entire response body, then you must call close
        on the response object, otherwise you will max out your available
        connections. We recommend using the `contextlib.closing
        <https://docs.python.org/2/library/contextlib.html#contextlib.closing>`_
        context manager to ensure this.
        """
        arg = files.PreviewArg(path,
                               rev)
        r = self.request(
            files.get_preview,
            'files',
            arg,
            None,
        )
        return r

    def files_get_preview_to_file(self,
                                  download_path,
                                  path,
                                  rev=None):
        """
        Get a preview for a file. Currently previews are only generated for the
        files with  the following extensions: .doc, .docx, .docm, .ppt, .pps,
        .ppsx, .ppsm, .pptx, .pptm,  .xls, .xlsx, .xlsm, .rtf.

        :param str download_path: Path on local machine to save file.
        :param str path: The path of the file to preview.
        :param Nullable rev: Deprecated. Please specify revision in ``path``
            instead.
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PreviewError`
        """
        arg = files.PreviewArg(path,
                               rev)
        r = self.request(
            files.get_preview,
            'files',
            arg,
            None,
        )
        self._save_body_to_file(download_path, r[1])
        return r[0]

    def files_get_temporary_link(self,
                                 path):
        """
        Get a temporary link to stream content of a file. This link will expire
        in four hours and afterwards you will get 410 Gone. Content-Type of the
        link is determined automatically by the file's mime type.

        :param str path: The path to the file you want a temporary link to.
        :rtype: :class:`dropbox.files.GetTemporaryLinkResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.GetTemporaryLinkError`
        """
        arg = files.GetTemporaryLinkArg(path)
        r = self.request(
            files.get_temporary_link,
            'files',
            arg,
            None,
        )
        return r

    def files_get_thumbnail(self,
                            path,
                            format=files.ThumbnailFormat.jpeg,
                            size=files.ThumbnailSize.w64h64):
        """
        Get a thumbnail for an image. This method currently supports files with
        the following file extensions: jpg, jpeg, png, tiff, tif, gif and bmp.
        Photos that are larger than 20MB in size won't be converted to a
        thumbnail.

        :param str path: The path to the image file you want to thumbnail.
        :param format: The format for the thumbnail image, jpeg (default) or
            png. For  images that are photos, jpeg should be preferred, while
            png is  better for screenshots and digital arts.
        :type format: :class:`dropbox.files.ThumbnailFormat`
        :param size: The size for the thumbnail image.
        :type size: :class:`dropbox.files.ThumbnailSize`
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ThumbnailError`

        If you do not consume the entire response body, then you must call close
        on the response object, otherwise you will max out your available
        connections. We recommend using the `contextlib.closing
        <https://docs.python.org/2/library/contextlib.html#contextlib.closing>`_
        context manager to ensure this.
        """
        arg = files.ThumbnailArg(path,
                                 format,
                                 size)
        r = self.request(
            files.get_thumbnail,
            'files',
            arg,
            None,
        )
        return r

    def files_get_thumbnail_to_file(self,
                                    download_path,
                                    path,
                                    format=files.ThumbnailFormat.jpeg,
                                    size=files.ThumbnailSize.w64h64):
        """
        Get a thumbnail for an image. This method currently supports files with
        the following file extensions: jpg, jpeg, png, tiff, tif, gif and bmp.
        Photos that are larger than 20MB in size won't be converted to a
        thumbnail.

        :param str download_path: Path on local machine to save file.
        :param str path: The path to the image file you want to thumbnail.
        :param format: The format for the thumbnail image, jpeg (default) or
            png. For  images that are photos, jpeg should be preferred, while
            png is  better for screenshots and digital arts.
        :type format: :class:`dropbox.files.ThumbnailFormat`
        :param size: The size for the thumbnail image.
        :type size: :class:`dropbox.files.ThumbnailSize`
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ThumbnailError`
        """
        arg = files.ThumbnailArg(path,
                                 format,
                                 size)
        r = self.request(
            files.get_thumbnail,
            'files',
            arg,
            None,
        )
        self._save_body_to_file(download_path, r[1])
        return r[0]

    def files_list_folder(self,
                          path,
                          recursive=False,
                          include_media_info=False,
                          include_deleted=False,
                          include_has_explicit_shared_members=False):
        """
        Starts returning the contents of a folder. If the result's
        ``ListFolderResult.has_more`` field is ``True``, call
        :meth:`files_list_folder_continue` with the returned
        ``ListFolderResult.cursor`` to retrieve more entries. If you're using
        ``ListFolderArg.recursive`` set to ``True`` to keep a local cache of the
        contents of a Dropbox account, iterate through each entry in order and
        process them as follows to keep your local state in sync: For each
        :class:`dropbox.files.FileMetadata`, store the new entry at the given
        path in your local state. If the required parent folders don't exist
        yet, create them. If there's already something else at the given path,
        replace it and remove all its children. For each
        :class:`dropbox.files.FolderMetadata`, store the new entry at the given
        path in your local state. If the required parent folders don't exist
        yet, create them. If there's already something else at the given path,
        replace it but leave the children as they are. Check the new entry's
        ``FolderSharingInfo.read_only`` and set all its children's read-only
        statuses to match. For each :class:`dropbox.files.DeletedMetadata`, if
        your local state has something at the given path, remove it and all its
        children. If there's nothing at the given path, ignore this entry.

        :param str path: The path to the folder you want to see the contents of.
        :param bool recursive: If true, the list folder operation will be
            applied recursively to all subfolders and the response will contain
            contents of all subfolders.
        :param bool include_media_info: If true, ``FileMetadata.media_info`` is
            set for photo and video.
        :param bool include_deleted: If true, the results will include entries
            for files and folders that used to exist but were deleted.
        :param bool include_has_explicit_shared_members: If true, the results
            will include a flag for each file indicating whether or not  that
            file has any explicit members.
        :rtype: :class:`dropbox.files.ListFolderResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderError`
        """
        arg = files.ListFolderArg(path,
                                  recursive,
                                  include_media_info,
                                  include_deleted,
                                  include_has_explicit_shared_members)
        r = self.request(
            files.list_folder,
            'files',
            arg,
            None,
        )
        return r

    def files_list_folder_continue(self,
                                   cursor):
        """
        Once a cursor has been retrieved from :meth:`files_list_folder`, use
        this to paginate through all files and retrieve updates to the folder,
        following the same rules as documented for :meth:`files_list_folder`.

        :param str cursor: The cursor returned by your last call to
            :meth:`files_list_folder` or :meth:`files_list_folder_continue`.
        :rtype: :class:`dropbox.files.ListFolderResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderContinueError`
        """
        arg = files.ListFolderContinueArg(cursor)
        r = self.request(
            files.list_folder_continue,
            'files',
            arg,
            None,
        )
        return r

    def files_list_folder_get_latest_cursor(self,
                                            path,
                                            recursive=False,
                                            include_media_info=False,
                                            include_deleted=False,
                                            include_has_explicit_shared_members=False):
        """
        A way to quickly get a cursor for the folder's state. Unlike
        :meth:`files_list_folder`, :meth:`files_list_folder_get_latest_cursor`
        doesn't return any entries. This endpoint is for app which only needs to
        know about new files and modifications and doesn't need to know about
        files that already exist in Dropbox.

        :param str path: The path to the folder you want to see the contents of.
        :param bool recursive: If true, the list folder operation will be
            applied recursively to all subfolders and the response will contain
            contents of all subfolders.
        :param bool include_media_info: If true, ``FileMetadata.media_info`` is
            set for photo and video.
        :param bool include_deleted: If true, the results will include entries
            for files and folders that used to exist but were deleted.
        :param bool include_has_explicit_shared_members: If true, the results
            will include a flag for each file indicating whether or not  that
            file has any explicit members.
        :rtype: :class:`dropbox.files.ListFolderGetLatestCursorResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderError`
        """
        arg = files.ListFolderArg(path,
                                  recursive,
                                  include_media_info,
                                  include_deleted,
                                  include_has_explicit_shared_members)
        r = self.request(
            files.list_folder_get_latest_cursor,
            'files',
            arg,
            None,
        )
        return r

    def files_list_folder_longpoll(self,
                                   cursor,
                                   timeout=30):
        """
        A longpoll endpoint to wait for changes on an account. In conjunction
        with :meth:`files_list_folder_continue`, this call gives you a
        low-latency way to monitor an account for file changes. The connection
        will block until there are changes available or a timeout occurs. This
        endpoint is useful mostly for client-side apps. If you're looking for
        server-side notifications, check out our `webhooks documentation
        <https://www.dropbox.com/developers/reference/webhooks>`_.

        :param str cursor: A cursor as returned by :meth:`files_list_folder` or
            :meth:`files_list_folder_continue`. Cursors retrieved by setting
            ``ListFolderArg.include_media_info`` to ``True`` are not supported.
        :param long timeout: A timeout in seconds. The request will block for at
            most this length of time, plus up to 90 seconds of random jitter
            added to avoid the thundering herd problem. Care should be taken
            when using this parameter, as some network infrastructure does not
            support long timeouts.
        :rtype: :class:`dropbox.files.ListFolderLongpollResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderLongpollError`
        """
        arg = files.ListFolderLongpollArg(cursor,
                                          timeout)
        r = self.request(
            files.list_folder_longpoll,
            'files',
            arg,
            None,
        )
        return r

    def files_list_revisions(self,
                             path,
                             limit=10):
        """
        Return revisions of a file.

        :param str path: The path to the file you want to see the revisions of.
        :param long limit: The maximum number of revision entries returned.
        :rtype: :class:`dropbox.files.ListRevisionsResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListRevisionsError`
        """
        arg = files.ListRevisionsArg(path,
                                     limit)
        r = self.request(
            files.list_revisions,
            'files',
            arg,
            None,
        )
        return r

    def files_move(self,
                   from_path,
                   to_path,
                   allow_shared_folder=False,
                   autorename=False):
        """
        Move a file or folder to a different location in the user's Dropbox. If
        the source path is a folder all its contents will be moved.

        :param bool allow_shared_folder: If true, :meth:`files_copy` will copy
            contents in shared folder, otherwise
            ``RelocationError.cant_copy_shared_folder`` will be returned if
            ``from_path`` contains shared folder. This field is always true for
            :meth:`files_move`.
        :param bool autorename: If there's a conflict, have the Dropbox server
            try to autorename the file to avoid the conflict.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.RelocationError`
        """
        arg = files.RelocationArg(from_path,
                                  to_path,
                                  allow_shared_folder,
                                  autorename)
        r = self.request(
            files.move,
            'files',
            arg,
            None,
        )
        return r

    def files_move_batch(self,
                         entries,
                         allow_shared_folder=False,
                         autorename=False):
        """
        Move multiple files or folders to different locations at once in the
        user's Dropbox. This route is 'all or nothing', which means if one entry
        fails, the whole transaction will abort. This route will return job ID
        immediately and do the async moving job in background. Please use
        :meth:`files_move_batch_check` to check the job status.

        :param list entries: List of entries to be moved or copied. Each entry
            is :class:`dropbox.files.RelocationPath`.
        :param bool allow_shared_folder: If true, :meth:`files_copy_batch` will
            copy contents in shared folder, otherwise
            ``RelocationError.cant_copy_shared_folder`` will be returned if
            ``RelocationPath.from_path`` contains shared folder.  This field is
            always true for :meth:`files_move_batch`.
        :param bool autorename: If there's a conflict with any file, have the
            Dropbox server try to autorename that file to avoid the conflict.
        :rtype: :class:`dropbox.files.LaunchEmptyResult`
        """
        arg = files.RelocationBatchArg(entries,
                                       allow_shared_folder,
                                       autorename)
        r = self.request(
            files.move_batch,
            'files',
            arg,
            None,
        )
        return r

    def files_move_batch_check(self,
                               async_job_id):
        """
        Returns the status of an asynchronous job for :meth:`files_move_batch`.
        If success, it returns list of results for each entry.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.files.RelocationBatchJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            files.move_batch_check,
            'files',
            arg,
            None,
        )
        return r

    def files_permanently_delete(self,
                                 path):
        """
        Permanently delete the file or folder at a given path (see
        https://www.dropbox.com/en/help/40). Note: This endpoint is only
        available for Dropbox Business apps.

        :param str path: Path in the user's Dropbox to delete.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DeleteError`
        """
        arg = files.DeleteArg(path)
        r = self.request(
            files.permanently_delete,
            'files',
            arg,
            None,
        )
        return None

    def files_properties_add(self,
                             path,
                             property_groups):
        """
        Add custom properties to a file using a filled property template. See
        properties/template/add to create new property templates.

        :param str path: A unique identifier for the file.
        :param list property_groups: Filled custom property templates associated
            with a file.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.AddPropertiesError`
        """
        arg = files.PropertyGroupWithPath(path,
                                          property_groups)
        r = self.request(
            files.properties_add,
            'files',
            arg,
            None,
        )
        return None

    def files_properties_overwrite(self,
                                   path,
                                   property_groups):
        """
        Overwrite custom properties from a specified template associated with a
        file.

        :param str path: A unique identifier for the file.
        :param list property_groups: Filled custom property templates associated
            with a file.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.InvalidPropertyGroupError`
        """
        arg = files.PropertyGroupWithPath(path,
                                          property_groups)
        r = self.request(
            files.properties_overwrite,
            'files',
            arg,
            None,
        )
        return None

    def files_properties_remove(self,
                                path,
                                property_template_ids):
        """
        Remove all custom properties from a specified template associated with a
        file. To remove specific property key value pairs, see
        :meth:`files_properties_update`. To update a property template, see
        properties/template/update. Property templates can't be removed once
        created.

        :param str path: A unique identifier for the file.
        :param list property_template_ids: A list of identifiers for a property
            template created by route properties/template/add.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.RemovePropertiesError`
        """
        arg = files.RemovePropertiesArg(path,
                                        property_template_ids)
        r = self.request(
            files.properties_remove,
            'files',
            arg,
            None,
        )
        return None

    def files_properties_template_get(self,
                                      template_id):
        """
        Get the schema for a specified template.

        :param str template_id: An identifier for property template added by
            route properties/template/add.
        :rtype: :class:`dropbox.files.GetPropertyTemplateResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PropertyTemplateError`
        """
        arg = properties.GetPropertyTemplateArg(template_id)
        r = self.request(
            files.properties_template_get,
            'files',
            arg,
            None,
        )
        return r

    def files_properties_template_list(self):
        """
        Get the property template identifiers for a user. To get the schema of
        each template use :meth:`files_properties_template_get`.

        :rtype: :class:`dropbox.files.ListPropertyTemplateIds`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PropertyTemplateError`
        """
        arg = None
        r = self.request(
            files.properties_template_list,
            'files',
            arg,
            None,
        )
        return r

    def files_properties_update(self,
                                path,
                                update_property_groups):
        """
        Add, update or remove custom properties from a specified template
        associated with a file. Fields that already exist and not described in
        the request will not be modified.

        :param str path: A unique identifier for the file.
        :param list update_property_groups: Filled custom property templates
            associated with a file.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UpdatePropertiesError`
        """
        arg = files.UpdatePropertyGroupArg(path,
                                           update_property_groups)
        r = self.request(
            files.properties_update,
            'files',
            arg,
            None,
        )
        return None

    def files_restore(self,
                      path,
                      rev):
        """
        Restore a file to a specific revision.

        :param str path: The path to the file you want to restore.
        :param str rev: The revision to restore for the file.
        :rtype: :class:`dropbox.files.FileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.RestoreError`
        """
        arg = files.RestoreArg(path,
                               rev)
        r = self.request(
            files.restore,
            'files',
            arg,
            None,
        )
        return r

    def files_save_url(self,
                       path,
                       url):
        """
        Save a specified URL into a file in user's Dropbox. If the given path
        already exists, the file will be renamed to avoid the conflict (e.g.
        myfile (1).txt).

        :param str path: The path in Dropbox where the URL will be saved to.
        :param str url: The URL to be saved.
        :rtype: :class:`dropbox.files.SaveUrlResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.SaveUrlError`
        """
        arg = files.SaveUrlArg(path,
                               url)
        r = self.request(
            files.save_url,
            'files',
            arg,
            None,
        )
        return r

    def files_save_url_check_job_status(self,
                                        async_job_id):
        """
        Check the status of a :meth:`files_save_url` job.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.files.SaveUrlJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            files.save_url_check_job_status,
            'files',
            arg,
            None,
        )
        return r

    def files_search(self,
                     path,
                     query,
                     start=0,
                     max_results=100,
                     mode=files.SearchMode.filename):
        """
        Searches for files and folders. Note: Recent changes may not immediately
        be reflected in search results due to a short delay in indexing.

        :param str path: The path in the user's Dropbox to search. Should
            probably be a folder.
        :param str query: The string to search for. The search string is split
            on spaces into multiple tokens. For file name searching, the last
            token is used for prefix matching (i.e. "bat c" matches "bat cave"
            but not "batman car").
        :param long start: The starting index within the search results (used
            for paging).
        :param long max_results: The maximum number of search results to return.
        :param mode: The search mode (filename, filename_and_content, or
            deleted_filename). Note that searching file content is only
            available for Dropbox Business accounts.
        :type mode: :class:`dropbox.files.SearchMode`
        :rtype: :class:`dropbox.files.SearchResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.SearchError`
        """
        arg = files.SearchArg(path,
                              query,
                              start,
                              max_results,
                              mode)
        r = self.request(
            files.search,
            'files',
            arg,
            None,
        )
        return r

    def files_upload(self,
                     f,
                     path,
                     mode=files.WriteMode.add,
                     autorename=False,
                     client_modified=None,
                     mute=False):
        """
        Create a new file with the contents provided in the request. Do not use
        this to upload a file larger than 150 MB. Instead, create an upload
        session with :meth:`files_upload_session_start`.

        :param bytes f: Contents to upload.
        :param str path: Path in the user's Dropbox to save the file.
        :param mode: Selects what to do if the file already exists.
        :type mode: :class:`dropbox.files.WriteMode`
        :param bool autorename: If there's a conflict, as determined by
            ``mode``, have the Dropbox server try to autorename the file to
            avoid conflict.
        :param Nullable client_modified: The value to store as the
            ``client_modified`` timestamp. Dropbox automatically records the
            time at which the file was written to the Dropbox servers. It can
            also record an additional timestamp, provided by Dropbox desktop
            clients, mobile clients, and API apps of when the file was actually
            created or modified.
        :param bool mute: Normally, users are made aware of any file
            modifications in their Dropbox account via notifications in the
            client software. If ``True``, this tells the clients that this
            modification shouldn't result in a user notification.
        :rtype: :class:`dropbox.files.FileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadError`
        """
        arg = files.CommitInfo(path,
                               mode,
                               autorename,
                               client_modified,
                               mute)
        r = self.request(
            files.upload,
            'files',
            arg,
            f,
        )
        return r

    def files_upload_session_append(self,
                                    f,
                                    session_id,
                                    offset):
        """
        Append more data to an upload session. A single request should not
        upload more than 150 MB of file contents.

        :param bytes f: Contents to upload.
        :param str session_id: The upload session ID (returned by
            :meth:`files_upload_session_start`).
        :param long offset: The amount of data that has been uploaded so far. We
            use this to make sure upload data isn't lost or duplicated in the
            event of a network error.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadSessionLookupError`
        """
        warnings.warn(
            'upload_session/append is deprecated. Use upload_session/append_v2.',
            DeprecationWarning,
        )
        arg = files.UploadSessionCursor(session_id,
                                        offset)
        r = self.request(
            files.upload_session_append,
            'files',
            arg,
            f,
        )
        return None

    def files_upload_session_append_v2(self,
                                       f,
                                       cursor,
                                       close=False):
        """
        Append more data to an upload session. When the parameter close is set,
        this call will close the session. A single request should not upload
        more than 150 MB of file contents.

        :param bytes f: Contents to upload.
        :param cursor: Contains the upload session ID and the offset.
        :type cursor: :class:`dropbox.files.UploadSessionCursor`
        :param bool close: If true, the current session will be closed, at which
            point you won't be able to call
            :meth:`files_upload_session_append_v2` anymore with the current
            session.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadSessionLookupError`
        """
        arg = files.UploadSessionAppendArg(cursor,
                                           close)
        r = self.request(
            files.upload_session_append_v2,
            'files',
            arg,
            f,
        )
        return None

    def files_upload_session_finish(self,
                                    f,
                                    cursor,
                                    commit):
        """
        Finish an upload session and save the uploaded data to the given file
        path. A single request should not upload more than 150 MB of file
        contents.

        :param bytes f: Contents to upload.
        :param cursor: Contains the upload session ID and the offset.
        :type cursor: :class:`dropbox.files.UploadSessionCursor`
        :param commit: Contains the path and other optional modifiers for the
            commit.
        :type commit: :class:`dropbox.files.CommitInfo`
        :rtype: :class:`dropbox.files.FileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadSessionFinishError`
        """
        arg = files.UploadSessionFinishArg(cursor,
                                           commit)
        r = self.request(
            files.upload_session_finish,
            'files',
            arg,
            f,
        )
        return r

    def files_upload_session_finish_batch(self,
                                          entries):
        """
        This route helps you commit many files at once into a user's Dropbox.
        Use :meth:`files_upload_session_start` and
        :meth:`files_upload_session_append_v2` to upload file contents. We
        recommend uploading many files in parallel to increase throughput. Once
        the file contents have been uploaded, rather than calling
        :meth:`files_upload_session_finish`, use this route to finish all your
        upload sessions in a single request. ``UploadSessionStartArg.close`` or
        ``UploadSessionAppendArg.close`` needs to be true for the last
        :meth:`files_upload_session_start` or
        :meth:`files_upload_session_append_v2` call. This route will return a
        job_id immediately and do the async commit job in background. Use
        :meth:`files_upload_session_finish_batch_check` to check the job status.
        For the same account, this route should be executed serially. That means
        you should not start the next job before current job finishes. We allow
        up to 1000 entries in a single request.

        :param list entries: Commit information for each file in the batch.
        :rtype: :class:`dropbox.files.LaunchEmptyResult`
        """
        arg = files.UploadSessionFinishBatchArg(entries)
        r = self.request(
            files.upload_session_finish_batch,
            'files',
            arg,
            None,
        )
        return r

    def files_upload_session_finish_batch_check(self,
                                                async_job_id):
        """
        Returns the status of an asynchronous job for
        :meth:`files_upload_session_finish_batch`. If success, it returns list
        of result for each entry.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.files.UploadSessionFinishBatchJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            files.upload_session_finish_batch_check,
            'files',
            arg,
            None,
        )
        return r

    def files_upload_session_start(self,
                                   f,
                                   close=False):
        """
        Upload sessions allow you to upload a single file in one or more
        requests, for example where the size of the file is greater than 150 MB.
        This call starts a new upload session with the given data. You can then
        use :meth:`files_upload_session_append_v2` to add more data and
        :meth:`files_upload_session_finish` to save all the data to a file in
        Dropbox. A single request should not upload more than 150 MB of file
        contents.

        :param bytes f: Contents to upload.
        :param bool close: If true, the current session will be closed, at which
            point you won't be able to call
            :meth:`files_upload_session_append_v2` anymore with the current
            session.
        :rtype: :class:`dropbox.files.UploadSessionStartResult`
        """
        arg = files.UploadSessionStartArg(close)
        r = self.request(
            files.upload_session_start,
            'files',
            arg,
            f,
        )
        return r

    # ------------------------------------------
    # Routes in sharing namespace

    def sharing_add_file_member(self,
                                file,
                                members,
                                custom_message=None,
                                quiet=False,
                                access_level=sharing.AccessLevel.viewer,
                                add_message_as_comment=False):
        """
        Adds specified members to a file.

        :param str file: File to which to add members.
        :param list members: Members to add. Note that even an email address is
            given, this may result in a user being directy added to the
            membership if that email is the user's main account email.
        :param Nullable custom_message: Message to send to added members in
            their invitation.
        :param bool quiet: Whether added members should be notified via device
            notifications of their invitation.
        :param access_level: AccessLevel union object, describing what access
            level we want to give new members.
        :type access_level: :class:`dropbox.sharing.AccessLevel`
        :param bool add_message_as_comment: If the custom message should be
            added as a comment on the file.
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.AddFileMemberError`
        """
        arg = sharing.AddFileMemberArgs(file,
                                        members,
                                        custom_message,
                                        quiet,
                                        access_level,
                                        add_message_as_comment)
        r = self.request(
            sharing.add_file_member,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_add_folder_member(self,
                                  shared_folder_id,
                                  members,
                                  quiet=False,
                                  custom_message=None):
        """
        Allows an owner or editor (if the ACL update policy allows) of a shared
        folder to add another member. For the new member to get access to all
        the functionality for this folder, you will need to call
        :meth:`sharing_mount_folder` on their behalf. Apps must have full
        Dropbox access to use this endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param list members: The intended list of members to add.  Added members
            will receive invites to join the shared folder.
        :param bool quiet: Whether added members should be notified via email
            and device notifications of their invite.
        :param Nullable custom_message: Optional message to display to added
            members in their invitation.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.AddFolderMemberError`
        """
        arg = sharing.AddFolderMemberArg(shared_folder_id,
                                         members,
                                         quiet,
                                         custom_message)
        r = self.request(
            sharing.add_folder_member,
            'sharing',
            arg,
            None,
        )
        return None

    def sharing_change_file_member_access(self,
                                          file,
                                          member,
                                          access_level):
        """
        Changes a member's access on a shared file.

        :param str file: File for which we are changing a member's access.
        :param member: The member whose access we are changing.
        :type member: :class:`dropbox.sharing.MemberSelector`
        :param access_level: The new access level for the member.
        :type access_level: :class:`dropbox.sharing.AccessLevel`
        :rtype: :class:`dropbox.sharing.FileMemberActionResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.FileMemberActionError`
        """
        arg = sharing.ChangeFileMemberAccessArgs(file,
                                                 member,
                                                 access_level)
        r = self.request(
            sharing.change_file_member_access,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_check_job_status(self,
                                 async_job_id):
        """
        Returns the status of an asynchronous job. Apps must have full Dropbox
        access to use this endpoint.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.sharing.JobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            sharing.check_job_status,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_check_remove_member_job_status(self,
                                               async_job_id):
        """
        Returns the status of an asynchronous job for sharing a folder. Apps
        must have full Dropbox access to use this endpoint.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.sharing.RemoveMemberJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            sharing.check_remove_member_job_status,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_check_share_job_status(self,
                                       async_job_id):
        """
        Returns the status of an asynchronous job for sharing a folder. Apps
        must have full Dropbox access to use this endpoint.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.sharing.ShareFolderJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.PollError`
        """
        arg = async.PollArg(async_job_id)
        r = self.request(
            sharing.check_share_job_status,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_create_shared_link(self,
                                   path,
                                   short_url=False,
                                   pending_upload=None):
        """
        Create a shared link. If a shared link already exists for the given
        path, that link is returned. Note that in the returned
        :class:`dropbox.sharing.PathLinkMetadata`, the ``PathLinkMetadata.url``
        field is the shortened URL if ``CreateSharedLinkArg.short_url`` argument
        is set to ``True``. Previously, it was technically possible to break a
        shared link by moving or renaming the corresponding file or folder. In
        the future, this will no longer be the case, so your app shouldn't rely
        on this behavior. Instead, if your app needs to revoke a shared link,
        use :meth:`sharing_revoke_shared_link`.

        :param str path: The path to share.
        :param bool short_url: Whether to return a shortened URL.
        :param Nullable pending_upload: If it's okay to share a path that does
            not yet exist, set this to either ``PendingUploadMode.file`` or
            ``PendingUploadMode.folder`` to indicate whether to assume it's a
            file or folder.
        :rtype: :class:`dropbox.sharing.PathLinkMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.CreateSharedLinkError`
        """
        warnings.warn(
            'create_shared_link is deprecated. Use create_shared_link_with_settings.',
            DeprecationWarning,
        )
        arg = sharing.CreateSharedLinkArg(path,
                                          short_url,
                                          pending_upload)
        r = self.request(
            sharing.create_shared_link,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_create_shared_link_with_settings(self,
                                                 path,
                                                 settings=None):
        """
        Create a shared link with custom settings. If no settings are given then
        the default visibility is ``RequestedVisibility.public`` (The resolved
        visibility, though, may depend on other aspects such as team and shared
        folder settings).

        :param str path: The path to be shared by the shared link
        :param Nullable settings: The requested settings for the newly created
            shared link
        :rtype: :class:`dropbox.sharing.SharedLinkMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.CreateSharedLinkWithSettingsError`
        """
        arg = sharing.CreateSharedLinkWithSettingsArg(path,
                                                      settings)
        r = self.request(
            sharing.create_shared_link_with_settings,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_get_file_metadata(self,
                                  file,
                                  actions=None):
        """
        Returns shared file metadata.

        :param str file: The file to query.
        :param Nullable actions: File actions to query.
        :rtype: :class:`dropbox.sharing.SharedFileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.GetFileMetadataError`
        """
        arg = sharing.GetFileMetadataArg(file,
                                         actions)
        r = self.request(
            sharing.get_file_metadata,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_get_file_metadata_batch(self,
                                        files,
                                        actions=None):
        """
        Returns shared file metadata.

        :param list files: The files to query.
        :param Nullable actions: File actions to query.
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharingUserError`
        """
        arg = sharing.GetFileMetadataBatchArg(files,
                                              actions)
        r = self.request(
            sharing.get_file_metadata_batch,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_get_folder_metadata(self,
                                    shared_folder_id,
                                    actions=None):
        """
        Returns shared folder metadata by its folder ID. Apps must have full
        Dropbox access to use this endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param Nullable actions: This is a list indicating whether the returned
            folder data will include a boolean value  ``FolderPermission.allow``
            that describes whether the current user can perform the
            FolderAction on the folder.
        :rtype: :class:`dropbox.sharing.SharedFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharedFolderAccessError`
        """
        arg = sharing.GetMetadataArgs(shared_folder_id,
                                      actions)
        r = self.request(
            sharing.get_folder_metadata,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_get_shared_link_file(self,
                                     url,
                                     path=None,
                                     link_password=None):
        """
        Download the shared link's file from a user's Dropbox.

        :param str url: URL of the shared link.
        :param Nullable path: If the shared link is to a folder, this parameter
            can be used to retrieve the metadata for a specific file or
            sub-folder in this folder. A relative path should be used.
        :param Nullable link_password: If the shared link has a password, this
            parameter can be used.
        :rtype: (:class:`dropbox.sharing.SharedLinkMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.GetSharedLinkFileError`

        If you do not consume the entire response body, then you must call close
        on the response object, otherwise you will max out your available
        connections. We recommend using the `contextlib.closing
        <https://docs.python.org/2/library/contextlib.html#contextlib.closing>`_
        context manager to ensure this.
        """
        arg = sharing.GetSharedLinkMetadataArg(url,
                                               path,
                                               link_password)
        r = self.request(
            sharing.get_shared_link_file,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_get_shared_link_file_to_file(self,
                                             download_path,
                                             url,
                                             path=None,
                                             link_password=None):
        """
        Download the shared link's file from a user's Dropbox.

        :param str download_path: Path on local machine to save file.
        :param str url: URL of the shared link.
        :param Nullable path: If the shared link is to a folder, this parameter
            can be used to retrieve the metadata for a specific file or
            sub-folder in this folder. A relative path should be used.
        :param Nullable link_password: If the shared link has a password, this
            parameter can be used.
        :rtype: (:class:`dropbox.sharing.SharedLinkMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.GetSharedLinkFileError`
        """
        arg = sharing.GetSharedLinkMetadataArg(url,
                                               path,
                                               link_password)
        r = self.request(
            sharing.get_shared_link_file,
            'sharing',
            arg,
            None,
        )
        self._save_body_to_file(download_path, r[1])
        return r[0]

    def sharing_get_shared_link_metadata(self,
                                         url,
                                         path=None,
                                         link_password=None):
        """
        Get the shared link's metadata.

        :param str url: URL of the shared link.
        :param Nullable path: If the shared link is to a folder, this parameter
            can be used to retrieve the metadata for a specific file or
            sub-folder in this folder. A relative path should be used.
        :param Nullable link_password: If the shared link has a password, this
            parameter can be used.
        :rtype: :class:`dropbox.sharing.SharedLinkMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharedLinkError`
        """
        arg = sharing.GetSharedLinkMetadataArg(url,
                                               path,
                                               link_password)
        r = self.request(
            sharing.get_shared_link_metadata,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_get_shared_links(self,
                                 path=None):
        """
        Returns a list of :class:`dropbox.sharing.LinkMetadata` objects for this
        user, including collection links. If no path is given, returns a list of
        all shared links for the current user, including collection links. If a
        non-empty path is given, returns a list of all shared links that allow
        access to the given path.  Collection links are never returned in this
        case. Note that the url field in the response is never the shortened
        URL.

        :param Nullable path: See :meth:`sharing_get_shared_links` description.
        :rtype: :class:`dropbox.sharing.GetSharedLinksResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.GetSharedLinksError`
        """
        warnings.warn(
            'get_shared_links is deprecated. Use list_shared_links.',
            DeprecationWarning,
        )
        arg = sharing.GetSharedLinksArg(path)
        r = self.request(
            sharing.get_shared_links,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_file_members(self,
                                  file,
                                  actions=None,
                                  include_inherited=True,
                                  limit=100):
        """
        Use to obtain the members who have been invited to a file, both
        inherited and uninherited members.

        :param str file: The file for which you want to see members.
        :param Nullable actions: The actions for which to return permissions on
            a member
        :param bool include_inherited: Whether to include members who only have
            access from a parent shared folder.
        :param long limit: Number of members to return max per query. Defaults
            to 100 if no limit is specified.
        :rtype: :class:`dropbox.sharing.SharedFileMembers`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFileMembersError`
        """
        arg = sharing.ListFileMembersArg(file,
                                         actions,
                                         include_inherited,
                                         limit)
        r = self.request(
            sharing.list_file_members,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_file_members_batch(self,
                                        files,
                                        limit=10):
        """
        Get members of multiple files at once. The arguments to this route are
        more limited, and the limit on query result size per file is more
        strict. To customize the results more, use the individual file endpoint.
        Inherited users are not included in the result, and permissions are not
        returned for this endpoint.

        :param list files: Files for which to return members.
        :param long limit: Number of members to return max per query. Defaults
            to 10 if no limit is specified.
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharingUserError`
        """
        arg = sharing.ListFileMembersBatchArg(files,
                                              limit)
        r = self.request(
            sharing.list_file_members_batch,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_file_members_continue(self,
                                           cursor):
        """
        Once a cursor has been retrieved from :meth:`sharing_list_file_members`
        or :meth:`sharing_list_file_members_batch`, use this to paginate through
        all shared file members.

        :param str cursor: The cursor returned by your last call to
            :meth:`sharing_list_file_members`,
            :meth:`sharing_list_file_members_continue`, or
            :meth:`sharing_list_file_members_batch`.
        :rtype: :class:`dropbox.sharing.SharedFileMembers`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFileMembersContinueError`
        """
        arg = sharing.ListFileMembersContinueArg(cursor)
        r = self.request(
            sharing.list_file_members_continue,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_folder_members(self,
                                    shared_folder_id,
                                    actions=None,
                                    limit=1000):
        """
        Returns shared folder membership by its folder ID. Apps must have full
        Dropbox access to use this endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :rtype: :class:`dropbox.sharing.SharedFolderMembers`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharedFolderAccessError`
        """
        arg = sharing.ListFolderMembersArgs(shared_folder_id,
                                            actions,
                                            limit)
        r = self.request(
            sharing.list_folder_members,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_folder_members_continue(self,
                                             cursor):
        """
        Once a cursor has been retrieved from
        :meth:`sharing_list_folder_members`, use this to paginate through all
        shared folder members. Apps must have full Dropbox access to use this
        endpoint.

        :param str cursor: The cursor returned by your last call to
            :meth:`sharing_list_folder_members` or
            :meth:`sharing_list_folder_members_continue`.
        :rtype: :class:`dropbox.sharing.SharedFolderMembers`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFolderMembersContinueError`
        """
        arg = sharing.ListFolderMembersContinueArg(cursor)
        r = self.request(
            sharing.list_folder_members_continue,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_folders(self,
                             limit=1000,
                             actions=None):
        """
        Return the list of all shared folders the current user has access to.
        Apps must have full Dropbox access to use this endpoint.

        :param long limit: The maximum number of results to return per request.
        :param Nullable actions: This is a list indicating whether each returned
            folder data entry will include a boolean field
            ``FolderPermission.allow`` that describes whether the current user
            can perform the `FolderAction` on the folder.
        :rtype: :class:`dropbox.sharing.ListFoldersResult`
        """
        arg = sharing.ListFoldersArgs(limit,
                                      actions)
        r = self.request(
            sharing.list_folders,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_folders_continue(self,
                                      cursor):
        """
        Once a cursor has been retrieved from :meth:`sharing_list_folders`, use
        this to paginate through all shared folders. The cursor must come from a
        previous call to :meth:`sharing_list_folders` or
        :meth:`sharing_list_folders_continue`. Apps must have full Dropbox
        access to use this endpoint.

        :param str cursor: The cursor returned by the previous API call
            specified in the endpoint description.
        :rtype: :class:`dropbox.sharing.ListFoldersResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFoldersContinueError`
        """
        arg = sharing.ListFoldersContinueArg(cursor)
        r = self.request(
            sharing.list_folders_continue,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_mountable_folders(self,
                                       limit=1000,
                                       actions=None):
        """
        Return the list of all shared folders the current user can mount or
        unmount. Apps must have full Dropbox access to use this endpoint.

        :param long limit: The maximum number of results to return per request.
        :param Nullable actions: This is a list indicating whether each returned
            folder data entry will include a boolean field
            ``FolderPermission.allow`` that describes whether the current user
            can perform the `FolderAction` on the folder.
        :rtype: :class:`dropbox.sharing.ListFoldersResult`
        """
        arg = sharing.ListFoldersArgs(limit,
                                      actions)
        r = self.request(
            sharing.list_mountable_folders,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_mountable_folders_continue(self,
                                                cursor):
        """
        Once a cursor has been retrieved from
        :meth:`sharing_list_mountable_folders`, use this to paginate through all
        mountable shared folders. The cursor must come from a previous call to
        :meth:`sharing_list_mountable_folders` or
        :meth:`sharing_list_mountable_folders_continue`. Apps must have full
        Dropbox access to use this endpoint.

        :param str cursor: The cursor returned by the previous API call
            specified in the endpoint description.
        :rtype: :class:`dropbox.sharing.ListFoldersResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFoldersContinueError`
        """
        arg = sharing.ListFoldersContinueArg(cursor)
        r = self.request(
            sharing.list_mountable_folders_continue,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_received_files(self,
                                    limit=100,
                                    actions=None):
        """
        Returns a list of all files shared with current user.  Does not include
        files the user has received via shared folders, and does  not include
        unclaimed invitations.

        :param long limit: Number of files to return max per query. Defaults to
            100 if no limit is specified.
        :param Nullable actions: File actions to query.
        :rtype: :class:`dropbox.sharing.ListFilesResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharingUserError`
        """
        arg = sharing.ListFilesArg(limit,
                                   actions)
        r = self.request(
            sharing.list_received_files,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_received_files_continue(self,
                                             cursor):
        """
        Get more results with a cursor from :meth:`sharing_list_received_files`.

        :param str cursor: Cursor in ``ListFilesResult.cursor``
        :rtype: :class:`dropbox.sharing.ListFilesResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFilesContinueError`
        """
        arg = sharing.ListFilesContinueArg(cursor)
        r = self.request(
            sharing.list_received_files_continue,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_list_shared_links(self,
                                  path=None,
                                  cursor=None,
                                  direct_only=None):
        """
        List shared links of this user. If no path is given, returns a list of
        all shared links for the current user. If a non-empty path is given,
        returns a list of all shared links that allow access to the given path -
        direct links to the given path and links to parent folders of the given
        path. Links to parent folders can be suppressed by setting direct_only
        to true.

        :param Nullable path: See :meth:`sharing_list_shared_links` description.
        :param Nullable cursor: The cursor returned by your last call to
            :meth:`sharing_list_shared_links`.
        :param Nullable direct_only: See :meth:`sharing_list_shared_links`
            description.
        :rtype: :class:`dropbox.sharing.ListSharedLinksResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListSharedLinksError`
        """
        arg = sharing.ListSharedLinksArg(path,
                                         cursor,
                                         direct_only)
        r = self.request(
            sharing.list_shared_links,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_modify_shared_link_settings(self,
                                            url,
                                            settings,
                                            remove_expiration=False):
        """
        Modify the shared link's settings. If the requested visibility conflict
        with the shared links policy of the team or the shared folder (in case
        the linked file is part of a shared folder) then the
        ``LinkPermissions.resolved_visibility`` of the returned
        :class:`dropbox.sharing.SharedLinkMetadata` will reflect the actual
        visibility of the shared link and the
        ``LinkPermissions.requested_visibility`` will reflect the requested
        visibility.

        :param str url: URL of the shared link to change its settings
        :param settings: Set of settings for the shared link.
        :type settings: :class:`dropbox.sharing.SharedLinkSettings`
        :param bool remove_expiration: If set to true, removes the expiration of
            the shared link.
        :rtype: :class:`dropbox.sharing.SharedLinkMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ModifySharedLinkSettingsError`
        """
        arg = sharing.ModifySharedLinkSettingsArgs(url,
                                                   settings,
                                                   remove_expiration)
        r = self.request(
            sharing.modify_shared_link_settings,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_mount_folder(self,
                             shared_folder_id):
        """
        The current user mounts the designated folder. Mount a shared folder for
        a user after they have been added as a member. Once mounted, the shared
        folder will appear in their Dropbox. Apps must have full Dropbox access
        to use this endpoint.

        :param str shared_folder_id: The ID of the shared folder to mount.
        :rtype: :class:`dropbox.sharing.SharedFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.MountFolderError`
        """
        arg = sharing.MountFolderArg(shared_folder_id)
        r = self.request(
            sharing.mount_folder,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_relinquish_file_membership(self,
                                           file):
        """
        The current user relinquishes their membership in the designated file.
        Note that the current user may still have inherited access to this file
        through the parent folder. Apps must have full Dropbox access to use
        this endpoint.

        :param str file: The path or id for the file.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RelinquishFileMembershipError`
        """
        arg = sharing.RelinquishFileMembershipArg(file)
        r = self.request(
            sharing.relinquish_file_membership,
            'sharing',
            arg,
            None,
        )
        return None

    def sharing_relinquish_folder_membership(self,
                                             shared_folder_id,
                                             leave_a_copy=False):
        """
        The current user relinquishes their membership in the designated shared
        folder and will no longer have access to the folder.  A folder owner
        cannot relinquish membership in their own folder. This will run
        synchronously if leave_a_copy is false, and asynchronously if
        leave_a_copy is true. Apps must have full Dropbox access to use this
        endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param bool leave_a_copy: Keep a copy of the folder's contents upon
            relinquishing membership.
        :rtype: :class:`dropbox.sharing.LaunchEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RelinquishFolderMembershipError`
        """
        arg = sharing.RelinquishFolderMembershipArg(shared_folder_id,
                                                    leave_a_copy)
        r = self.request(
            sharing.relinquish_folder_membership,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_remove_file_member(self,
                                   file,
                                   member):
        """
        Identical to remove_file_member_2 but with less information returned.

        :param str file: File from which to remove members.
        :param member: Member to remove from this file. Note that even if an
            email is specified, it may result in the removal of a user (not an
            invitee) if the user's main account corresponds to that email
            address.
        :type member: :class:`dropbox.sharing.MemberSelector`
        :rtype: :class:`dropbox.sharing.FileMemberActionIndividualResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RemoveFileMemberError`
        """
        warnings.warn(
            'remove_file_member is deprecated. Use remove_file_member_2.',
            DeprecationWarning,
        )
        arg = sharing.RemoveFileMemberArg(file,
                                          member)
        r = self.request(
            sharing.remove_file_member,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_remove_file_member_2(self,
                                     file,
                                     member):
        """
        Removes a specified member from the file.

        :param str file: File from which to remove members.
        :param member: Member to remove from this file. Note that even if an
            email is specified, it may result in the removal of a user (not an
            invitee) if the user's main account corresponds to that email
            address.
        :type member: :class:`dropbox.sharing.MemberSelector`
        :rtype: :class:`dropbox.sharing.FileMemberRemoveActionResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RemoveFileMemberError`
        """
        arg = sharing.RemoveFileMemberArg(file,
                                          member)
        r = self.request(
            sharing.remove_file_member_2,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_remove_folder_member(self,
                                     shared_folder_id,
                                     member,
                                     leave_a_copy):
        """
        Allows an owner or editor (if the ACL update policy allows) of a shared
        folder to remove another member. Apps must have full Dropbox access to
        use this endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param member: The member to remove from the folder.
        :type member: :class:`dropbox.sharing.MemberSelector`
        :param bool leave_a_copy: If true, the removed user will keep their copy
            of the folder after it's unshared, assuming it was mounted.
            Otherwise, it will be removed from their Dropbox. Also, this must be
            set to false when kicking a group.
        :rtype: :class:`dropbox.sharing.LaunchResultBase`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RemoveFolderMemberError`
        """
        arg = sharing.RemoveFolderMemberArg(shared_folder_id,
                                            member,
                                            leave_a_copy)
        r = self.request(
            sharing.remove_folder_member,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_revoke_shared_link(self,
                                   url):
        """
        Revoke a shared link. Note that even after revoking a shared link to a
        file, the file may be accessible if there are shared links leading to
        any of the file parent folders. To list all shared links that enable
        access to a specific file, you can use the
        :meth:`sharing_list_shared_links` with the file as the
        ``ListSharedLinksArg.path`` argument.

        :param str url: URL of the shared link.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RevokeSharedLinkError`
        """
        arg = sharing.RevokeSharedLinkArg(url)
        r = self.request(
            sharing.revoke_shared_link,
            'sharing',
            arg,
            None,
        )
        return None

    def sharing_share_folder(self,
                             path,
                             member_policy=sharing.MemberPolicy.anyone,
                             acl_update_policy=sharing.AclUpdatePolicy.owner,
                             shared_link_policy=sharing.SharedLinkPolicy.anyone,
                             force_async=False):
        """
        Share a folder with collaborators. Most sharing will be completed
        synchronously. Large folders will be completed asynchronously. To make
        testing the async case repeatable, set `ShareFolderArg.force_async`. If
        a ``ShareFolderLaunch.async_job_id`` is returned, you'll need to call
        :meth:`sharing_check_share_job_status` until the action completes to get
        the metadata for the folder. Apps must have full Dropbox access to use
        this endpoint.

        :param str path: The path to the folder to share. If it does not exist,
            then a new one is created.
        :param member_policy: Who can be a member of this shared folder. Only
            applicable if the current user is on a team.
        :type member_policy: :class:`dropbox.sharing.MemberPolicy`
        :param acl_update_policy: Who can add and remove members of this shared
            folder.
        :type acl_update_policy: :class:`dropbox.sharing.AclUpdatePolicy`
        :param shared_link_policy: The policy to apply to shared links created
            for content inside this shared folder.  The current user must be on
            a team to set this policy to ``SharedLinkPolicy.members``.
        :type shared_link_policy: :class:`dropbox.sharing.SharedLinkPolicy`
        :param bool force_async: Whether to force the share to happen
            asynchronously.
        :rtype: :class:`dropbox.sharing.ShareFolderLaunch`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ShareFolderError`
        """
        arg = sharing.ShareFolderArg(path,
                                     member_policy,
                                     acl_update_policy,
                                     shared_link_policy,
                                     force_async)
        r = self.request(
            sharing.share_folder,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_transfer_folder(self,
                                shared_folder_id,
                                to_dropbox_id):
        """
        Transfer ownership of a shared folder to a member of the shared folder.
        User must have ``AccessLevel.owner`` access to the shared folder to
        perform a transfer. Apps must have full Dropbox access to use this
        endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param str to_dropbox_id: A account or team member ID to transfer
            ownership to.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.TransferFolderError`
        """
        arg = sharing.TransferFolderArg(shared_folder_id,
                                        to_dropbox_id)
        r = self.request(
            sharing.transfer_folder,
            'sharing',
            arg,
            None,
        )
        return None

    def sharing_unmount_folder(self,
                               shared_folder_id):
        """
        The current user unmounts the designated folder. They can re-mount the
        folder at a later time using :meth:`sharing_mount_folder`. Apps must
        have full Dropbox access to use this endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UnmountFolderError`
        """
        arg = sharing.UnmountFolderArg(shared_folder_id)
        r = self.request(
            sharing.unmount_folder,
            'sharing',
            arg,
            None,
        )
        return None

    def sharing_unshare_file(self,
                             file):
        """
        Remove all members from this file. Does not remove inherited members.

        :param str file: The file to unshare.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UnshareFileError`
        """
        arg = sharing.UnshareFileArg(file)
        r = self.request(
            sharing.unshare_file,
            'sharing',
            arg,
            None,
        )
        return None

    def sharing_unshare_folder(self,
                               shared_folder_id,
                               leave_a_copy=False):
        """
        Allows a shared folder owner to unshare the folder. You'll need to call
        :meth:`sharing_check_job_status` to determine if the action has
        completed successfully. Apps must have full Dropbox access to use this
        endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param bool leave_a_copy: If true, members of this shared folder will
            get a copy of this folder after it's unshared. Otherwise, it will be
            removed from their Dropbox. The current user, who is an owner, will
            always retain their copy.
        :rtype: :class:`dropbox.sharing.LaunchEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UnshareFolderError`
        """
        arg = sharing.UnshareFolderArg(shared_folder_id,
                                       leave_a_copy)
        r = self.request(
            sharing.unshare_folder,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_update_folder_member(self,
                                     shared_folder_id,
                                     member,
                                     access_level):
        """
        Allows an owner or editor of a shared folder to update another member's
        permissions. Apps must have full Dropbox access to use this endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param member: The member of the shared folder to update.  Only the
            ``MemberSelector.dropbox_id`` may be set at this time.
        :type member: :class:`dropbox.sharing.MemberSelector`
        :param access_level: The new access level for ``member``.
            ``AccessLevel.owner`` is disallowed.
        :type access_level: :class:`dropbox.sharing.AccessLevel`
        :rtype: :class:`dropbox.sharing.MemberAccessLevelResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UpdateFolderMemberError`
        """
        arg = sharing.UpdateFolderMemberArg(shared_folder_id,
                                            member,
                                            access_level)
        r = self.request(
            sharing.update_folder_member,
            'sharing',
            arg,
            None,
        )
        return r

    def sharing_update_folder_policy(self,
                                     shared_folder_id,
                                     member_policy=None,
                                     acl_update_policy=None,
                                     shared_link_policy=None):
        """
        Update the sharing policies for a shared folder. User must have
        ``AccessLevel.owner`` access to the shared folder to update its
        policies. Apps must have full Dropbox access to use this endpoint.

        :param str shared_folder_id: The ID for the shared folder.
        :param Nullable member_policy: Who can be a member of this shared
            folder. Only applicable if the current user is on a team.
        :param Nullable acl_update_policy: Who can add and remove members of
            this shared folder.
        :param Nullable shared_link_policy: The policy to apply to shared links
            created for content inside this shared folder. The current user must
            be on a team to set this policy to ``SharedLinkPolicy.members``.
        :rtype: :class:`dropbox.sharing.SharedFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UpdateFolderPolicyError`
        """
        arg = sharing.UpdateFolderPolicyArg(shared_folder_id,
                                            member_policy,
                                            acl_update_policy,
                                            shared_link_policy)
        r = self.request(
            sharing.update_folder_policy,
            'sharing',
            arg,
            None,
        )
        return r

    # ------------------------------------------
    # Routes in users namespace

    def users_get_account(self,
                          account_id):
        """
        Get information about a user's account.

        :param str account_id: A user's account identifier.
        :rtype: :class:`dropbox.users.BasicAccount`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.users.GetAccountError`
        """
        arg = users.GetAccountArg(account_id)
        r = self.request(
            users.get_account,
            'users',
            arg,
            None,
        )
        return r

    def users_get_account_batch(self,
                                account_ids):
        """
        Get information about multiple user accounts.  At most 300 accounts may
        be queried per request.

        :param list account_ids: List of user account identifiers.  Should not
            contain any duplicate account IDs.
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.users.GetAccountBatchError`
        """
        arg = users.GetAccountBatchArg(account_ids)
        r = self.request(
            users.get_account_batch,
            'users',
            arg,
            None,
        )
        return r

    def users_get_current_account(self):
        """
        Get information about the current user's account.

        :rtype: :class:`dropbox.users.FullAccount`
        """
        arg = None
        r = self.request(
            users.get_current_account,
            'users',
            arg,
            None,
        )
        return r

    def users_get_space_usage(self):
        """
        Get the space usage information for the current user's account.

        :rtype: :class:`dropbox.users.SpaceUsage`
        """
        arg = None
        r = self.request(
            users.get_space_usage,
            'users',
            arg,
            None,
        )
        return r

